/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.BatchExecutor;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.StorageControlClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@VisibleForTesting
class DeleteFolderOperation {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private static final ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;
    private static final ErrorTypeExtractor errorTypeExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private final GoogleCloudStorageOptions storageOptions;
    private final ConcurrentHashMap.KeySetView<IOException, Boolean> allExceptions;
    private final List<FolderInfo> folders;
    private final BatchExecutor batchExecutor;
    private final StorageControlClient storageControlClient;
    private final BlockingQueue<FolderInfo> folderDeleteBlockingQueue;
    private final ConcurrentHashMap<String, Long> countOfChildren;

    DeleteFolderOperation(List<FolderInfo> folders, GoogleCloudStorageOptions storageOptions, StorageControlClient storageControlClient) {
        this.folders = folders;
        this.storageOptions = storageOptions;
        this.storageControlClient = storageControlClient;
        this.folderDeleteBlockingQueue = new LinkedBlockingQueue<FolderInfo>(folders.size());
        this.batchExecutor = new BatchExecutor(this.storageOptions.getBatchThreads());
        this.allExceptions = ConcurrentHashMap.newKeySet();
        this.countOfChildren = new ConcurrentHashMap();
    }

    public void performDeleteOperation() throws InterruptedException {
        this.computeChildrenForFolderResource();
        for (int folderSize = this.folders.size(); folderSize != 0 && this.encounteredNoExceptions(); --folderSize) {
            FolderInfo folderToDelete = this.getElementFromBlockingQueue();
            this.queueSingleFolderDelete(folderToDelete, 1);
        }
        this.batchExecutorShutdown();
    }

    public boolean encounteredNoExceptions() {
        return this.allExceptions.isEmpty();
    }

    public ConcurrentHashMap.KeySetView<IOException, Boolean> getAllExceptions() {
        return this.allExceptions;
    }

    protected void addToToBatchExecutorQueue(Callable callable, FutureCallback callback) {
        this.batchExecutor.queue(callable, callback);
    }

    protected void queueSingleFolderDelete(@Nonnull FolderInfo folder, int attempt) {
        String bucketName = folder.getBucket();
        String folderName = folder.getFolderName();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)String.format("No bucket for folder resource %s", bucketName));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)folderName) ? 1 : 0) != 0, (Object)String.format("No folder path for folder resource %s", folderName));
        this.addToToBatchExecutorQueue(new DeleteFolderRequestCallable(folder, this.storageControlClient), this.getDeletionCallback(folder, this.allExceptions, attempt));
    }

    protected void successfullDeletionOfFolderResource(FolderInfo folderResource) {
        this.countOfChildren.remove(folderResource.getFolderName());
        String parentFolder = folderResource.getParentFolderName();
        if (this.countOfChildren.containsKey(parentFolder)) {
            this.countOfChildren.replace(parentFolder, this.countOfChildren.get(parentFolder) - 1L);
            if (this.countOfChildren.get(parentFolder) == 0L) {
                this.addFolderResourceInBlockingQueue(new FolderInfo(FolderInfo.createFolderInfoObject(folderResource.getBucket(), parentFolder)));
            }
        }
    }

    private FolderInfo getElementFromBlockingQueue() throws InterruptedException {
        try {
            return this.folderDeleteBlockingQueue.poll(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            ((GoogleLogger.Api)logger.atSevere()).log("Encountered exception while getting an element from queue in HN enabled bucket : %s", (Object)e);
            throw e;
        }
    }

    private void computeChildrenForFolderResource() {
        for (FolderInfo currentFolder : this.folders) {
            String parentFolder;
            if (!this.countOfChildren.containsKey(currentFolder.getFolderName())) {
                this.countOfChildren.put(currentFolder.getFolderName(), 0L);
            }
            if (Strings.isNullOrEmpty((String)(parentFolder = currentFolder.getParentFolderName()))) continue;
            this.countOfChildren.merge(parentFolder, 1L, (oldValue, newValue) -> oldValue + newValue);
        }
        for (FolderInfo currentFolder : this.folders) {
            if (this.countOfChildren.get(currentFolder.getFolderName()) != 0L) continue;
            this.addFolderResourceInBlockingQueue(currentFolder);
        }
    }

    private void batchExecutorShutdown() {
        try {
            this.batchExecutor.shutdown();
        }
        catch (IOException e) {
            this.addException(new IOException(String.format("Error in shutting down batch executor : %s", e.getMessage())));
        }
    }

    private void addFolderResourceInBlockingQueue(FolderInfo folderResource) {
        this.folderDeleteBlockingQueue.add(folderResource);
    }

    private FutureCallback getDeletionCallback(final FolderInfo resourceId, ConcurrentHashMap.KeySetView<IOException, Boolean> allExceptions, final int attempt) {
        return new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                ((GoogleLogger.Api)logger.atFiner()).log("Successfully deleted folder %s", (Object)resourceId.toString());
                DeleteFolderOperation.this.successfullDeletionOfFolderResource(resourceId);
            }

            public void onFailure(Throwable throwable) {
                if (DeleteFolderOperation.this.isErrorType(throwable, ErrorTypeExtractor.ErrorType.NOT_FOUND)) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Delete folder '%s' not found: %s", (Object)resourceId, (Object)throwable.getMessage());
                    DeleteFolderOperation.this.successfullDeletionOfFolderResource(resourceId);
                } else if (DeleteFolderOperation.this.isErrorType(throwable, ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION) && attempt <= 4) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Precondition not met while deleting '%s'. Attempt %s. Retrying:%s", (Object)resourceId, (Object)attempt, (Object)throwable);
                    DeleteFolderOperation.this.queueSingleFolderDelete(resourceId, attempt + 1);
                } else {
                    GoogleCloudStorageEventBus.postOnException();
                    DeleteFolderOperation.this.addException(new IOException(String.format("Error deleting '%s', stage 2", resourceId), throwable));
                }
            }
        };
    }

    private boolean isErrorType(Throwable throwable, ErrorTypeExtractor.ErrorType errorType) {
        return throwable instanceof Exception && errorTypeExtractor.getErrorType((Exception)throwable) == errorType;
    }

    private synchronized void addException(IOException e) {
        this.allExceptions.add(e);
    }

    private class DeleteFolderRequestCallable
    implements Callable<Void> {
        private StorageControlClient storageControlClient;
        private DeleteFolderRequest deleteFolderRequest;

        @Override
        public Void call() {
            this.storageControlClient.deleteFolder(this.deleteFolderRequest);
            return null;
        }

        DeleteFolderRequestCallable(FolderInfo folder, StorageControlClient storageControlClient) {
            Preconditions.checkArgument((storageControlClient != null ? 1 : 0) != 0, (Object)"StorageControlClient cannot be null");
            this.storageControlClient = storageControlClient;
            this.deleteFolderRequest = DeleteFolderRequest.newBuilder().setName(folder.toString()).build();
        }
    }
}

