/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmloutput;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlField;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlOutput;
import org.apache.hop.pipeline.transforms.xml.xmloutput.XmlOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="XMLOutput", image="XOU.svg", name="i18n::XMLOutput.name", description="i18n::XMLOutput.description", categoryDescription="i18n::XMLOutput.category", keywords={"i18n::XmlOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/xmloutput.html")
@InjectionSupported(localizationPrefix="XMLOutput.Injection.", groups={"OUTPUT_FIELDS"})
public class XmlOutputMeta
extends BaseTransformMeta<XmlOutput, XmlOutputData> {
    private static final Class<?> PKG = XmlOutputMeta.class;
    public static final String CONST_SPACES_LONG = "        ";
    public static final String CONST_SPACES = "      ";
    @Injection(name="FILENAME")
    private String fileName;
    @Injection(name="EXTENSION")
    private String extension;
    @Injection(name="SPLIT_EVERY")
    private int splitEvery;
    @Injection(name="INC_TRANSFORMNR_IN_FILENAME")
    private boolean transformNrInFilename;
    @Injection(name="INC_DATE_IN_FILENAME")
    private boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    private boolean timeInFilename;
    @Injection(name="ZIPPED")
    private boolean zipped;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="NAMESPACE")
    private String nameSpace;
    @Injection(name="MAIN_ELEMENT")
    private String mainElement;
    @Injection(name="REPEAT_ELEMENT")
    private String repeatElement;
    @Injection(name="ADD_TO_RESULT")
    private boolean addToResultFilenames;
    @InjectionDeep
    private XmlField[] outputFields;
    @Injection(name="DO_NOT_CREATE_FILE_AT_STARTUP")
    private boolean doNotOpenNewFileInit;
    @Injection(name="OMIT_NULL_VALUES")
    private boolean omitNullValues;
    @Injection(name="SPEFICY_FORMAT")
    private boolean specifyFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    public XmlField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(XmlField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void allocate(int nrFields) {
        this.outputFields = new XmlField[nrFields];
    }

    public Object clone() {
        XmlOutputMeta retval = (XmlOutputMeta)((Object)super.clone());
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (XmlField)this.outputFields[i].clone();
        }
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.setEncoding(XmlHandler.getTagValue((Node)transformNode, (String)"encoding"));
            this.setNameSpace(XmlHandler.getTagValue((Node)transformNode, (String)"name_space"));
            this.setMainElement(XmlHandler.getTagValue((Node)transformNode, (String)"xml_main_element"));
            this.setRepeatElement(XmlHandler.getTagValue((Node)transformNode, (String)"xml_repeat_element"));
            this.setFileName(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name"));
            this.setExtension(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention"), (String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extension")));
            this.setDoNotOpenNewFileInit("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"do_not_open_newfile_init")));
            this.setTransformNrInFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"split")));
            this.setDateInFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_date")));
            this.setTimeInFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_time")));
            this.setSpecifyFormat("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"SpecifyFormat")));
            this.setOmitNullValues("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"omit_null_values")));
            this.setDateTimeFormat(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"date_time_format"));
            this.setAddToResultFiles("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_to_result_filenames")));
            this.setZipped("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"zipped")));
            this.setSplitEvery(Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"splitevery"), (int)0));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new XmlField();
                String contentTypeString = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"content_type"), (String)XmlField.ContentType.Element.name());
                this.outputFields[i].setContentType(XmlField.ContentType.valueOf(contentTypeString));
                String fieldName = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.outputFields[i].setFieldName(fieldName);
                String elementName = XmlHandler.getTagValue((Node)fnode, (String)"element");
                this.outputFields[i].setElementName(elementName == null ? "" : elementName);
                this.outputFields[i].setType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    public void setDefault() {
        this.fileName = "";
        this.extension = "";
        this.transformNrInFilename = false;
        this.doNotOpenNewFileInit = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.addToResultFilenames = false;
        this.zipped = false;
        this.splitEvery = 0;
        this.encoding = "UTF-8";
        this.nameSpace = "";
        this.dateTimeFormat = null;
        this.specifyFormat = false;
        this.omitNullValues = false;
        this.mainElement = "Rows";
        this.repeatElement = "Row";
        int nrFields = 0;
        this.allocate(nrFields);
    }

    public String[] getFiles(IVariables variables) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.transformNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(variables, copy, split, false);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(IVariables variables, int transformnr, int splitnr, boolean ziparchive) {
        SimpleDateFormat daf = new SimpleDateFormat();
        DecimalFormat df = new DecimalFormat("00000");
        Object retval = variables.resolve(this.fileName);
        String realextension = variables.resolve(this.extension);
        Date now = new Date();
        if (this.specifyFormat && !Utils.isEmpty((CharSequence)this.dateTimeFormat)) {
            daf.applyPattern(this.dateTimeFormat);
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (this.dateInFilename) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (this.timeInFilename) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        if (this.transformNrInFilename) {
            retval = (String)retval + "_" + transformnr;
        }
        if (this.splitEvery > 0) {
            retval = (String)retval + "_" + df.format(splitnr + 1);
        }
        if (this.zipped) {
            if (ziparchive) {
                retval = (String)retval + ".zip";
            } else if (!Utils.isEmpty((CharSequence)realextension)) {
                retval = (String)retval + "." + realextension;
            }
        } else if (!Utils.isEmpty((CharSequence)realextension)) {
            retval = (String)retval + "." + realextension;
        }
        return retval;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        for (XmlField field : this.outputFields) {
            IValueMeta v = row.searchValueMeta(field.getFieldName());
            if (v == null) continue;
            v.setLength(field.getLength(), field.getPrecision());
        }
    }

    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        RowMeta row = new RowMeta();
        for (XmlField field : this.outputFields) {
            row.addValueMeta((IValueMeta)new ValueMetaBase(field.getFieldName(), field.getType(), field.getLength(), field.getPrecision()));
        }
        return row;
    }

    public String getXml() {
        StringBuffer retval = new StringBuffer(600);
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"name_space", (String)this.nameSpace));
        retval.append("    ").append(XmlHandler.addTagValue((String)"xml_main_element", (String)this.mainElement));
        retval.append("    ").append(XmlHandler.addTagValue((String)"xml_repeat_element", (String)this.repeatElement));
        retval.append("    <file>").append(Const.CR);
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"omit_null_values", (boolean)this.omitNullValues));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"zipped", (boolean)this.zipped));
        retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (XmlField field : this.outputFields) {
            if (Utils.isEmpty((CharSequence)field.getFieldName())) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"content_type", (String)field.getContentType().name()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (XmlField outputField : this.outputFields) {
                int idx = prev.indexOfValue(outputField.getFieldName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + outputField.getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"XMLOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transforminfo);
        remarks.add((ICheckResult)cr);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMainElement() {
        return this.mainElement;
    }

    public void setMainElement(String mainElement) {
        this.mainElement = mainElement;
    }

    public String getRepeatElement() {
        return this.repeatElement;
    }

    public void setRepeatElement(String repeatElement) {
        this.repeatElement = repeatElement;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming resourceNamingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName), (IVariables)variables);
                this.fileName = resourceNamingInterface.nameResource(fileObject, variables, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

