/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.blockingtransform;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.blockingtransform.BlockingTransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BlockingTransformDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BlockingTransformDialog.class;
    private final BlockingTransformMeta input;
    private Button wPassAllRows;
    private Label wlSpoolDir;
    private Button wbSpoolDir;
    private TextVar wSpoolDir;
    private Label wlPrefix;
    private Text wPrefix;
    private Label wlCacheSize;
    private Text wCacheSize;
    private Label wlCompress;
    private Button wCompress;

    public BlockingTransformDialog(Shell parent, IVariables variables, BlockingTransformMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlPassAllRows = new Label((Composite)this.shell, 131072);
        wlPassAllRows.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.PassAllRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassAllRows);
        FormData fdlUpdate = new FormData();
        fdlUpdate.left = new FormAttachment(0, 0);
        fdlUpdate.right = new FormAttachment(middle, -margin);
        fdlUpdate.top = new FormAttachment((Control)this.wTransformName, margin);
        wlPassAllRows.setLayoutData((Object)fdlUpdate);
        this.wPassAllRows = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wPassAllRows);
        FormData fdUpdate = new FormData();
        fdUpdate.left = new FormAttachment(middle, 0);
        fdUpdate.top = new FormAttachment((Control)wlPassAllRows, 0, 0x1000000);
        fdUpdate.right = new FormAttachment(100, 0);
        this.wPassAllRows.setLayoutData((Object)fdUpdate);
        this.wPassAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockingTransformDialog.this.input.setChanged();
                BlockingTransformDialog.this.setEnableDialog();
            }
        });
        this.wlSpoolDir = new Label((Composite)this.shell, 131072);
        this.wlSpoolDir.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.SpoolDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSpoolDir);
        FormData fdlSpoolDir = new FormData();
        fdlSpoolDir.left = new FormAttachment(0, 0);
        fdlSpoolDir.right = new FormAttachment(middle, -margin);
        fdlSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        this.wlSpoolDir.setLayoutData((Object)fdlSpoolDir);
        this.wbSpoolDir = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbSpoolDir);
        this.wbSpoolDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSpoolDir = new FormData();
        fdbSpoolDir.right = new FormAttachment(100, 0);
        fdbSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        this.wbSpoolDir.setLayoutData((Object)fdbSpoolDir);
        this.wSpoolDir = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSpoolDir);
        this.wSpoolDir.addModifyListener(lsMod);
        FormData fdSpoolDir = new FormData();
        fdSpoolDir.left = new FormAttachment(middle, 0);
        fdSpoolDir.top = new FormAttachment((Control)this.wPassAllRows, margin);
        fdSpoolDir.right = new FormAttachment((Control)this.wbSpoolDir, -margin);
        this.wSpoolDir.setLayoutData((Object)fdSpoolDir);
        this.wSpoolDir.addModifyListener(e -> this.wSpoolDir.setToolTipText(this.variables.resolve(this.wSpoolDir.getText())));
        this.wbSpoolDir.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wSpoolDir, (IVariables)this.variables));
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.Prefix.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPrefix);
        FormData fdlPrefix = new FormData();
        fdlPrefix.left = new FormAttachment(0, 0);
        fdlPrefix.right = new FormAttachment(middle, -margin);
        fdlPrefix.top = new FormAttachment((Control)this.wbSpoolDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        FormData fdPrefix = new FormData();
        fdPrefix.left = new FormAttachment(middle, 0);
        fdPrefix.top = new FormAttachment((Control)this.wbSpoolDir, margin * 2);
        fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)fdPrefix);
        this.wlCacheSize = new Label((Composite)this.shell, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.CacheSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCacheSize);
        FormData fdlCacheSize = new FormData();
        fdlCacheSize.left = new FormAttachment(0, 0);
        fdlCacheSize.right = new FormAttachment(middle, -margin);
        fdlCacheSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.wlCacheSize.setLayoutData((Object)fdlCacheSize);
        this.wCacheSize = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCacheSize);
        this.wCacheSize.addModifyListener(lsMod);
        FormData fdCacheSize = new FormData();
        fdCacheSize.left = new FormAttachment(middle, 0);
        fdCacheSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        fdCacheSize.right = new FormAttachment(100, 0);
        this.wCacheSize.setLayoutData((Object)fdCacheSize);
        this.wlCompress = new Label((Composite)this.shell, 131072);
        this.wlCompress.setText(BaseMessages.getString(PKG, (String)"BlockingTransformDialog.Compress.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCompress);
        FormData fdlCompress = new FormData();
        fdlCompress.left = new FormAttachment(0, 0);
        fdlCompress.right = new FormAttachment(middle, -margin);
        fdlCompress.top = new FormAttachment((Control)this.wCacheSize, margin * 2);
        this.wlCompress.setLayoutData((Object)fdlCompress);
        this.wCompress = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wCompress);
        FormData fdCompress = new FormData();
        fdCompress.left = new FormAttachment(middle, 0);
        fdCompress.top = new FormAttachment((Control)this.wlCompress, 0, 0x1000000);
        fdCompress.right = new FormAttachment(100, 0);
        this.wCompress.setLayoutData((Object)fdCompress);
        this.wCompress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockingTransformDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wCompress);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.setEnableDialog();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wPassAllRows.setSelection(this.input.isPassAllRows());
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSpoolDir.setText(this.input.getDirectory());
        }
        this.wCacheSize.setText("" + this.input.getCacheSize());
        this.wCompress.setSelection(this.input.isCompressFiles());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSpoolDir.getText());
        this.input.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)5000));
        if (this.isDetailed()) {
            this.logDetailed("Compression is set to " + this.wCompress.getSelection());
        }
        this.input.setCompressFiles(this.wCompress.getSelection());
        this.input.setPassAllRows(this.wPassAllRows.getSelection());
        this.dispose();
    }

    private void setEnableDialog() {
        this.wlSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wbSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wSpoolDir.setEnabled(this.wPassAllRows.getSelection());
        this.wlPrefix.setEnabled(this.wPassAllRows.getSelection());
        this.wPrefix.setEnabled(this.wPassAllRows.getSelection());
        this.wlCacheSize.setEnabled(this.wPassAllRows.getSelection());
        this.wCacheSize.setEnabled(this.wPassAllRows.getSelection());
        this.wlCompress.setEnabled(this.wPassAllRows.getSelection());
        this.wCompress.setEnabled(this.wPassAllRows.getSelection());
    }
}

