/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDataSource;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;

class AS400ConnectionPoolAuthentication {
    private int authenticationScheme_ = -1;
    private char[] encodedPassword_ = null;
    private ProfileTokenCredential profileToken_;

    AS400ConnectionPoolAuthentication(char[] password) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400ConnectionPoolAuthentication object (password)");
        }
        if (password == null) {
            Trace.log(1, "Parameter 'password' is null (password prompt may be used).");
        }
        this.encodedPassword_ = password != null ? AS400JDBCDataSource.xpwConfuse(password) : null;
        this.authenticationScheme_ = 0;
    }

    AS400ConnectionPoolAuthentication(ProfileTokenCredential profileToken) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400ConnectionPoolAuthentication object (ProfileTokenCredential)");
        }
        if (profileToken == null) {
            Trace.log(2, "Parameter 'profileToken' is null.");
            throw new NullPointerException("profileToken");
        }
        this.profileToken_ = profileToken;
        this.authenticationScheme_ = 2;
    }

    int getAuthenticationScheme() {
        return this.authenticationScheme_;
    }

    char[] getPassword() {
        if (this.authenticationScheme_ == 0 && this.encodedPassword_ != null) {
            return AS400JDBCDataSource.xpwDeconfuseToChar(this.encodedPassword_);
        }
        return null;
    }

    ProfileTokenCredential getProfileToken() {
        if (this.authenticationScheme_ == 2) {
            return this.profileToken_;
        }
        return null;
    }
}

