/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.math.BigInteger;
import java.util.Arrays;

public class AS400UnsignedBin8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final byte[] MAX_VALUE_BYTES = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int SIZE = 8;
    private static final BigInteger MIN_VALUE = BigInteger.ZERO;
    private static final BigInteger MAX_VALUE = new BigInteger(MAX_VALUE_BYTES);
    private static final BigInteger DEFAULT_VALUE = BigInteger.ZERO;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public int getInstanceType() {
        return 16;
    }

    @Override
    public Class getJavaType() {
        return BigInteger.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[8];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(long longValue) {
        byte[] as400Value = new byte[8];
        this.toBytes(longValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    public int toBytes(long longValue, byte[] as400Value) {
        return this.toBytes(longValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BigInteger bigIntValue = (BigInteger)javaValue;
        if (bigIntValue.compareTo(MIN_VALUE) < 0 || bigIntValue.compareTo(MAX_VALUE) > 0) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        Arrays.fill(as400Value, offset, offset + 8, (byte)0);
        byte[] val = bigIntValue.toByteArray();
        if (val.length == 9 && val[0] == 0) {
            byte[] truncated = new byte[8];
            System.arraycopy(val, 1, truncated, 0, 8);
            val = truncated;
        }
        int startPos = offset + 8 - val.length;
        System.arraycopy(val, 0, as400Value, startPos, val.length);
        return 8;
    }

    public int toBytes(long longValue, byte[] as400Value, int offset) {
        if (longValue < 0L) {
            throw new ExtendedIllegalArgumentException("longValue (" + longValue + ")", 4);
        }
        BinaryConverter.longToByteArray(longValue, as400Value, offset);
        return 8;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toBigInteger(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return this.toBigInteger(as400Value, offset);
    }

    public BigInteger toBigInteger(byte[] as400Value) {
        return this.toBigInteger(as400Value, 0);
    }

    public BigInteger toBigInteger(byte[] as400Value, int offset) {
        byte[] nineBytes = new byte[9];
        nineBytes[0] = 0;
        System.arraycopy(as400Value, offset, nineBytes, 1, 8);
        return new BigInteger(nineBytes);
    }
}

