/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;

class DBOriginalData
implements DBData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int actualLength_ = -1;
    private boolean dataCompressed_ = false;
    private int rowCount_ = -1;
    private int columnCount_ = -1;
    private int indicatorSize_ = -1;
    private int rowSize_ = -1;
    private int indicatorOffset_ = -1;
    private int dataOffset_ = -1;
    private int length_ = -1;
    private int aliasCount_ = 0;

    public DBOriginalData(int actualLength, boolean dataCompressed) {
        this.actualLength_ = actualLength;
        this.dataCompressed_ = dataCompressed;
    }

    public DBOriginalData(int rowCount, int columnCount, int indicatorSize, int rowSize) throws DBDataStreamException {
        this.rowCount_ = rowCount;
        this.columnCount_ = columnCount;
        this.indicatorSize_ = indicatorSize;
        this.rowSize_ = rowSize;
        this.length_ = 14 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
    }

    @Override
    public void overlay(byte[] rawBytes, int offset) {
        this.offset_ = offset;
        if (this.rowCount_ == -1) {
            this.rowCount_ = BinaryConverter.byteArrayToInt(rawBytes, this.offset_ + 4);
            this.columnCount_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 8);
            this.indicatorSize_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 10);
            this.rowSize_ = BinaryConverter.byteArrayToShort(rawBytes, this.offset_ + 12);
            this.length_ = 14 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
            if (this.dataCompressed_) {
                byte[] decompressedBytes = new byte[this.length_];
                System.arraycopy(rawBytes, this.offset_, decompressedBytes, 0, 14);
                JDUtilities.decompress(rawBytes, this.offset_ + 14, this.actualLength_ - 20, decompressedBytes, 14);
                this.rawBytes_ = decompressedBytes;
                this.indicatorOffset_ = 14;
            } else {
                this.rawBytes_ = rawBytes;
                this.indicatorOffset_ = this.offset_ + 14;
            }
        } else {
            this.rawBytes_ = rawBytes;
            this.indicatorOffset_ = this.offset_ + 14;
            this.setRowCount(this.rowCount_);
            this.setColumnCount(this.columnCount_);
            this.setIndicatorSize(this.indicatorSize_);
            this.setRowSize(this.rowSize_);
        }
        this.dataOffset_ = this.indicatorOffset_ + this.rowCount_ * this.columnCount_ * this.indicatorSize_;
    }

    @Override
    public int getLength() {
        return this.length_;
    }

    @Override
    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    @Override
    public int getRowCount() {
        return this.rowCount_;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount_;
    }

    @Override
    public int getIndicatorSize() {
        return this.indicatorSize_;
    }

    @Override
    public int getRowSize() {
        return this.rowSize_;
    }

    @Override
    public int getIndicator(int rowIndex, int columnIndex) {
        if (this.indicatorSize_ == 0) {
            return 0;
        }
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * ((rowIndex + this.aliasCount_) * this.columnCount_ + columnIndex));
    }

    @Override
    public int getRowDataOffset(int rowIndex) {
        return this.dataOffset_ + (rowIndex + this.aliasCount_) * this.rowSize_;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    @Override
    public void setConsistencyToken(int consistencyToken) {
        BinaryConverter.intToByteArray(consistencyToken, this.rawBytes_, this.offset_);
    }

    @Override
    public void setRowCount(int rowCount) {
        BinaryConverter.intToByteArray(rowCount, this.rawBytes_, this.offset_ + 4);
    }

    @Override
    public void setColumnCount(int columnCount) {
        BinaryConverter.shortToByteArray((short)columnCount, this.rawBytes_, this.offset_ + 8);
    }

    @Override
    public void setIndicatorSize(int indicatorSize) {
        BinaryConverter.shortToByteArray((short)indicatorSize, this.rawBytes_, this.offset_ + 10);
    }

    @Override
    public void setRowSize(int rowSize) {
        BinaryConverter.shortToByteArray((short)rowSize, this.rawBytes_, this.offset_ + 12);
    }

    @Override
    public void setIndicator(int rowIndex, int columnIndex, int indicator) {
        if (this.indicatorSize_ != 0) {
            BinaryConverter.shortToByteArray((short)indicator, this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * (rowIndex * this.columnCount_ + columnIndex));
        }
    }

    @Override
    public boolean isVariableFieldsCompressed() {
        return false;
    }

    @Override
    public void resetRowCount(int rowCount) {
        this.rowCount_ = rowCount;
    }

    @Override
    public void setAliasCount(int aliasCount) {
        this.aliasCount_ = aliasCount;
    }

    @Override
    public int getIndicator(int rowIndex, int columnIndex, int arrayIndex) {
        return -9999;
    }

    @Override
    public int getDataTotalSize(int colIndex) {
        return -9999;
    }

    @Override
    public void logInformation(String prefix) {
        JDTrace.logInformation(this, prefix + "offset_=" + this.offset_);
        JDTrace.logInformation(this, prefix + "actualLength_=" + this.actualLength_);
        JDTrace.logInformation(this, prefix + "dataCompressed_=" + this.dataCompressed_);
        JDTrace.logInformation(this, prefix + "rowCount_=" + this.rowCount_);
        JDTrace.logInformation(this, prefix + "columnCount_=" + this.columnCount_);
        JDTrace.logInformation(this, prefix + "indicatorSize_=" + this.indicatorSize_);
        JDTrace.logInformation(this, prefix + "rowSize_=" + this.rowSize_);
        JDTrace.logInformation(this, prefix + "indicatorOffset_=" + this.indicatorOffset_);
        JDTrace.logInformation(this, prefix + "dataOffset_=" + this.dataOffset_);
        JDTrace.logInformation(this, prefix + "length_=" + this.length_);
        JDTrace.logInformation(this, prefix + "aliasCount_=" + this.aliasCount_);
    }
}

