/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFCoverLetter;
import com.ibm.as400.access.PTFExitProgram;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PTF {
    private AS400 system_;
    private String productID_;
    private String returnedProductID_;
    private boolean actionPending_;
    private String actionRequired_;
    private boolean hasCoverLetter_;
    private int iplAction_;
    private String iplRequired_;
    private String loadedStatus_;
    private String maximumLevel_;
    private String minimumLevel_;
    private boolean ptfOnOrder_;
    private String ptfProductLoad_;
    private String ptfProductOption_;
    private String ptfID_;
    private boolean isPTFReleased_;
    private String ptfReleaseLevel_;
    private String returnedReleaseLevel_;
    private boolean saveFileExists_;
    private Date statusDate_;
    private String currentIPLSource_;
    private String licGroup_;
    private String saveFile_;
    private String supersedingPTF_;
    private String supersededByPTF_;
    private String targetRelease_;
    private int serverIPLRequired_ = -1;
    private String creationDateAndTime_;
    private String productStatus_;
    private String omitStatus_;
    private boolean loaded_ = false;
    private boolean partiallyLoaded_ = false;
    private boolean partiallyLoadedGroup_ = false;
    private boolean loaded200_ = false;
    private boolean loaded300_ = false;
    private boolean loaded500_ = false;
    private boolean loaded600_ = false;
    private boolean loaded700_ = false;
    private boolean loaded800_ = false;
    private boolean loaded1000_ = false;
    private int chunkSize_ = 8192;
    private PTFCoverLetter[] coverLetters_;
    private PTF[] requisites_;
    private boolean isPreRequisite_;
    private boolean isCoRequisite_;
    private boolean isConditional_;
    private boolean isRequired_;
    private boolean isTechRefreshRequisite_;
    private boolean isDistRequisite_;
    private PTF[] dependents_;
    private boolean isDependent_;
    private boolean loadedRequisites_ = false;
    private boolean loadedDependents_ = false;
    private String[] apars_;
    private String[] symptoms_;
    private PTFExitProgram[] exitPrograms_;
    private PTF[] superseded_;
    private String messageData_;
    private int techRefreshPTF_;
    public static final String ACTION_NOT_REQUIRED = "0";
    public static final String ACTION_REQUIRED_EXIT_PROGRAM = "1";
    public static final String ACTION_REQUIRED_CANNOT_VERIFY = "2";
    public static final int IPL_ACTION_NONE = 0;
    public static final int IPL_ACTION_APPLY_TEMPORARY = 1;
    public static final int IPL_ACTION_REMOVE_TEMPORARY = 2;
    public static final int IPL_ACTION_APPLY_PERMANENT = 3;
    public static final int IPL_ACTION_REMOVE_PERMANENT = 4;
    public static final String IPL_SOURCE_A = "A";
    public static final String IPL_SOURCE_B = "B";
    public static final String IPL_SOURCE_UNKNOWN = " ";
    public static final String PRODUCT_ID_ONLY = "*ONLY";
    public static final String PRODUCT_RELEASE_ONLY = "*ONLY";
    public static final String PTF_TYPE_DELAYED = "0";
    public static final String PTF_TYPE_IMMEDIATE = "1";
    public static final String PTF_TYPE_UNKNOWN = " ";
    public static final String RELATIONSHIP_COREQ = "*COREQ";
    public static final String RELATIONSHIP_DEPEND = "*DEPEND";
    public static final String RELATIONSHIP_NONE = "*NONE";
    public static final String RELATIONSHIP_PREREQ = "*PREREQ";
    public static final String RELATIONSHIP_SAME = "*SAME";
    public static final String STATUS_NOT_LOADED = "0";
    public static final String STATUS_LOADED = "1";
    public static final String STATUS_APPLIED = "2";
    public static final String STATUS_APPLIED_PERMANENT = "3";
    public static final String STATUS_REMOVED_PERMANENT = "4";
    public static final String STATUS_DAMAGED = "5";
    public static final String STATUS_SUPERSEDED = "6";
    public static final String RELATIONSHIP_TRREQ = "*TRREQ";
    public static final String RELATIONSHIP_DSTREQ = "*DSTREQ";
    private static int baseSize_ = 115;

    public PTF(AS400 system, String ptfID) {
        this(system, ptfID, "*ONLY", "*ONLY");
    }

    public PTF(AS400 system, String ptfID, String productID, String releaseLevel) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (ptfID == null) {
            throw new NullPointerException("ptfID");
        }
        if (productID == null) {
            throw new NullPointerException("productID");
        }
        if (releaseLevel == null) {
            throw new NullPointerException("releaseLevel");
        }
        this.system_ = system;
        String id = ptfID.toUpperCase().trim();
        if (id.length() != 7) {
            throw new ExtendedIllegalArgumentException("ptfID (" + ptfID + ")", 1);
        }
        String prod = productID.toUpperCase().trim();
        if (prod.length() != 7 && !prod.equals("*ONLY")) {
            throw new ExtendedIllegalArgumentException("productID (" + productID + ")", 1);
        }
        String release = releaseLevel.toUpperCase().trim();
        if (!prod.equals("*ONLY") && release.length() != 6) {
            throw new ExtendedIllegalArgumentException("releaseLevel (" + releaseLevel + ")", 1);
        }
        this.ptfID_ = id;
        this.productID_ = prod;
        this.ptfReleaseLevel_ = release;
    }

    PTF(AS400 system, String productID, String ptfID, String ptfReleaseLevel, String ptfOption, String ptfFeature) {
        this.system_ = system;
        this.productID_ = productID;
        this.ptfID_ = ptfID;
        this.ptfReleaseLevel_ = ptfReleaseLevel;
        this.ptfProductOption_ = ptfOption;
        this.ptfProductLoad_ = ptfFeature;
    }

    PTF(AS400 system, String productID, String ptfID, String ptfReleaseLevel, String ptfProductOption, String ptfProductLoad, String minLevel, String maxLevel, boolean type) {
        this(system, productID, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad);
        this.minimumLevel_ = minLevel;
        this.maximumLevel_ = maxLevel;
        this.isDependent_ = type;
        this.isCoRequisite_ = !type;
        this.loadedDependents_ = true;
    }

    PTF(AS400 system, String productID, String ptfID, String ptfReleaseLevel, String ptfProductOption, String ptfProductLoad, String minLevel, String maxLevel, boolean type, boolean cond, boolean reqRequired) {
        this(system, productID, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad);
        this.minimumLevel_ = minLevel;
        this.maximumLevel_ = maxLevel;
        this.isPreRequisite_ = type;
        this.isCoRequisite_ = !type;
        this.isConditional_ = cond;
        this.isRequired_ = reqRequired;
        this.loadedRequisites_ = true;
    }

    PTF(AS400 system, String productID, String ptfID, String ptfReleaseLevel, String ptfProductOption, String ptfProductLoad, String minLevel, String maxLevel, int type, boolean cond, boolean reqRequired) {
        this(system, productID, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad);
        this.minimumLevel_ = minLevel;
        this.maximumLevel_ = maxLevel;
        this.isPreRequisite_ = type == 1;
        this.isCoRequisite_ = type == 2;
        this.isTechRefreshRequisite_ = type == 3;
        this.isDistRequisite_ = type == 9;
        this.isConditional_ = cond;
        this.isRequired_ = reqRequired;
        this.loadedRequisites_ = true;
    }

    PTF(AS400 system, String productID, String ptfID, String ptfReleaseLevel, String ptfProductOption, String ptfProductLoad, String loadedStatus, boolean saveFileExists, boolean hasCoverLetter, boolean ptfOnOrder, int iplAction, boolean actionPending, String actionRequired, String iplRequired, boolean isPTFReleased, String minimumLevel, String maximumLevel, Date statusDate) {
        this(system, productID, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad);
        this.loadedStatus_ = loadedStatus;
        this.saveFileExists_ = saveFileExists;
        this.hasCoverLetter_ = hasCoverLetter;
        this.ptfOnOrder_ = ptfOnOrder;
        this.iplAction_ = iplAction;
        this.actionPending_ = actionPending;
        this.actionRequired_ = actionRequired;
        this.iplRequired_ = iplRequired;
        this.isPTFReleased_ = isPTFReleased;
        this.minimumLevel_ = minimumLevel;
        this.maximumLevel_ = maximumLevel;
        this.statusDate_ = statusDate;
        this.partiallyLoaded_ = true;
    }

    PTF(AS400 system, String ptfID, String productID, String ptfReleaseLevel, String ptfProductOption, String ptfProductLoad, String minimumLevel, String maximumLevel, String loadedStatus, int iplAction, String actionPending, String actionRequired, String coverLetterStatus, String onOrderStatus, String saveFileStatus, String saveFileName, String saveFileLibraryName, String supersededByPTFId, String latestSupersedingPTFId, String productStatus, String omitStatus) {
        this(system, productID, ptfID, ptfReleaseLevel, ptfProductOption, ptfProductLoad);
        this.returnedProductID_ = productID;
        this.returnedReleaseLevel_ = ptfReleaseLevel;
        this.loadedStatus_ = loadedStatus;
        this.saveFileExists_ = !saveFileStatus.equals("0");
        this.hasCoverLetter_ = !coverLetterStatus.equals("0");
        this.ptfOnOrder_ = !onOrderStatus.equals("0");
        this.iplAction_ = iplAction;
        this.actionPending_ = !actionPending.equals("0");
        this.actionRequired_ = actionRequired;
        this.minimumLevel_ = minimumLevel;
        this.maximumLevel_ = maximumLevel;
        this.saveFile_ = saveFileName;
        this.supersedingPTF_ = supersededByPTFId;
        this.productStatus_ = productStatus;
        this.omitStatus_ = omitStatus;
        this.partiallyLoadedGroup_ = true;
    }

    public String getProductStatus() {
        if (!this.partiallyLoadedGroup_) {
            return "";
        }
        return this.productStatus_;
    }

    public String getOmitStatus() {
        if (!this.partiallyLoadedGroup_) {
            return "";
        }
        return this.omitStatus_;
    }

    public String getActionRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.actionRequired_;
    }

    public String[] getAPARNumbers() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded600_) {
            this.refresh(600);
        }
        return this.apars_;
    }

    public PTFCoverLetter getCoverLetter() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getCoverLetter(this.system_.getLocale());
    }

    public PTFCoverLetter getCoverLetter(Locale locale) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        PTFCoverLetter[] letters = this.getCoverLetters();
        if (letters.length > 0) {
            String nlv = ExecutionEnvironment.getNlv(locale);
            for (int i = 0; i < letters.length; ++i) {
                if (!letters[i].getNLV().equals(nlv)) continue;
                return letters[i];
            }
            return letters[0];
        }
        return null;
    }

    public PTFCoverLetter[] getCoverLetters() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.hasCoverLetter()) {
            if (!this.loaded200_) {
                this.refresh(200);
            }
            return this.coverLetters_;
        }
        return new PTFCoverLetter[0];
    }

    public String getCurrentIPLSource() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.currentIPLSource_;
    }

    public PTF[] getDependentPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.dependents_;
    }

    public PTFExitProgram[] getExitPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded800_) {
            this.refresh(800);
        }
        return this.exitPrograms_;
    }

    public String getID() {
        return this.ptfID_;
    }

    public int getIPLAction() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.iplAction_;
    }

    public String getIPLRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.iplRequired_;
    }

    public String getLICGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.licGroup_;
    }

    public String getLoadedStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.loadedStatus_;
    }

    public String getLoadedStatusMessage(String loadedStatus) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.messageData_ == null) {
            try {
                MessageFile mf = new MessageFile(this.system_, "/QSYS.LIB/QCPFMSG.MSGF");
                AS400Message msg = mf.getMessage("CPX3501");
                if (msg != null) {
                    this.messageData_ = msg.getHelp();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (loadedStatus.equals("0")) {
            return this.messageData_.substring(0, 11).trim();
        }
        if (loadedStatus.equals(STATUS_DAMAGED)) {
            return this.messageData_.substring(11, 27).trim();
        }
        if (loadedStatus.equals(STATUS_SUPERSEDED)) {
            return this.messageData_.substring(27, 47).trim();
        }
        if (loadedStatus.equals("2")) {
            return this.messageData_.substring(47, 82).trim();
        }
        if (loadedStatus.equals(STATUS_APPLIED_PERMANENT)) {
            return this.messageData_.substring(104, 139).trim();
        }
        if (loadedStatus.equals("1")) {
            return this.messageData_.substring(82, 104).trim();
        }
        if (loadedStatus.equals(STATUS_REMOVED_PERMANENT)) {
            return this.messageData_.substring(567, 602).trim();
        }
        return "";
    }

    public String getMaximumLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.maximumLevel_;
    }

    public String getMinimumLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.minimumLevel_;
    }

    public String getProductFeature() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfProductLoad_;
    }

    public String getProductID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.returnedProductID_ == null) {
            this.refresh(100);
        }
        return this.returnedProductID_;
    }

    public String getProductOption() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfProductOption_;
    }

    public String getRelationship(PTF ptf) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        String id2;
        String id = this.getID();
        if (id.equals(id2 = ptf.getID())) {
            return RELATIONSHIP_SAME;
        }
        this.refresh(300);
        this.refresh(500);
        ptf.refresh(300);
        ptf.refresh(500);
        PTF[] requisites = this.getRequisitePTFs();
        PTF[] dependents = this.getDependentPTFs();
        PTF[] req2 = ptf.getRequisitePTFs();
        PTF[] dep2 = ptf.getDependentPTFs();
        for (i = 0; i < requisites.length; ++i) {
            if (!requisites[i].getID().equals(id2)) continue;
            if (requisites[i].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            if (requisites[i].isDistRequisite()) {
                return RELATIONSHIP_DSTREQ;
            }
            if (requisites[i].isTechRefreshRequisite()) {
                return RELATIONSHIP_TRREQ;
            }
            return RELATIONSHIP_DEPEND;
        }
        for (i = 0; i < dependents.length; ++i) {
            if (!dependents[i].getID().equals(id2)) continue;
            if (dependents[i].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_PREREQ;
        }
        for (i = 0; i < req2.length; ++i) {
            if (!req2[i].getID().equals(id)) continue;
            if (req2[i].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_PREREQ;
        }
        for (i = 0; i < dep2.length; ++i) {
            if (!dep2[i].getID().equals(id)) continue;
            if (dep2[i].isCoRequisite()) {
                return RELATIONSHIP_COREQ;
            }
            return RELATIONSHIP_DEPEND;
        }
        return RELATIONSHIP_NONE;
    }

    public String getReleaseLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.returnedReleaseLevel_ == null) {
            this.refresh(100);
        }
        return this.returnedReleaseLevel_;
    }

    public PTF[] getRequisitePTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded300_) {
            this.refresh(300);
        }
        return this.requisites_;
    }

    public String getSaveFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.hasSaveFile()) {
            if (!this.loaded_ && !this.partiallyLoadedGroup_) {
                this.refresh(100);
            }
            return this.saveFile_;
        }
        return null;
    }

    public Date getStatusDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.statusDate_;
    }

    public String getSupersedingPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoadedGroup_) {
            this.refresh(100);
        }
        return this.supersedingPTF_;
    }

    public String getSupersededByPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoadedGroup_) {
            this.refresh(100);
        }
        return this.supersededByPTF_;
    }

    public PTF[] getSupersededPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded1000_) {
            this.refresh(1000);
        }
        return this.superseded_;
    }

    public String[] getSymptomStrings() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded700_) {
            this.refresh(700);
        }
        return this.symptoms_;
    }

    public String getTargetRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.targetRelease_;
    }

    public Date getCreationDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        TimeZone tz = DateTimeConverter.timeZoneForSystem(this.system_);
        Calendar dateTime = AS400Calendar.getGregorianInstance(tz);
        dateTime.clear();
        String dattim = this.creationDateAndTime_;
        if (dattim == null || dattim.length() == 0) {
            return null;
        }
        dateTime.set(Integer.parseInt(dattim.substring(0, 3)) + 1900, Integer.parseInt(dattim.substring(3, 5)) - 1, Integer.parseInt(dattim.substring(5, 7)), Integer.parseInt(dattim.substring(7, 9)), Integer.parseInt(dattim.substring(9, 11)), Integer.parseInt(dattim.substring(11, 13)));
        return dateTime.getTime();
    }

    public int getServerIPLRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.serverIPLRequired_;
    }

    boolean hasCoverLetter() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.hasCoverLetter_;
    }

    boolean hasSaveFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.saveFileExists_;
    }

    public boolean isActionPending() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.actionPending_;
    }

    public boolean isConditional() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isConditional_;
    }

    public boolean isCoRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loadedRequisites_ || this.loadedDependents_ || this.loaded300_)) {
            this.refresh(300);
            this.refresh(500);
        }
        return this.isCoRequisite_;
    }

    public boolean isDependent() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedDependents_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isDependent_;
    }

    public boolean isOnOrder() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!(this.loaded_ || this.partiallyLoaded_ || this.partiallyLoadedGroup_)) {
            this.refresh(100);
        }
        return this.ptfOnOrder_;
    }

    public boolean isPreRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded500_) {
            this.refresh(500);
        }
        return this.isPreRequisite_;
    }

    public boolean isReleased() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.isPTFReleased_;
    }

    public boolean isRequired() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isRequired_;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.refresh(200);
        this.refresh(300);
        this.refresh(500);
        this.refresh(600);
        this.refresh(700);
        this.refresh(800);
        this.refresh(1000);
    }

    private void refresh(int whichFormat) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int bytesAvailable;
        String format = null;
        int len = 0;
        switch (whichFormat) {
            case 100: {
                format = "PTFR0100";
                len = 200;
                break;
            }
            case 200: {
                format = "PTFR0200";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 300: {
                format = "PTFR0300";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 500: {
                format = "PTFR0500";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 600: {
                format = "PTFR0600";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 700: {
                format = "PTFR0700";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 800: {
                format = "PTFR0800";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            case 1000: {
                format = "PTFR1000";
                len = baseSize_ + 12 + this.chunkSize_;
                break;
            }
            default: {
                format = "PTFR0100";
                len = baseSize_ + this.chunkSize_;
            }
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        ProgramParameter[] parms = new ProgramParameter[5];
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        byte[] ptfInfo = new byte[50];
        AS400Text text7 = new AS400Text(7, ccsid, this.system_);
        AS400Text text6 = new AS400Text(6, ccsid, this.system_);
        AS400Text text25 = new AS400Text(25, ccsid, this.system_);
        text7.toBytes(this.ptfID_, ptfInfo, 0);
        text7.toBytes(this.productID_, ptfInfo, 7);
        text6.toBytes(this.ptfReleaseLevel_, ptfInfo, 14);
        ptfInfo[24] = -16;
        text25.toBytes(" ", ptfInfo, 25);
        parms[2] = new ProgramParameter(ptfInfo);
        parms[3] = new ProgramParameter(conv.stringToByteArray(format));
        parms[4] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QPZRTVFX.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] output = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(output, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(output, 4))) {
            this.chunkSize_ = bytesAvailable;
            this.refresh(whichFormat);
            return;
        }
        this.returnedProductID_ = conv.byteArrayToString(output, 12, 7);
        this.returnedReleaseLevel_ = conv.byteArrayToString(output, 26, 6);
        this.ptfProductOption_ = conv.byteArrayToString(output, 32, 4);
        this.ptfProductLoad_ = conv.byteArrayToString(output, 36, 4);
        this.loadedStatus_ = conv.byteArrayToString(output, 40, 1);
        this.hasCoverLetter_ = output[41] == -15;
        this.ptfOnOrder_ = output[42] == -15;
        boolean bl = this.saveFileExists_ = output[43] == -15;
        if (this.saveFileExists_) {
            String fileName = conv.byteArrayToString(output, 44, 10).trim();
            String fileLibrary = conv.byteArrayToString(output, 54, 10).trim();
            this.saveFile_ = QSYSObjectPathName.toPath(fileLibrary, fileName, "SAVF");
        } else {
            this.saveFile_ = "";
        }
        this.iplRequired_ = conv.byteArrayToString(output, 64, 1);
        this.iplAction_ = output[65] & 0xF;
        this.actionPending_ = output[66] == -15;
        this.actionRequired_ = conv.byteArrayToString(output, 67, 1);
        this.isPTFReleased_ = output[68] == -15;
        this.targetRelease_ = conv.byteArrayToString(output, 69, 6);
        this.supersedingPTF_ = conv.byteArrayToString(output, 75, 7).trim();
        this.currentIPLSource_ = conv.byteArrayToString(output, 82, 1);
        this.minimumLevel_ = conv.byteArrayToString(output, 83, 2);
        this.maximumLevel_ = conv.byteArrayToString(output, 85, 2);
        String d = conv.byteArrayToString(output, 88, 13);
        if (d.trim().length() == 13) {
            Calendar cal = AS400Calendar.getGregorianInstance();
            cal.clear();
            cal.set(Integer.parseInt(d.substring(0, 3)) + 1900, Integer.parseInt(d.substring(3, 5)) - 1, Integer.parseInt(d.substring(5, 7)), Integer.parseInt(d.substring(7, 9)), Integer.parseInt(d.substring(9, 11)), Integer.parseInt(d.substring(11, 13)));
            this.statusDate_ = cal.getTime();
        } else {
            this.statusDate_ = null;
        }
        this.licGroup_ = conv.byteArrayToString(output, 101, 7).trim();
        this.supersededByPTF_ = conv.byteArrayToString(output, 108, 7).trim();
        if (output.length >= 115 && output.length >= 130) {
            this.serverIPLRequired_ = output[116] & 0xF;
            this.creationDateAndTime_ = conv.byteArrayToString(output, 117, 13).trim();
            this.techRefreshPTF_ = output[130] & 0xF;
        }
        this.loaded_ = true;
        if (whichFormat == 200) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numberOfNLVs = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.coverLetters_ = new PTFCoverLetter[numberOfNLVs];
            for (int i = 0; i < numberOfNLVs; ++i) {
                offset = entryOffset + i * entryLength;
                String nlv = conv.byteArrayToString(output, offset, 4);
                String fileName = conv.byteArrayToString(output, offset += 4, 10).trim();
                String fileLibrary = conv.byteArrayToString(output, offset += 10, 10).trim();
                String fileMember = conv.byteArrayToString(output, offset += 10, 10).trim();
                offset += 10;
                int preInstructions = output[offset++] & 0xF;
                int postInstructions = output[offset] & 0xF;
                String path = QSYSObjectPathName.toPath(fileLibrary, fileName, fileMember, "MBR");
                this.coverLetters_[i] = new PTFCoverLetter(this.system_, nlv, path, preInstructions, postInstructions);
            }
            this.loaded200_ = true;
        } else if (whichFormat == 300) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numReqs = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.requisites_ = new PTF[numReqs];
            for (int i = 0; i < numReqs; ++i) {
                byte prereqType;
                offset = entryOffset + i * entryLength;
                String reqProdID = conv.byteArrayToString(output, offset, 7);
                String reqPTFID = conv.byteArrayToString(output, offset += 7, 7);
                String release = conv.byteArrayToString(output, offset += 7, 6);
                String reqMinLvl = conv.byteArrayToString(output, offset += 6, 2);
                String reqMaxLvl = conv.byteArrayToString(output, offset += 2, 2);
                offset += 2;
                int reqType = output[offset++] & 0xF;
                boolean type = (prereqType = output[offset++]) == -15;
                boolean cond = output[offset++] == -15;
                boolean required = output[offset++] == -15;
                String option = conv.byteArrayToString(output, offset, 4);
                String reqLoadID = conv.byteArrayToString(output, offset += 4, 4);
                this.requisites_[i] = new PTF(this.system_, reqProdID, reqPTFID, release, option, reqLoadID, reqMinLvl, reqMaxLvl, reqType, cond, required);
                if (type) {
                    this.isDependent_ = true;
                } else {
                    this.isCoRequisite_ = true;
                }
                if (!cond) continue;
                this.isConditional_ = true;
            }
            this.loaded300_ = true;
        } else if (whichFormat == 500) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numDeps = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.dependents_ = new PTF[numDeps];
            for (int i = 0; i < numDeps; ++i) {
                byte depType;
                offset = entryOffset + i * entryLength;
                String depProdID = conv.byteArrayToString(output, offset, 7);
                String depPTFID = conv.byteArrayToString(output, offset += 7, 7);
                String release = conv.byteArrayToString(output, offset += 7, 6);
                String depMinLvl = conv.byteArrayToString(output, offset += 6, 2);
                String depMaxLvl = conv.byteArrayToString(output, offset += 2, 2);
                offset += 2;
                boolean type = (depType = output[offset++]) == -15;
                String option = conv.byteArrayToString(output, offset, 4);
                String depLoadID = conv.byteArrayToString(output, offset += 4, 4);
                this.dependents_[i] = new PTF(this.system_, depProdID, depPTFID, release, option, depLoadID, depMinLvl, depMaxLvl, type);
                if (type) {
                    this.isPreRequisite_ = true;
                    continue;
                }
                this.isCoRequisite_ = true;
            }
            this.loaded500_ = true;
        } else if (whichFormat == 600) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numAPARs = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.apars_ = new String[numAPARs];
            for (int i = 0; i < numAPARs; ++i) {
                offset = entryOffset + i * entryLength;
                this.apars_[i] = conv.byteArrayToString(output, offset, 7);
            }
            this.loaded600_ = true;
        } else if (whichFormat == 700) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numStrings = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.symptoms_ = new String[numStrings];
            for (int i = 0; i < numStrings; ++i) {
                offset = entryOffset + i * entryLength;
                int symptomOffset = BinaryConverter.byteArrayToInt(output, offset);
                int symptomLength = BinaryConverter.byteArrayToInt(output, offset += 4);
                this.symptoms_[i] = conv.byteArrayToString(output, symptomOffset, symptomLength);
            }
            this.loaded700_ = true;
        } else if (whichFormat == 800) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numProgs = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.exitPrograms_ = new PTFExitProgram[numProgs];
            for (int i = 0; i < numProgs; ++i) {
                offset = entryOffset + i * entryLength;
                int userDataOffset = BinaryConverter.byteArrayToInt(output, offset);
                int userDataLength = BinaryConverter.byteArrayToInt(output, offset += 4);
                String name = conv.byteArrayToString(output, offset += 4, 10).trim();
                String lib = conv.byteArrayToString(output, offset += 10, 10).trim();
                String path = QSYSObjectPathName.toPath(lib, name, "PGM");
                String runOption = conv.byteArrayToString(output, offset += 10, 1);
                String userData = conv.byteArrayToString(output, userDataOffset, userDataLength);
                this.exitPrograms_[i] = new PTFExitProgram(path, runOption, userData);
            }
            this.loaded800_ = true;
        } else if (whichFormat == 1000) {
            int offset = BinaryConverter.byteArrayToInt(output, 8);
            int entryOffset = BinaryConverter.byteArrayToInt(output, offset);
            int numSupers = BinaryConverter.byteArrayToInt(output, offset += 4);
            int entryLength = BinaryConverter.byteArrayToInt(output, offset += 4);
            this.superseded_ = new PTF[numSupers];
            for (int i = 0; i < numSupers; ++i) {
                offset = entryOffset + i * entryLength;
                String supPTFID = conv.byteArrayToString(output, offset, 7);
                this.superseded_[i] = new PTF(this.system_, this.productID_, supPTFID, this.ptfReleaseLevel_, this.ptfProductOption_, this.ptfProductLoad_);
            }
            this.loaded1000_ = true;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.ptfID_);
        buf.append('/');
        buf.append(this.ptfReleaseLevel_);
        buf.append('/');
        buf.append(this.productID_);
        return buf.toString();
    }

    public boolean getTechRefreshPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded200_) {
            this.refresh(200);
        }
        return this.techRefreshPTF_ != 0;
    }

    public boolean isTechRefreshPTF() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded200_) {
            this.refresh(200);
        }
        return this.techRefreshPTF_ != 0;
    }

    public boolean isDistRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isDistRequisite_;
    }

    public boolean isTechRefreshRequisite() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedRequisites_ && !this.loaded300_) {
            this.refresh(300);
        }
        return this.isTechRefreshRequisite_;
    }
}

