/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResourceImplRemote;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPResHandle;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectInputStreamImplRemote
implements PrintObjectInputStreamImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private NPConversation conversation_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private NPCPAttribute cpCPFMsg_;
    private int markLimit_ = 0;
    private boolean markSet_ = false;
    private NPSystem npSystem_;
    private int numBytes_ = 0;
    private int objectType_;
    private int offset_ = 0;
    private int offsetFromMark_ = 0;

    PrintObjectInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createPrintObjectInputStream(SpooledFileImpl sf, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        NPDataStream openReq = new NPDataStream(this.objectType_);
        NPDataStream openRep = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)sf).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((SpooledFileImplRemote)sf).getIDCodePoint();
        this.cpObjHndl_ = new NPCPSplFHandle();
        openReq.setAction(2);
        openReq.addCodePoint(this.cpObjID_);
        NPCPSelection selectionCP = new NPCPSelection();
        if (openOptions != null) {
            selectionCP.addUpdateAttributes(openOptions.getAttrCodePoint());
        }
        selectionCP.setAttrValue(184, "*YES");
        openReq.addCodePoint(selectionCP);
        openRep.addCodePoint(this.cpObjHndl_);
        openRep.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean fOpenOK = false;
        try {
            int rc = this.conversation_.makeRequest(openReq, openRep);
            if (rc != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + rc);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            fOpenOK = true;
        }
        finally {
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createPrintObjectInputStream(SpooledFileImpl sf, PrintParameterList openOptions, String acifP) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        NPDataStream openReq = new NPDataStream(this.objectType_);
        NPDataStream openRep = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)sf).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((SpooledFileImplRemote)sf).getIDCodePoint();
        this.cpObjHndl_ = new NPCPSplFHandle();
        openReq.setAction(2);
        openReq.addCodePoint(this.cpObjID_);
        NPCPSelection selectionCP = new NPCPSelection();
        selectionCP.setAttrValue(315, acifP);
        if (openOptions != null) {
            selectionCP.addUpdateAttributes(openOptions.getAttrCodePoint());
        }
        selectionCP.setAttrValue(184, "*YES");
        openReq.addCodePoint(selectionCP);
        openRep.addCodePoint(this.cpObjHndl_);
        openRep.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean fOpenOK = false;
        try {
            int rc = this.conversation_.makeRequest(openReq, openRep);
            if (rc != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + rc);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            fOpenOK = true;
        }
        finally {
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createPrintObjectInputStream(PrintObjectImpl resource, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 7;
        NPDataStream openReq = new NPDataStream(this.objectType_);
        NPDataStream openRep = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((AFPResourceImplRemote)resource).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((AFPResourceImplRemote)resource).getIDCodePoint();
        this.cpObjHndl_ = new NPCPResHandle();
        openReq.setAction(2);
        openReq.addCodePoint(this.cpObjID_);
        if (openOptions != null) {
            openReq.addCodePoint(openOptions.getAttrCodePoint());
        }
        openRep.addCodePoint(this.cpObjHndl_);
        openRep.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean fOpenOK = false;
        try {
            int rc = this.conversation_.makeRequest(openReq, openRep);
            if (rc != 0) {
                String curLevel = this.conversation_.getAttribute(141);
                Trace.log(2, "Error opening AFP Resource; rc = " + rc);
                switch (rc) {
                    case 4: {
                        throw new RequestNotSupportedException(curLevel, 1);
                    }
                }
            } else {
                this.retrieveNumberOfBytes();
                fOpenOK = true;
            }
        }
        finally {
            if (!fOpenOK) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    @Override
    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream closeReq = new NPDataStream(this.objectType_);
        NPDataStream closeRep = new NPDataStream(this.objectType_);
        closeReq.setAction(5);
        closeReq.addCodePoint(this.cpObjHndl_);
        closeRep.addCodePoint(this.cpCPFMsg_);
        try {
            int rc = this.conversation_.makeRequest(closeReq, closeRep);
            if (rc != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + rc);
                this.npSystem_.returnConversation(this.conversation_);
                this.conversation_ = null;
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream closeReq = new NPDataStream(this.objectType_);
            closeReq.setAction(5);
            closeReq.addCodePoint(this.cpObjHndl_);
            AS400Server server = this.conversation_.getServer();
            if (server != null) {
                closeReq.setConverter(this.conversation_.getConverter());
                server.sendAndDiscardReply(closeReq);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.offsetFromMark_ = 0;
        this.markLimit_ = readLimit;
        this.markSet_ = true;
    }

    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] data, int dataOffset, int length) throws IOException {
        int bytesRead = 0;
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream readReq = new NPDataStream(this.objectType_);
        NPDataStream readRep = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttr = new NPCPAttribute();
        NPCPData cpData = new NPCPData();
        cpAttr.setAttrValue(125, length);
        readReq.setAction(3);
        readReq.addCodePoint(this.cpObjHndl_);
        readReq.addCodePoint(cpAttr);
        cpData.setDataBuffer(data, 0, dataOffset);
        readRep.addCodePoint(cpData);
        readRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(readReq, readRep);
            switch (iRC) {
                case 0: 
                case 18: {
                    bytesRead = cpData.getDataLength();
                    this.offsetFromMark_ += bytesRead;
                    this.offset_ += bytesRead;
                    break;
                }
                case 19: {
                    bytesRead = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "PrintObjectInputStream::read() - caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
        return bytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (!this.markSet_) {
            Trace.log(2, "Mark not set.");
            throw new IOException();
        }
        if (this.markLimit_ == 0 || this.offsetFromMark_ > this.markLimit_) {
            Trace.log(4, "Stream has not been marked or mark has been invalidated.");
            throw new IOException();
        }
        if (this.offsetFromMark_ != 0) {
            this.seekFromCur(-this.offsetFromMark_);
        }
    }

    private void retrieveNumberOfBytes() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Integer numBytes;
        NPDataStream sendDS = new NPDataStream(this.objectType_);
        NPDataStream replyDS = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttrs = new NPCPAttribute();
        NPCPAttributeIDList cpAttrsToRetrieve = new NPCPAttributeIDList();
        cpAttrsToRetrieve.addAttrID(125);
        sendDS.addCodePoint(this.cpObjID_);
        sendDS.addCodePoint(cpAttrsToRetrieve);
        sendDS.setAction(15);
        replyDS.addCodePoint(cpAttrs);
        int rc = this.conversation_.makeRequest(sendDS, replyDS);
        if (rc == 0) {
            numBytes = cpAttrs.getIntValue(125);
            if (numBytes == null) {
                Trace.log(2, " Network Print Server does not support retrieving splf/resource length");
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
        } else {
            Trace.log(2, " Network Print Server error retrieving splf/resource length. RC =" + rc);
            throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
        }
        this.numBytes_ = numBytes;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int maxSkip = this.numBytes_ - this.offset_;
        if (bytesToSkip > (long)maxSkip) {
            bytesToSkip = maxSkip;
        }
        this.seekFromCur((int)bytesToSkip);
        return bytesToSkip;
    }

    private void seekFromCur(int offset) throws IOException {
        NPDataStream seekReq = new NPDataStream(this.objectType_);
        NPDataStream seekRep = new NPDataStream(this.objectType_);
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttr.setAttrValue(127, 2);
        cpAttr.setAttrValue(126, offset);
        seekReq.setAction(23);
        seekReq.addCodePoint(this.cpObjHndl_);
        seekReq.addCodePoint(cpAttr);
        seekRep.addCodePoint(this.cpCPFMsg_);
        try {
            int iRC = this.conversation_.makeRequest(seekReq, seekRep);
            switch (iRC) {
                case 0: {
                    this.offsetFromMark_ += offset;
                    this.offset_ += offset;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(iRC));
                    throw new IOException(Integer.toString(iRC));
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }

    long tell() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream tellReq = new NPDataStream(this.objectType_);
        NPDataStream tellRep = new NPDataStream(this.objectType_);
        NPCPAttributeIDList cpAttrIDs = new NPCPAttributeIDList();
        NPCPAttribute cpAttr = new NPCPAttribute();
        cpAttrIDs.addAttrID(126);
        tellReq.setAction(24);
        tellReq.addCodePoint(this.cpObjHndl_);
        tellRep.addCodePoint(cpAttr);
        try {
            int iRC = this.conversation_.makeRequest(tellReq, tellRep);
            switch (iRC) {
                case 0: {
                    Integer curOffset = cpAttr.getIntValue(126);
                    if (curOffset == null) {
                        Trace.log(2, " tell() returned null!");
                        throw new InternalErrorException(4);
                    }
                    return curOffset.intValue();
                }
            }
            Trace.log(2, " NPServer.Tell() returned " + iRC);
            throw new InternalErrorException(4);
        }
        catch (Exception e) {
            Trace.log(2, "Caught an Exception." + e.toString());
            throw new IOException(e.toString());
        }
    }
}

