/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class TimeFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private String timeFormat_ = null;
    private String timeSeparator_ = null;

    public TimeFieldDescription() {
    }

    public TimeFieldDescription(AS400Text dataType, String name) {
        super(dataType, name);
    }

    public TimeFieldDescription(AS400Text dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    public TimeFieldDescription(AS400Time dataType, String name) {
        super(dataType, name);
    }

    public TimeFieldDescription(AS400Time dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    @Override
    String[] getDDSDescription() {
        Vector<String> v = new Vector<String>();
        StringBuilder desc = new StringBuilder(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        desc.append("     ");
        desc.append("T");
        desc.append("  ");
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (this.timeFormat_ != null) {
            v.addElement("TIMFMT(" + this.timeFormat_ + ") ");
        }
        if (this.timeSeparator_ != null) {
            if (!TimeFieldDescription.formatHasFixedSeparator(this.timeFormat_)) {
                v.addElement("TIMSEP('" + this.timeSeparator_ + "') ");
            } else if (Trace.traceOn_) {
                Trace.log(1, "DDS time format " + this.timeFormat_ + " has a fixed separator.");
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT('" + this.defaultValue_.toString() + "') ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    private static boolean formatHasFixedSeparator(String format) {
        return DateFieldDescription.formatHasFixedSeparator(format);
    }

    public String getTIMFMT() {
        return this.timeFormat_ == null ? "" : this.timeFormat_;
    }

    public String getTIMSEP() {
        return this.timeSeparator_ == null ? "" : this.timeSeparator_;
    }

    public void setDataType(AS400Text dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDataType(AS400Time dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDFT(String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTCurrent() {
        this.isDFTCurrent_ = true;
        this.isDFTNull_ = false;
        this.defaultValue_ = null;
        this.DFTCurrentValue_ = new SimpleDateFormat("HH.mm.ss").format(new Date());
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setTIMFMT(String timeFormat) {
        if (timeFormat == null) {
            throw new NullPointerException("timeFormat");
        }
        this.timeFormat_ = timeFormat.startsWith("*") ? timeFormat.toUpperCase() : "*" + timeFormat.toUpperCase();
        if (this.dataType_ instanceof AS400Time) {
            ((AS400Time)this.dataType_).setFormat(timeFormat);
        }
    }

    public void setTIMSEP(String separator) {
        if (this.dataType_ instanceof AS400Time) {
            if (separator != null && separator.length() > 1) {
                throw new ExtendedIllegalArgumentException("separator (" + separator + ")", 1);
            }
            Character sep = separator == null ? null : Character.valueOf(separator.charAt(0));
            ((AS400Time)this.dataType_).setSeparator(sep);
        }
        this.timeSeparator_ = separator;
    }
}

