/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDataValues;
import com.ibm.as400.data.PcmlDataVector;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.ProgramCallDocument;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

class PcmlData
extends PcmlDocNode {
    public static final int UNSUPPORTED = 0;
    public static final int CHAR = 1;
    public static final int INT = 2;
    public static final int PACKED = 3;
    public static final int ZONED = 4;
    public static final int FLOAT = 5;
    public static final int BYTE = 6;
    public static final int STRUCT = 7;
    public static final int DATE = 8;
    public static final int TIME = 9;
    public static final int TIMESTAMP = 10;
    public static final int VARCHAR = 11;
    public static final int MAX_STRING_LENGTH = 0xFFEFF0;
    static final long serialVersionUID = 8578048664805881489L;
    private static final String[] DATAATTRIBUTES = new String[]{"name", "usage", "count", "minvrm", "maxvrm", "offset", "offsetfrom", "outputsize", "type", "length", "precision", "ccsid", "init", "struct", "passby", "bidistringtype", "trim", "chartype", "dateformat", "dateseparator", "timeformat", "timeseparator"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 14;
    private static final int VERSION_2_ATTRIBUTE_COUNT = 15;
    private static final int VERSION_3_ATTRIBUTE_COUNT = 16;
    private static final int VERSION_4_ATTRIBUTE_COUNT = 18;
    private static final int VERSION_5_ATTRIBUTE_COUNT = 20;
    private static Hashtable bidiTypeMap_;
    private int m_Count;
    private String m_CountId;
    private int m_Offset;
    private String m_OffsetId;
    private boolean m_OffsetfromFixed;
    private int m_Offsetfrom;
    private String m_OffsetfromId;
    private String m_Minvrm;
    private int m_MinvrmInt;
    private String m_Maxvrm;
    private int m_MaxvrmInt;
    private int m_Outputsize;
    private String m_OutputsizeId;
    private String m_TypeStr;
    private int m_Type;
    private int m_Length;
    private String m_LengthId;
    private boolean m_LengthWasSpecified;
    private int m_Precision;
    private int m_Ccsid;
    private String m_CcsidId;
    private boolean m_CcsidWasSpecified;
    private String m_Init;
    private String m_StructId;
    private String m_PassbyStr;
    private int m_Passby;
    private String m_BidistringtypeStr;
    private int m_Bidistringtype;
    private boolean m_IsRfml;
    private String m_TrimStr;
    private String m_CharType;
    private String m_KeyFieldStr;
    private boolean m_KeyField;
    private String m_DateFormat;
    private String m_DateSeparator;
    private String m_TimeFormat;
    private String m_TimeSeparator;
    private PcmlDataValues m_scalarValue;
    private PcmlDataVector m_vectorValue;
    private static final String vrmDelimChars = "VRM";

    PcmlData() {
        this(false);
    }

    PcmlData(PcmlAttributeList attrs) {
        this(attrs, false);
    }

    PcmlData(boolean isRfml) {
        this.m_IsRfml = isRfml;
    }

    PcmlData(PcmlAttributeList attrs, boolean isRfml) {
        super(attrs);
        this.m_IsRfml = isRfml;
        this.setNodeType(4);
        this.setCount(this.getAttributeValue("count"));
        this.setOffset(this.getAttributeValue("offset"));
        this.setOffsetfrom(this.getAttributeValue("offsetfrom"));
        this.setMinvrm(this.getAttributeValue("minvrm"));
        this.setMaxvrm(this.getAttributeValue("maxvrm"));
        this.setType(this.getAttributeValue("type"));
        this.setLength(this.getAttributeValue("length"));
        this.setPrecision(this.getAttributeValue("precision"));
        this.setCcsid(this.getAttributeValue("ccsid"));
        this.setInit(this.getAttributeValue("init"));
        this.setOutputsize(this.getAttributeValue("outputsize"));
        this.setStruct(this.getAttributeValue("struct"));
        this.setPassby(this.getAttributeValue("passby"));
        this.setBidiStringType(this.getAttributeValue("bidistringtype"));
        this.setTrim(this.getAttributeValue("trim"));
        this.setCharType(this.getAttributeValue("chartype"));
        this.setKeyField(this.getAttributeValue("keyfield"));
        this.setDateFormat(this.getAttributeValue("dateformat"));
        this.setDateSeparator(this.getAttributeValue("dateseparator"));
        this.setTimeFormat(this.getAttributeValue("timeformat"));
        this.setTimeSeparator(this.getAttributeValue("timeseparator"));
        this.m_scalarValue = null;
        this.m_vectorValue = null;
    }

    @Override
    public Object clone() {
        PcmlData node = (PcmlData)super.clone();
        node.m_scalarValue = null;
        node.m_vectorValue = null;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        PcmlData pcmlData = this;
        synchronized (pcmlData) {
            PcmlDataValues scalarValue = this.m_scalarValue;
            PcmlDataVector vectorValue = this.m_vectorValue;
            if (!this.getDoc().isSerializingWithData()) {
                this.m_scalarValue = null;
                this.m_vectorValue = null;
            }
            out.defaultWriteObject();
            this.m_scalarValue = scalarValue;
            this.m_vectorValue = vectorValue;
        }
    }

    @Override
    void readObjectPostprocessing() {
        if (this.m_scalarValue != null) {
            this.m_scalarValue.readObjectPostprocessing();
        }
        if (this.m_vectorValue != null) {
            this.m_vectorValue.readObjectPostprocessing();
        }
        super.readObjectPostprocessing();
    }

    private PcmlDataValues getPcmlDataValues(PcmlDimensions indices) throws PcmlException {
        int[] myDimensions = this.getDimensions(indices).asArray();
        if (indices.size() < myDimensions.length) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), myDimensions.length, this.getNameForException()});
        }
        if (myDimensions.length == 0) {
            if (this.m_scalarValue == null) {
                this.m_scalarValue = new PcmlDataValues(this, new PcmlDimensions());
            }
            return this.m_scalarValue;
        }
        PcmlDimensions myIndices = new PcmlDimensions();
        if (this.m_vectorValue == null) {
            this.m_vectorValue = new PcmlDataVector(myDimensions[0], this, myIndices);
            for (int elem = 0; elem < myDimensions[0]; ++elem) {
                this.m_vectorValue.addElement(null);
            }
        }
        long[] myDimensionTimestamps = this.getDimensionTimestamps(indices);
        PcmlDataVector v = this.m_vectorValue;
        for (int i = 0; i < myDimensions.length; ++i) {
            PcmlDataVector nextVector;
            if (myDimensionTimestamps[i] > v.getTimestamp()) {
                v.redimension(myDimensions[i]);
            }
            int index = indices.at(i);
            myIndices.add(index);
            if (index < 0 || index >= myDimensions[i]) {
                throw new PcmlException("INDEX_OUT_OF_BOUNDS", new Object[]{myDimensions[i] - 1, i, indices, this.getNameForException()});
            }
            if (i != myDimensions.length - 1) {
                nextVector = v.vectorAt(index);
                if (nextVector == null) {
                    nextVector = new PcmlDataVector(myDimensions[i + 1], this, myIndices);
                    for (int elem = 0; elem < myDimensions[i + 1]; ++elem) {
                        nextVector.addElement(null);
                    }
                    v.setElementAt(nextVector, index);
                }
            } else {
                PcmlDataValues item = v.valuesAt(index);
                if (item == null) {
                    item = new PcmlDataValues(this, myIndices);
                    v.setElementAt(item, index);
                }
                return item;
            }
            v = nextVector;
        }
        throw new PcmlException("ERROR_ACCESSING_VALUE", new Object[]{indices, myDimensions, this.getNameForException()});
    }

    long getTimestamp(PcmlDimensions indices) throws PcmlException {
        if (indices.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues values = this.getPcmlDataValues(indices);
            return values.getTimestamp();
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
    }

    final Object getValue() throws PcmlException {
        return this.getValue(new PcmlDimensions());
    }

    final Object getValue(PcmlDimensions indices) throws PcmlException {
        if (this.m_Type == 1 || this.m_Type == 11) {
            return this.getStringValue(indices, this.m_Bidistringtype);
        }
        if (indices.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues values = this.getPcmlDataValues(indices);
            return values.getValue();
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
    }

    final String getStringValue(PcmlDimensions indices, int type) throws PcmlException {
        Object val = null;
        if (indices.size() >= this.getNbrOfDimensions()) {
            PcmlDataValues values = this.getPcmlDataValues(indices);
            if (this.m_Type == 1 || this.m_Type == 11) {
                values.setStringType(type);
            }
            if ((val = values.getValue()) == null) {
                return null;
            }
            if (val instanceof Number) {
                return ((Number)val).toString();
            }
            if (val instanceof String) {
                return (String)val;
            }
            throw new PcmlException("STRING_OR_NUMBER", new Object[]{val.getClass().getName(), this.getNameForException()});
        }
        throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
    }

    final void setValue(Object v) throws PcmlException {
        this.setValue(v, new PcmlDimensions());
    }

    final void setValue(Object v, PcmlDimensions indices) throws PcmlException {
        if (indices.size() < this.getNbrOfDimensions()) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
        }
        PcmlDataValues values = this.getPcmlDataValues(indices);
        values.setStringType(this.m_Bidistringtype);
        values.setValue(v);
    }

    final void setStringValue(String val, PcmlDimensions indices, int type) throws PcmlException {
        if (indices.size() < this.getNbrOfDimensions()) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
        }
        PcmlDataValues values = this.getPcmlDataValues(indices);
        values.flushValues();
        values.setStringType(type);
        values.setValue(val);
    }

    final void setCharArrayValue(char[] val, PcmlDimensions indices, int type) throws PcmlException {
        if (indices.size() < this.getNbrOfDimensions()) {
            throw new PcmlException("TOO_FEW_INDICES", new Object[]{indices.size(), this.getNbrOfDimensions(), this.getNameForException()});
        }
        PcmlDataValues values = this.getPcmlDataValues(indices);
        values.flushValues();
        values.setStringType(type);
        values.setValue(val);
    }

    void setBytes(byte[] ba) {
    }

    @Override
    String[] getAttributeList() {
        int returnCount = 0;
        if (this.getDoc().getVersion().compareTo("2.0") < 0) {
            returnCount = 14;
        } else if (this.getDoc().getVersion().compareTo("3.0") < 0) {
            returnCount = 15;
        } else if (this.getDoc().getVersion().compareTo("4.0") < 0) {
            returnCount = 16;
        } else if (this.getDoc().getVersion().compareTo("6.0") < 0) {
            returnCount = 18;
        } else {
            return DATAATTRIBUTES;
        }
        String[] returnArray = new String[returnCount];
        System.arraycopy(DATAATTRIBUTES, 0, returnArray, 0, returnCount);
        return returnArray;
    }

    final int getCcsid(PcmlDimensions indices) throws PcmlException {
        int tmpCcsid = this.resolveIntegerValue(this.getCcsid(), this.getCcsidId(), indices);
        if (tmpCcsid == 0) {
            PcmlNode node = this.getParent();
            while (node.getParent() != this.getDoc()) {
                node = node.getParent();
            }
            if (node instanceof PcmlProgram) {
                return ((PcmlProgram)node).getProgramCCSID();
            }
            return this.getDoc().getAs400().getCcsid();
        }
        return tmpCcsid;
    }

    final int getCount(PcmlDimensions indices) throws PcmlException {
        return this.resolveIntegerValue(this.getCount(), this.getCountId(), indices);
    }

    final int getXPCMLCount(PcmlDimensions indices) throws PcmlException {
        try {
            int rc = this.resolveIntegerValue(this.getCount(), this.getCountId(), indices);
            return rc;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public final int getCount() {
        return this.m_Count;
    }

    public final String getCountId() {
        return this.resolveRelativeName(this.m_CountId);
    }

    public final String getUnqualifiedCountId() {
        return this.m_CountId;
    }

    final int getLength(PcmlDimensions indices) throws PcmlException {
        return this.resolveIntegerValue(this.getLength(), this.getLengthId(), indices);
    }

    final int getOffset(PcmlDimensions indices) throws PcmlException {
        return this.resolveIntegerValue(this.getOffset(), this.getOffsetId(), indices);
    }

    public final int getOffset() {
        return this.m_Offset;
    }

    public final String getOffsetId() {
        return this.resolveRelativeName(this.m_OffsetId);
    }

    public final String getUnqualifiedOffsetId() {
        return this.m_OffsetId;
    }

    private final boolean isOffsetfromFixed() {
        return this.m_OffsetfromFixed;
    }

    public final int getPassby() {
        if (this.m_PassbyStr != null) {
            return this.m_Passby;
        }
        return 2;
    }

    public final String getBidistringtypeStr() {
        return this.m_BidistringtypeStr;
    }

    final int getOffsetfrom() {
        if (this.isOffsetfromFixed()) {
            return this.m_Offsetfrom;
        }
        return -1;
    }

    final String getOffsetfromId() {
        return this.resolveRelativeName(this.m_OffsetfromId);
    }

    public final String getUnqualifiedOffsetfromId() {
        return this.m_OffsetfromId;
    }

    PcmlDimensions getDimensions(PcmlDimensions indices) throws PcmlException {
        PcmlDimensions myDimensions = null;
        PcmlNode node = this.getParent();
        myDimensions = node instanceof PcmlData ? ((PcmlData)node).getDimensions(indices) : (node instanceof PcmlStruct ? ((PcmlStruct)node).getDimensions(indices) : new PcmlDimensions(this.getNbrOfDimensions()));
        if (this.isArray()) {
            int myCount = this.getCount(indices);
            myDimensions.add(myCount);
        }
        return myDimensions;
    }

    long[] getDimensionTimestamps(PcmlDimensions indices) throws PcmlException {
        long[] myTimestamps;
        Integer myIndex = null;
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            myIndex = indices.integerAt(indices.size() - 1);
            indices.remove();
        }
        long[] previousTimestamps = node instanceof PcmlData ? ((PcmlData)node).getDimensionTimestamps(indices) : (node instanceof PcmlStruct ? ((PcmlStruct)node).getDimensionTimestamps(indices) : new long[]{});
        if (myIndex != null) {
            int i;
            indices.add(myIndex);
            myTimestamps = new long[previousTimestamps.length + 1];
            for (i = 0; i < previousTimestamps.length; ++i) {
                myTimestamps[i] = previousTimestamps[i];
            }
            myTimestamps[i] = this.resolveDimensionTimestamp(indices);
            if (i > 0) {
                myTimestamps[i] = Math.max(myTimestamps[i], myTimestamps[i - 1]);
            }
        } else {
            myTimestamps = previousTimestamps;
        }
        return myTimestamps;
    }

    int getNbrOfDimensions() {
        int total = 0;
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            ++total;
        }
        if (node instanceof PcmlData) {
            total += ((PcmlData)node).getNbrOfDimensions();
        } else if (node instanceof PcmlStruct) {
            total += ((PcmlStruct)node).getNbrOfDimensions();
        }
        return total;
    }

    int getOutputsize(PcmlDimensions indices) throws PcmlException {
        boolean processArray;
        int myCount;
        int totalSize = 0;
        totalSize = this.resolveIntegerValue(this.getOutputsize(), this.getOutputsizeId(), indices);
        if (totalSize > 0) {
            return totalSize;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            if (processArray) {
                indices.add(myIndex);
            }
            switch (this.getDataType()) {
                case 7: {
                    Enumeration children = this.getChildren();
                    block8: while (children.hasMoreElements()) {
                        PcmlDocNode child = (PcmlDocNode)children.nextElement();
                        switch (child.getNodeType()) {
                            case 3: {
                                totalSize += ((PcmlStruct)child).getOutputsize(indices);
                                continue block8;
                            }
                            case 4: {
                                totalSize += ((PcmlData)child).getOutputsize(indices);
                                continue block8;
                            }
                        }
                        throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
                    }
                    break;
                }
                default: {
                    if ((totalSize += this.getPcmlDataValues(indices).byteLength()) != 0) break;
                    totalSize = 32;
                }
            }
            if (!processArray) continue;
            indices.remove();
        }
        return totalSize;
    }

    public final String getTrim() {
        return this.m_TrimStr;
    }

    public final String getCharType() {
        return this.m_CharType;
    }

    boolean isArray() {
        if (this.getCount() > 0) {
            return true;
        }
        return this.getCountId() != null;
    }

    boolean isInArray() {
        PcmlNode node = this.getParent();
        if (this.isArray()) {
            return true;
        }
        if (node instanceof PcmlData) {
            return ((PcmlData)node).isInArray();
        }
        if (node instanceof PcmlStruct) {
            return ((PcmlStruct)node).isInArray();
        }
        return false;
    }

    public final boolean isLengthSpecified() {
        return this.m_LengthWasSpecified || this.m_Length != 0 || this.m_LengthId != null;
    }

    boolean isSupportedAtHostVRM() throws PcmlException {
        if (this.m_IsRfml) {
            return true;
        }
        int hostVrm = this.getAs400VRM();
        if (this.getMinvrm() > hostVrm) {
            return false;
        }
        return this.getMaxvrm() >= hostVrm;
    }

    int toBytes(OutputStream bytes, int offset, PcmlDimensions indices) throws PcmlException {
        boolean processArray;
        int myCount;
        int totalBytes = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            if (processArray) {
                indices.add(myIndex);
            }
            switch (this.getDataType()) {
                case 7: {
                    Enumeration children = this.getChildren();
                    block8: while (children.hasMoreElements()) {
                        PcmlDocNode child = (PcmlDocNode)children.nextElement();
                        switch (child.getNodeType()) {
                            case 3: {
                                totalBytes += ((PcmlStruct)child).toBytes(bytes, offset + totalBytes, indices);
                                continue block8;
                            }
                            case 4: {
                                totalBytes += ((PcmlData)child).toBytes(bytes, offset + totalBytes, indices);
                                continue block8;
                            }
                        }
                        throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
                    }
                    break;
                }
                default: {
                    totalBytes += this.getPcmlDataValues(indices).toBytes(bytes, offset + totalBytes);
                }
            }
            if (!processArray) continue;
            indices.remove();
        }
        return totalBytes;
    }

    int parseBytes(byte[] bytes, int offset, Hashtable offsetStack, PcmlDimensions indices) throws PcmlException {
        int myOffset;
        boolean processArray;
        int myCount;
        int nbrBytes = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && indices.size() < this.getNbrOfDimensions()) {
            myCount = this.getCount(indices);
            processArray = true;
        } else {
            myCount = 1;
            processArray = false;
        }
        int skipBytes = 0;
        if (this.getDataType() == 7 && (myOffset = this.getOffset(indices)) > 0) {
            Integer myOffsetbase = null;
            String myOffsetfromId = this.getOffsetfromId();
            if (myOffsetfromId != null) {
                myOffsetbase = (Integer)offsetStack.get(myOffsetfromId);
                if (myOffsetbase == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{myOffsetfromId, this.getNameForException()});
                }
            } else {
                myOffsetbase = this.getOffsetfrom() >= 0 ? Integer.valueOf(this.getOffsetfrom()) : (Integer)offsetStack.get(((PcmlDocNode)this.getParent()).getQualifiedName());
            }
            if (myOffsetbase != null) {
                myOffset += myOffsetbase.intValue();
            }
            if (myOffset > offset) {
                skipBytes = myOffset - offset;
            }
        }
        for (int myIndex = 0; myIndex < myCount; ++myIndex) {
            if (processArray) {
                indices.add(myIndex);
            }
            if (this.getDataType() != 7) {
                nbrBytes += this.getPcmlDataValues(indices).parseBytes(bytes, offset + skipBytes + nbrBytes, offsetStack);
            } else {
                String qName = this.getQualifiedName();
                if (!qName.equals("")) {
                    offsetStack.put(qName, offset + skipBytes + nbrBytes);
                }
                Enumeration children = this.getChildren();
                block5: while (children.hasMoreElements()) {
                    PcmlDocNode child = (PcmlDocNode)children.nextElement();
                    switch (child.getNodeType()) {
                        case 3: {
                            PcmlStruct structNode = (PcmlStruct)child;
                            nbrBytes += structNode.parseBytes(bytes, offset + skipBytes + nbrBytes, offsetStack, indices);
                            continue block5;
                        }
                        case 4: {
                            PcmlData dataNode = (PcmlData)child;
                            nbrBytes += dataNode.parseBytes(bytes, offset + skipBytes + nbrBytes, offsetStack, indices);
                            continue block5;
                        }
                    }
                    throw new PcmlException("BAD_NODE_TYPE", new Object[]{child.getNodeType(), this.getNameForException()});
                }
                if (!qName.equals("")) {
                    offsetStack.remove(qName);
                }
            }
            if (!processArray) continue;
            indices.remove();
        }
        return nbrBytes + skipBytes;
    }

    private int resolveIntegerValue(int intLiteral, String name, PcmlDimensions indices) throws PcmlException {
        if (name != null) {
            PcmlNode node = this.getDoc().getElement(name);
            if (node instanceof PcmlData) {
                PcmlData dataNode = (PcmlData)node;
                Object nodeValue = dataNode.getValue(indices);
                if (nodeValue instanceof String) {
                    return Integer.parseInt((String)nodeValue);
                }
                if (nodeValue instanceof Number) {
                    return ((Number)nodeValue).intValue();
                }
                if (nodeValue == null) {
                    throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{dataNode.getNameForException()});
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{nodeValue.getClass().getName(), dataNode.getNameForException()});
            }
            if (node == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<data>"});
        }
        return intLiteral;
    }

    private long resolveDimensionTimestamp(PcmlDimensions indices) throws PcmlException {
        String name = this.getCountId();
        if (name != null) {
            PcmlNode node = this.getDoc().getElement(name);
            if (node instanceof PcmlData) {
                return ((PcmlData)node).getTimestamp(indices);
            }
            if (node == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<data>"});
        }
        return Long.MIN_VALUE;
    }

    public final int getCcsid() {
        return this.m_Ccsid;
    }

    public final String getCcsidId() {
        return this.resolveRelativeName(this.m_CcsidId);
    }

    public final String getUnqualifiedCcsidId() {
        return this.m_CcsidId;
    }

    public final int getDataType() {
        return this.m_Type;
    }

    public final String getDataTypeString() {
        return this.m_TypeStr;
    }

    public final String getInit() {
        return this.m_Init;
    }

    public final int getLength() {
        return this.m_Length;
    }

    public final String getLengthId() {
        return this.resolveRelativeName(this.m_LengthId);
    }

    public final String getUnqualifiedLengthId() {
        return this.m_LengthId;
    }

    public final int getMaxvrm() {
        return this.m_MaxvrmInt;
    }

    public final String getMaxvrmString() {
        return this.m_Maxvrm;
    }

    public final int getMinvrm() {
        return this.m_MinvrmInt;
    }

    public final String getMinvrmString() {
        return this.m_Minvrm;
    }

    public final int getOutputsize() {
        return this.m_Outputsize;
    }

    public final String getOutputsizeId() {
        return this.resolveRelativeName(this.m_OutputsizeId);
    }

    public final String getUnqualifiedOutputsizeId() {
        return this.m_OutputsizeId;
    }

    public final int getPrecision() {
        return this.m_Precision;
    }

    public final String getStruct() {
        return this.m_StructId;
    }

    public final String getDateFormat() {
        return this.m_DateFormat;
    }

    public final String getDateSeparator() {
        return this.m_DateSeparator;
    }

    public final String getTimeFormat() {
        return this.m_TimeFormat;
    }

    public final String getTimeSeparator() {
        return this.m_TimeSeparator;
    }

    public boolean isKeyField() {
        return this.m_KeyField;
    }

    private void setCount(String count) {
        if (count == null || count.equals("")) {
            this.m_Count = 0;
            this.m_CountId = null;
            return;
        }
        try {
            this.m_Count = Integer.parseInt(count);
            this.m_CountId = null;
        }
        catch (NumberFormatException e) {
            this.m_Count = 0;
            this.m_CountId = count;
        }
    }

    private void setCcsid(String ccsid) {
        if (ccsid == null || ccsid.equals("")) {
            this.m_Ccsid = 0;
            this.m_CcsidId = null;
            return;
        }
        this.m_CcsidWasSpecified = true;
        try {
            this.m_Ccsid = Integer.parseInt(ccsid);
            this.m_CcsidId = null;
        }
        catch (NumberFormatException e) {
            this.m_Ccsid = 0;
            this.m_CcsidId = ccsid;
        }
    }

    void setInit(String init) {
        this.m_Init = init;
    }

    protected void setLength(String length) {
        if (length == null || length.equals("")) {
            this.m_Length = 0;
            this.m_LengthId = null;
            return;
        }
        this.m_LengthWasSpecified = true;
        try {
            this.m_Length = Integer.parseInt(length);
            this.m_LengthId = null;
        }
        catch (NumberFormatException e) {
            this.m_Length = 0;
            this.m_LengthId = length;
        }
    }

    private void setMaxvrm(String maxvrm) {
        this.m_MaxvrmInt = Integer.MAX_VALUE;
        if (maxvrm == null || maxvrm.equals("")) {
            this.m_Maxvrm = null;
            return;
        }
        this.m_Maxvrm = maxvrm;
    }

    private void setMinvrm(String minvrm) {
        this.m_MinvrmInt = Integer.MIN_VALUE;
        if (minvrm == null || minvrm.equals("")) {
            this.m_Minvrm = null;
            return;
        }
        this.m_Minvrm = minvrm;
    }

    private void setOffset(String offset) {
        if (offset == null || offset.equals("")) {
            this.m_Offset = 0;
            this.m_OffsetId = null;
            return;
        }
        try {
            this.m_Offset = Integer.parseInt(offset);
            this.m_OffsetId = null;
        }
        catch (NumberFormatException e) {
            this.m_Offset = 0;
            this.m_OffsetId = offset;
        }
    }

    private void setOffsetfrom(String offsetfrom) {
        this.m_OffsetfromFixed = true;
        if (offsetfrom == null || offsetfrom.equals("")) {
            this.m_Offsetfrom = -1;
            this.m_OffsetfromId = null;
            return;
        }
        try {
            this.m_Offsetfrom = Integer.parseInt(offsetfrom);
            this.m_OffsetfromId = null;
        }
        catch (NumberFormatException e) {
            this.m_Offsetfrom = 0;
            this.m_OffsetfromId = offsetfrom;
        }
    }

    private void setOutputsize(String outputsize) {
        if (outputsize == null || outputsize.equals("")) {
            this.m_Outputsize = 0;
            return;
        }
        try {
            this.m_Outputsize = Integer.parseInt(outputsize);
            this.m_OutputsizeId = null;
        }
        catch (NumberFormatException e) {
            this.m_Outputsize = 0;
            this.m_OutputsizeId = outputsize;
        }
    }

    private void setPassby(String passby) {
        if (passby == null || passby.equals("")) {
            this.m_PassbyStr = null;
            this.m_Passby = 2;
            return;
        }
        this.m_PassbyStr = passby;
        this.m_Passby = this.m_PassbyStr.equals("value") ? 1 : 2;
    }

    private void setBidiStringType(String type) {
        if (type == null || type.equals("") || type.equals("DEFAULT")) {
            this.m_BidistringtypeStr = null;
            this.m_Bidistringtype = 0;
            return;
        }
        this.m_BidistringtypeStr = type;
        Integer bidistringtypeInt = (Integer)PcmlData.getBidiTypeMap().get(this.m_BidistringtypeStr);
        if (bidistringtypeInt == null) {
            this.m_Bidistringtype = 0;
            if (Trace.isTraceOn()) {
                Trace.log(7, "[Warning]: Value of 'bidistringtype' attribute is not recognized: " + this.m_BidistringtypeStr);
            }
        } else {
            this.m_Bidistringtype = bidistringtypeInt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Hashtable getBidiTypeMap() {
        if (bidiTypeMap_ != null) return bidiTypeMap_;
        Class<PcmlData> clazz = PcmlData.class;
        synchronized (PcmlData.class) {
            if (bidiTypeMap_ != null) return bidiTypeMap_;
            bidiTypeMap_ = new Hashtable(10);
            bidiTypeMap_.put("DEFAULT", 0);
            bidiTypeMap_.put("NONE", -1);
            bidiTypeMap_.put("ST4", 4);
            bidiTypeMap_.put("ST5", 5);
            bidiTypeMap_.put("ST6", 6);
            bidiTypeMap_.put("ST7", 7);
            bidiTypeMap_.put("ST8", 8);
            bidiTypeMap_.put("ST9", 9);
            bidiTypeMap_.put("ST10", 10);
            bidiTypeMap_.put("ST11", 11);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bidiTypeMap_;
        }
    }

    private void setPrecision(String precision) {
        if (precision == null || precision.equals("")) {
            this.m_Precision = 0;
            return;
        }
        try {
            this.m_Precision = Integer.parseInt(precision);
        }
        catch (NumberFormatException e) {
            this.m_Precision = -1;
        }
    }

    private void setStruct(String struct) {
        if (struct == null || struct.equals("")) {
            this.m_StructId = null;
            return;
        }
        this.m_StructId = struct;
    }

    private void setType(String type) {
        this.m_TypeStr = type;
        this.m_Type = type.equals("char") ? 1 : (type.equals("int") ? 2 : (type.equals("packed") ? 3 : (type.equals("zoned") ? 4 : (type.equals("float") ? 5 : (type.equals("byte") ? 6 : (type.equals("struct") ? 7 : (type.equals("date") ? 8 : (type.equals("time") ? 9 : (type.equals("timestamp") ? 10 : (type.equals("varchar") ? 11 : 0))))))))));
    }

    private void setTrim(String trimEnd) {
        if (trimEnd == null || trimEnd.equals("")) {
            this.m_TrimStr = null;
            return;
        }
        this.m_TrimStr = trimEnd;
    }

    private void setCharType(String charType) {
        if (charType == null || charType.equals("")) {
            this.m_CharType = null;
            return;
        }
        this.m_CharType = charType;
    }

    private void setKeyField(String keyField) {
        if (keyField == null || keyField.equals("")) {
            this.m_KeyField = false;
            return;
        }
        this.m_KeyFieldStr = keyField;
        this.m_KeyField = keyField.equalsIgnoreCase("true");
    }

    private void setDateFormat(String format) {
        if (format == null || format.equals("")) {
            this.m_DateFormat = null;
            return;
        }
        this.m_DateFormat = format;
    }

    private void setDateSeparator(String separator) {
        if (separator == null || separator.equals("")) {
            this.m_DateSeparator = null;
            return;
        }
        this.m_DateSeparator = separator;
    }

    private void setTimeFormat(String format) {
        if (format == null || format.equals("")) {
            this.m_TimeFormat = null;
            return;
        }
        this.m_TimeFormat = format;
    }

    private void setTimeSeparator(String separator) {
        if (separator == null || separator.equals("")) {
            this.m_TimeSeparator = null;
            return;
        }
        this.m_TimeSeparator = separator;
    }

    @Override
    protected void checkAttributes() {
        PcmlDocNode resolvedNode = null;
        super.checkAttributes();
        if (this.m_CountId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_CountId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("count", this.m_CountId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlData.makeQuotedAttr("count", this.m_CountId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlData.makeQuotedAttr("count", this.m_CountId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Count < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("count", this.m_Count), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_IsRfml && this.m_CcsidWasSpecified && this.getDataType() != 1) {
            this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("ccsid", this.getAttributeValue("ccsid")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_CcsidId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_CcsidId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("ccsid", this.m_CcsidId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlData.makeQuotedAttr("ccsid", this.m_CcsidId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlData.makeQuotedAttr("ccsid", this.m_CcsidId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Ccsid < 0 || this.m_Ccsid > 65535) {
            this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{this.m_Ccsid, 0, 65535, this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getInit() != null) {
            switch (this.getDataType()) {
                default: 
            }
            try {
                TimeZone serverTimeZone = this.getDoc().getTimeZone();
                PcmlDataValues.convertValue(this.getInit(), this.getDataType(), this.getLength(), this.getPrecision(), this.getNameForException(), serverTimeZone);
            }
            catch (Exception e) {
                this.getDoc().addPcmlSpecificationError("INITIAL_VALUE_ERROR", new Object[]{this.getInit(), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_LengthId != null) {
            switch (this.getDataType()) {
                case 1: 
                case 6: 
                case 11: {
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("length", this.getAttributeValue("length")), this.getDataTypeString(), this.getBracketedTagName(), this.getNameForException()});
                }
            }
            resolvedNode = this.resolveRelativeNode(this.m_LengthId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("length", this.m_LengthId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlData.makeQuotedAttr("length", this.m_LengthId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlData.makeQuotedAttr("length", this.m_LengthId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Length < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlData.makeQuotedAttr("length", this.getAttributeValue("length")), "type=\"int\"", this.getBracketedTagName(), this.getNameForException()});
        } else {
            switch (this.getDataType()) {
                case 1: 
                case 6: 
                case 11: {
                    if (this.m_Length >= 0 && this.m_Length <= 0xFFEFF0) break;
                    this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{this.m_Length, 0, 0xFFEFF0, this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 2: {
                    if (this.m_Length == 2 || this.m_Length == 4 || this.m_Length == 8) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("length", this.m_Length), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_Length >= 1 && this.m_Length <= 31) break;
                    this.getDoc().addPcmlSpecificationError("DATA_LENGTH_OUT_OF_RANGE", new Object[]{this.m_Length, 1, 31, this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 5: {
                    if (this.m_Length == 4 || this.m_Length == 8) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("length", this.m_Length), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (this.getAttributeValue("length") == null || this.getAttributeValue("length").equals("")) break;
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("length", this.getAttributeValue("length")), PcmlData.makeQuotedAttr("type", this.getAttributeValue("type")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("BAD_DATA_TYPE", new Object[]{PcmlData.makeQuotedAttr("type", this.getAttributeValue("type")), this.getBracketedTagName(), this.getNameForException()});
                }
            }
            if (!this.m_LengthWasSpecified && this.getDataType() != 7 && this.getDataType() != 8 && this.getDataType() != 9 && this.getDataType() != 10) {
                if (this.m_IsRfml || ProgramCallDocument.exceptionIfParseError_) {
                    this.getDoc().addPcmlSpecificationError("NO_LENGTH", new Object[]{PcmlData.makeQuotedAttr("length", null), this.getBracketedTagName(), this.getNameForException()});
                } else if (Trace.isTraceOn()) {
                    Trace.log(7, "[Warning]: 'length' attribute was not specified in " + this.getBracketedTagName() + " element: " + this.getNameForException());
                }
            }
            if (this.m_IsRfml) {
                if (this.getDataType() == 7) {
                    if (this.getAttributeValue("struct") == null || this.getAttributeValue("struct").equals("")) {
                        this.getDoc().addPcmlSpecificationError("NO_STRUCT", new Object[]{PcmlData.makeQuotedAttr("struct", null), this.getBracketedTagName(), this.getNameForException()});
                    }
                } else if (this.getDataType() != 8 && this.getDataType() != 9 && this.getDataType() != 10 && !this.m_LengthWasSpecified) {
                    this.getDoc().addPcmlSpecificationError("NO_LENGTH", new Object[]{PcmlData.makeQuotedAttr("length", null), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_OffsetId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OffsetId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("offset", this.m_OffsetId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlData.makeQuotedAttr("offset", this.m_OffsetId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlData.makeQuotedAttr("offset", this.m_OffsetId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Offset < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("offset", this.m_Offset), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetfromId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OffsetfromId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("offsetfrom", this.m_OffsetfromId), this.getNameForException()});
            } else {
                String qNameResolved;
                String qName = this.getQualifiedName();
                if (qName.equals("")) {
                    qName = this.getNameForException();
                }
                if (!qName.startsWith((qNameResolved = resolvedNode.getQualifiedName()) + ".")) {
                    this.getDoc().addPcmlSpecificationError("OFFSETFROM_NOT_FOUND", new Object[]{this.m_OffsetfromId, this.getNameForException()});
                }
            }
        } else if (this.m_Offsetfrom < -1) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("offsetfrom", this.m_Offsetfrom), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OutputsizeId != null) {
            resolvedNode = this.resolveRelativeNode(this.m_OutputsizeId);
            if (resolvedNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlData.makeQuotedAttr("outputsize", this.m_OutputsizeId), this.getNameForException()});
            } else if (resolvedNode instanceof PcmlData) {
                if (((PcmlData)resolvedNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlData.makeQuotedAttr("outputsize", this.m_OutputsizeId), resolvedNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlData.makeQuotedAttr("outputsize", this.m_OutputsizeId), resolvedNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Outputsize < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("outputsize", this.m_Outputsize), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getAttributeValue("precision") != null && !this.getAttributeValue("precision").equals("")) {
            switch (this.getDataType()) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("precision", this.getAttributeValue("precision")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 2: {
                    if (this.m_Length == 2 && this.m_Precision != 15 && this.m_Precision != 16) {
                        this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    }
                    if (this.m_Length == 4 && this.m_Precision != 31 && this.m_Precision != 32) {
                        this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    }
                    if (this.m_Length != 8 || this.m_Precision == 63 || this.m_Precision == 64) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_Precision >= 0 && this.m_Precision <= this.m_Length) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("precision", this.getAttributeValue("precision")), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_StructId != null && this.getDataType() != 7) {
            this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("struct", this.getAttributeValue("struct")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Minvrm != null) {
            this.m_MinvrmInt = PcmlData.validateVRM(this.m_Minvrm);
            if (this.m_MinvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("minvrm", this.m_Minvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_Maxvrm != null) {
            this.m_MaxvrmInt = PcmlData.validateVRM(this.m_Maxvrm);
            if (this.m_MaxvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("maxvrm", this.m_Maxvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_PassbyStr != null) {
            if (this.getDoc().getVersion().compareTo("2.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("passby", this.m_PassbyStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
            }
            if (!(this.getParent() instanceof PcmlProgram)) {
                this.getDoc().addPcmlSpecificationError("NOT_CHILD_OF_PGM", new Object[]{PcmlData.makeQuotedAttr("passby", this.m_PassbyStr), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_BidistringtypeStr != null && this.getDoc().getVersion().compareTo("3.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("bidistringtype", this.m_BidistringtypeStr), "3.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_TrimStr != null && this.getDoc().getVersion().compareTo("4.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("trim", this.m_TrimStr), "4.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_CharType != null) {
            if (this.getDoc().getVersion().compareTo("4.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("chartype", this.m_CharType), "4.0", this.getBracketedTagName(), this.getNameForException()});
            } else if (this.getDataType() != 1 && this.getDataType() != 11) {
                this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("chartype", this.getAttributeValue("chartype")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_KeyFieldStr != null) {
            if (!this.m_IsRfml) {
                this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("keyfield", this.getAttributeValue("keyfield")), PcmlData.makeQuotedAttr("pcml", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
            }
            if (this.getDoc().getVersion().compareTo("5.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("keyfield", this.m_KeyFieldStr), "5.0", this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_DateFormat != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("dateformat", this.m_DateFormat), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 8: {
                    if (AS400Date.validateFormat(AS400Date.toFormat(this.m_DateFormat))) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("dateformat", this.getAttributeValue("dateformat")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("dateformat", this.getAttributeValue("dateformat")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_DateSeparator != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("dateseparator", this.m_DateSeparator), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 8: {
                    if (PcmlData.isValidSeparatorName(this.m_DateSeparator)) break;
                    Trace.log(7, "Separator name '" + this.m_DateSeparator + "' is not recognized.");
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("dateseparator", this.getAttributeValue("dateseparator")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("dateseparator", this.getAttributeValue("dateseparator")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_TimeFormat != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("timeformat", this.m_TimeFormat), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 9: {
                    if (AS400Time.validateFormat(AS400Time.toFormat(this.m_TimeFormat))) break;
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("timeformat", this.getAttributeValue("timeformat")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("timeformat", this.getAttributeValue("timeformat")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
        if (this.m_TimeSeparator != null) {
            if (this.getDoc().getVersion().compareTo("6.0") < 0) {
                this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlData.makeQuotedAttr("timeseparator", this.m_TimeSeparator), "6.0", this.getBracketedTagName(), this.getNameForException()});
            }
            switch (this.getDataType()) {
                case 9: {
                    if (PcmlData.isValidSeparatorName(this.m_TimeSeparator)) break;
                    Trace.log(7, "Separator name '" + this.m_TimeSeparator + "' is not recognized.");
                    this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlData.makeQuotedAttr("timeseparator", this.getAttributeValue("timeseparator")), this.getBracketedTagName(), this.getNameForException()});
                    break;
                }
                default: {
                    this.getDoc().addPcmlSpecificationError("ATTRIBUTE_NOT_ALLOWED", new Object[]{PcmlData.makeQuotedAttr("timeseparator", this.getAttributeValue("timeseparator")), PcmlData.makeQuotedAttr("type", this.getDataTypeString()), this.getBracketedTagName(), this.getNameForException()});
                }
            }
        }
    }

    static int validateVRM(String vrmStr) {
        int as400vrm = -1;
        int[] vrm = new int[]{-1, -1, -1};
        StringTokenizer vrmTokens = new StringTokenizer(vrmStr, vrmDelimChars, true);
        int vrmTokenNbr = 0;
        StringTokenizer vrmDelimiters = new StringTokenizer(vrmDelimChars, vrmDelimChars, true);
        if (vrmTokens.countTokens() == 6) {
            while (vrmDelimiters.hasMoreTokens()) {
                if (!vrmTokens.nextToken().equals(vrmDelimiters.nextToken())) continue;
                try {
                    vrm[vrmTokenNbr] = Integer.parseInt(vrmTokens.nextToken());
                    ++vrmTokenNbr;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (vrm[0] >= 1 && vrm[0] <= 255 && vrm[1] >= 0 && vrm[0] <= 255 && vrm[2] >= 0 && vrm[0] <= 255) {
            as400vrm = AS400.generateVRM(vrm[0], vrm[1], vrm[2]);
        }
        return as400vrm;
    }
}

