/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.Serializable;

public class ResourceLevel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final String V4R4M0 = "V4R4M0";
    public static final String V4R5M0 = "V4R5M0";
    public static final String V5R1M0 = "V5R1M0";
    private String minLevel_ = null;
    private String maxLevel_ = null;

    public ResourceLevel() {
    }

    public ResourceLevel(String minLevel) {
        this.minLevel_ = minLevel;
    }

    public ResourceLevel(String minLevel, String maxLevel) {
        if (minLevel != null && maxLevel != null && minLevel.compareTo(maxLevel) < 0) {
            throw new ExtendedIllegalArgumentException("maxLevel", 2);
        }
        this.minLevel_ = minLevel;
        this.maxLevel_ = maxLevel;
    }

    public boolean checkLevel(int vrm) {
        return this.checkLevel(ResourceLevel.vrmToLevel(vrm));
    }

    public boolean checkLevel(String level) {
        if (level == null) {
            return true;
        }
        if (level.length() == 0) {
            return true;
        }
        if (this.minLevel_ == null) {
            if (this.maxLevel_ == null) {
                return true;
            }
            return level.compareTo(this.maxLevel_) <= 0;
        }
        if (this.maxLevel_ == null) {
            return this.minLevel_.compareTo(level) <= 0;
        }
        return this.minLevel_.compareTo(level) <= 0 && level.compareTo(this.maxLevel_) <= 0;
    }

    public String getMinLevel() {
        return this.minLevel_;
    }

    public String getMaxLevel() {
        return this.maxLevel_;
    }

    public static String vrmToLevel(int vrm) {
        StringBuilder buffer = new StringBuilder("V");
        buffer.append((vrm & 0xFFFF0000) >> 16);
        buffer.append("R");
        buffer.append((vrm & 0xFF00) >> 8);
        buffer.append("M");
        buffer.append(vrm & 0xFF);
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[");
        if (this.minLevel_ != null) {
            buffer.append(this.minLevel_);
        }
        buffer.append(',');
        if (this.maxLevel_ != null) {
            buffer.append(this.maxLevel_);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

