/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class AS400ToolboxInstaller {
    private static final int INSTALL = 0;
    private static final int UNINSTALL = 1;
    private static final int COMPARE = 2;
    private static boolean isPrompt_ = false;
    private static Vector classpathAdditions_ = new Vector();
    private static Vector classpathRemovals_ = new Vector();
    private static Vector unexpandedFiles_ = new Vector();
    private static final int NOT_IN_CLASSPATH = 0;
    private static final int IN_CLASSPATH = 1;
    private static final int UNKNOWN_CLASSPATH = 2;
    private static final int NO_CHANGE = 0;
    private static final int SERVER_HAS_NEW_PTF = 1;
    private static final int SERVER_HAS_NEW_RELEASE = 2;
    private static byte[] data_ = new byte[2560];
    private static ResourceBundle resources_;
    private static boolean changeSlash_;

    private AS400ToolboxInstaller() {
    }

    private static String addTrailingSeparator(String path) {
        if (!(path.length() > 0 && path.substring(path.length() - 1).equals(File.separator) || path.length() <= 0)) {
            path = path + File.separator;
        }
        return path;
    }

    private static int classpathContains(String path) {
        try {
            String separator = System.getProperty("path.separator");
            String classpath = separator + System.getProperty("java.class.path") + separator;
            classpath = classpath.toUpperCase();
            path = path.toUpperCase();
            if (classpath.lastIndexOf(separator + path + separator) != -1) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 2;
        }
    }

    private static int comparePackageFiles(String serverFile, String clientFile) {
        int result = 0;
        boolean useOriginalCheck = true;
        try {
            StringTokenizer parseServerFile = new StringTokenizer(serverFile, "\n\r");
            StringTokenizer parseClientFile = new StringTokenizer(clientFile, "\n\r");
            String ServerVRM = parseServerFile.nextToken().toUpperCase();
            String ClientVRM = parseClientFile.nextToken().toUpperCase();
            if (ServerVRM.charAt(0) == 'V' && ClientVRM.charAt(0) == 'V' && ServerVRM.charAt(2) == 'R' && ClientVRM.charAt(2) == 'R' && ServerVRM.charAt(4) == 'M' && ClientVRM.charAt(4) == 'M') {
                if (ServerVRM.charAt(1) > ClientVRM.charAt(1)) {
                    result = 2;
                    useOriginalCheck = false;
                } else if (ServerVRM.charAt(1) < ClientVRM.charAt(1)) {
                    useOriginalCheck = false;
                } else if (ServerVRM.charAt(3) > ClientVRM.charAt(3)) {
                    result = 2;
                    useOriginalCheck = false;
                } else if (ServerVRM.charAt(3) < ClientVRM.charAt(3)) {
                    useOriginalCheck = false;
                } else if (ServerVRM.charAt(5) > ClientVRM.charAt(5)) {
                    result = 2;
                    useOriginalCheck = false;
                } else if (ServerVRM.charAt(5) < ClientVRM.charAt(5)) {
                    useOriginalCheck = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (useOriginalCheck && serverFile.length() > clientFile.length()) {
            result = 1;
        }
        return result;
    }

    private static void copyFile(String targetFile, URL sourceURL) throws IOException {
        File dir;
        InputStream in = sourceURL.openStream();
        if (!(new File(targetFile).getParent() == null || (dir = new File(new File(targetFile).getParent())).exists() || dir.mkdirs() || dir.isDirectory())) {
            throw new IOException("CANNOT_CREATE_DIRECTORY");
        }
        FileOutputStream out = new FileOutputStream(targetFile);
        int n = in.read(data_);
        while (n != -1) {
            out.write(data_, 0, n);
            n = in.read(data_);
        }
        in.close();
        out.close();
    }

    private static Vector getAllPackageNames(String source) throws IOException {
        String packageList = AS400ToolboxInstaller.readFile(new FileInputStream(source + "JT400.PKG"));
        StringTokenizer packages = new StringTokenizer(packageList);
        Vector<String> list = new Vector<String>();
        while (packages.hasMoreTokens()) {
            list.addElement(packages.nextToken());
        }
        return list;
    }

    private static Vector getAllPackageNames(URL source) throws IOException {
        String packageList = AS400ToolboxInstaller.readFile(new URL(source.toExternalForm() + "JT400.PKG"));
        StringTokenizer packages = new StringTokenizer(packageList);
        Vector<String> list = new Vector<String>();
        while (packages.hasMoreTokens()) {
            list.addElement(packages.nextToken());
        }
        return list;
    }

    public static Vector getClasspathAdditions() {
        return classpathAdditions_;
    }

    public static Vector getClasspathRemovals() {
        return classpathRemovals_;
    }

    private static ResourceBundle getMRIResource() {
        if (resources_ == null) {
            resources_ = ResourceBundle.getBundle("utilities.INMRI");
        }
        return resources_;
    }

    public static Vector getUnexpandedFiles() {
        return unexpandedFiles_;
    }

    public static boolean install(String packageName, String targetPath, URL source) throws IOException {
        String temp;
        String fileName;
        String update;
        String targetPackageFile;
        StringBuilder targetPackageFileName;
        String sourcePackageFile;
        block33: {
            if (packageName == null) {
                throw new NullPointerException("packageName");
            }
            if (targetPath == null) {
                throw new NullPointerException("targetPath");
            }
            if (source == null) {
                throw new NullPointerException("source");
            }
            if (packageName.equalsIgnoreCase("*ALL")) {
                Vector packageList = AS400ToolboxInstaller.getAllPackageNames(source);
                boolean results = false;
                Vector cpa = new Vector();
                Vector cpr = new Vector();
                Vector uf = new Vector();
                int size = packageList.size();
                for (int i = 0; i < size; ++i) {
                    int j;
                    results = AS400ToolboxInstaller.install((String)packageList.elementAt(i), targetPath, source) || results;
                    for (j = 0; j < classpathRemovals_.size(); ++j) {
                        if (cpr.contains(classpathRemovals_.elementAt(j))) continue;
                        cpr.addElement(classpathRemovals_.elementAt(j));
                    }
                    for (j = 0; j < classpathAdditions_.size(); ++j) {
                        if (cpa.contains(classpathAdditions_.elementAt(j))) continue;
                        cpa.addElement(classpathAdditions_.elementAt(j));
                    }
                    for (j = 0; j < unexpandedFiles_.size(); ++j) {
                        if (uf.contains(unexpandedFiles_.elementAt(j))) continue;
                        uf.addElement(unexpandedFiles_.elementAt(j));
                    }
                }
                classpathAdditions_ = cpa;
                classpathRemovals_ = cpr;
                unexpandedFiles_ = uf;
                return results;
            }
            classpathAdditions_.removeAllElements();
            classpathRemovals_.removeAllElements();
            unexpandedFiles_.removeAllElements();
            targetPath = AS400ToolboxInstaller.addTrailingSeparator(targetPath);
            StringBuilder sourcePackageURL = new StringBuilder(source.toExternalForm());
            sourcePackageURL.append(packageName);
            sourcePackageURL.append(".LVL");
            sourcePackageFile = AS400ToolboxInstaller.readFile(new URL(sourcePackageURL.toString()));
            targetPackageFileName = new StringBuilder(targetPath);
            targetPackageFileName.append(packageName);
            targetPackageFileName.append(".LVL");
            targetPackageFile = "";
            try {
                targetPackageFile = AS400ToolboxInstaller.readFile(new FileInputStream(targetPackageFileName.toString()));
            }
            catch (Exception e) {
                File parent;
                targetPackageFile = "";
                if (targetPath.length() <= 1 || (parent = new File(targetPath.substring(0, targetPath.length() - 1))).exists() && parent.isDirectory() || parent.mkdirs() || parent.isDirectory()) break block33;
                throw new IOException("(" + parent.toString() + ") " + AS400ToolboxInstaller.getMRIResource().getString("EXC_CANNOT_CREATE_DIRECTORY"));
            }
        }
        int updateType = AS400ToolboxInstaller.comparePackageFiles(sourcePackageFile, targetPackageFile);
        if (updateType == 0) {
            return false;
        }
        StringTokenizer sourceUpdates = new StringTokenizer(sourcePackageFile);
        StringTokenizer targetUpdates = new StringTokenizer(targetPackageFile);
        if (updateType == 1) {
            while (targetUpdates.hasMoreTokens()) {
                sourceUpdates.nextToken();
                targetUpdates.nextToken();
            }
        }
        Hashtable<String, String> finalUpdates = new Hashtable<String, String>();
        Hashtable<String, String> classpathUpdates = new Hashtable<String, String>();
        while (sourceUpdates.hasMoreTokens()) {
            StringBuffer updateFileURL = new StringBuffer(source.toExternalForm());
            updateFileURL.append(sourceUpdates.nextToken());
            updateFileURL.append(".LST");
            String updateFile = AS400ToolboxInstaller.readFile(new URL(updateFileURL.toString()));
            StringTokenizer updates = new StringTokenizer(updateFile, "\n\r");
            while (updates.hasMoreTokens()) {
                update = updates.nextToken();
                String str = update.substring(0, 8).trim();
                if (!str.equalsIgnoreCase(packageName)) continue;
                String newAction = update.substring(9, 13);
                fileName = update.length() > 19 ? update.substring(19) : "";
                if (newAction.equalsIgnoreCase("PADD") || newAction.equalsIgnoreCase("PRMV")) {
                    if (fileName.length() <= 0) continue;
                    classpathUpdates.put(fileName, update);
                    continue;
                }
                String prevUpdate = (String)finalUpdates.get(fileName);
                if (prevUpdate != null) {
                    String oldAction = prevUpdate.substring(9, 13);
                    if (newAction.equalsIgnoreCase("RMV ")) {
                        finalUpdates.put(fileName, update);
                        continue;
                    }
                    if (oldAction.equalsIgnoreCase("ADD ")) continue;
                    if (newAction.equalsIgnoreCase("ADD ")) {
                        StringBuffer workStr = new StringBuffer(update);
                        workStr.setCharAt(9, 'U');
                        workStr.setCharAt(10, 'P');
                        workStr.setCharAt(11, 'D');
                        workStr.setCharAt(12, ' ');
                        finalUpdates.put(fileName, workStr.toString());
                        continue;
                    }
                    finalUpdates.put(fileName, update);
                    continue;
                }
                finalUpdates.put(fileName, update);
            }
        }
        AS400ToolboxInstaller.copyFile(targetPath.toString() + "JT400.PKG", new URL(source.toExternalForm() + "JT400.PKG"));
        AS400ToolboxInstaller.copyFile(targetPath.toString() + packageName + ".LST", new URL(source.toExternalForm() + packageName + ".LST"));
        Enumeration e = finalUpdates.elements();
        while (e.hasMoreElements()) {
            update = (String)e.nextElement();
            String urlFile = fileName = update.substring(19);
            if (changeSlash_) {
                fileName = fileName.replace('/', '\\');
            }
            if (update.substring(9, 13).equalsIgnoreCase("RMV ")) {
                try {
                    File file = new File(targetPath.toString() + fileName);
                    file.delete();
                }
                catch (Exception file) {
                    // empty catch block
                }
                if (update.charAt(15) != 'Y') continue;
                temp = targetPath.toString() + fileName;
                if (AS400ToolboxInstaller.classpathContains(temp = new File(temp).getAbsolutePath()) == 0) continue;
                classpathRemovals_.addElement(temp);
                continue;
            }
            if (!update.substring(9, 13).equalsIgnoreCase("ADD ") && !update.substring(9, 13).equalsIgnoreCase("UPD ") && !update.substring(9, 13).equalsIgnoreCase("OADD")) continue;
            boolean miaFile = false;
            try {
                AS400ToolboxInstaller.copyFile(targetPath.toString() + fileName, new URL(source.toExternalForm() + urlFile));
            }
            catch (IOException ex) {
                if (update.substring(9, 13).equalsIgnoreCase("OADD") || fileName.length() > 11 && fileName.substring(fileName.length() - 11).equalsIgnoreCase(".properties")) {
                    miaFile = true;
                }
                throw ex;
            }
            if (miaFile) continue;
            if (update.charAt(14) == 'Y') {
                temp = targetPath.toString() + fileName;
                temp = new File(temp).getAbsolutePath();
                unexpandedFiles_.addElement(temp);
            }
            if (!update.substring(9, 13).equalsIgnoreCase("ADD ") && !update.substring(9, 13).equalsIgnoreCase("OADD") || update.charAt(15) != 'Y') continue;
            temp = targetPath.toString() + fileName;
            if (AS400ToolboxInstaller.classpathContains(temp = new File(temp).getAbsolutePath()) == 1) continue;
            classpathAdditions_.addElement(temp);
        }
        e = classpathUpdates.elements();
        while (e.hasMoreElements()) {
            update = (String)e.nextElement();
            fileName = update.length() > 19 ? update.substring(19) : "";
            fileName = update.substring(19).trim();
            if (changeSlash_) {
                fileName = fileName.replace('/', '\\');
            }
            if (fileName.length() > 0) {
                temp = targetPath.toString() + fileName;
                temp = new File(temp).getAbsolutePath();
            } else {
                temp = targetPath.length() > 1 ? targetPath.substring(0, targetPath.length() - 1) : "";
                temp = new File(temp).getAbsolutePath();
            }
            if (update.substring(9, 13).equalsIgnoreCase("PADD")) {
                if (AS400ToolboxInstaller.classpathContains(temp) == 1) continue;
                classpathAdditions_.addElement(temp);
                continue;
            }
            if (AS400ToolboxInstaller.classpathContains(temp) == 0) continue;
            classpathRemovals_.addElement(temp);
        }
        FileOutputStream out = new FileOutputStream(targetPackageFileName.toString());
        boolean position = false;
        byte[] data = sourcePackageFile.getBytes();
        out.write(data, 0, data.length);
        out.close();
        return true;
    }

    public static boolean isInstalled(String packageName, String targetPath) {
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath");
        }
        targetPath = AS400ToolboxInstaller.addTrailingSeparator(targetPath);
        StringBuilder filename = new StringBuilder(targetPath);
        filename.append(packageName);
        filename.append(".LVL");
        File file = new File(filename.toString());
        return file.exists();
    }

    public static boolean isUpdateNeeded(String packageName, String targetPath, URL source) throws IOException {
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (packageName.equalsIgnoreCase("*ALL")) {
            Vector packageList = AS400ToolboxInstaller.getAllPackageNames(source);
            int size = packageList.size();
            for (int i = 0; i < size; ++i) {
                if (!AS400ToolboxInstaller.isUpdateNeeded((String)packageList.elementAt(i), targetPath, source)) continue;
                return true;
            }
            return false;
        }
        targetPath = AS400ToolboxInstaller.addTrailingSeparator(targetPath);
        StringBuilder sourcePackageURL = new StringBuilder(source.toExternalForm());
        sourcePackageURL.append(packageName);
        sourcePackageURL.append(".LVL");
        String sourcePackageFile = AS400ToolboxInstaller.readFile(new URL(sourcePackageURL.toString()));
        StringBuilder targetPackageFileName = new StringBuilder(targetPath);
        targetPackageFileName.append(packageName);
        targetPackageFileName.append(".LVL");
        String targetPackageFile = "";
        try {
            targetPackageFile = AS400ToolboxInstaller.readFile(new FileInputStream(targetPackageFileName.toString()));
        }
        catch (Exception e) {
            targetPackageFile = "";
        }
        return AS400ToolboxInstaller.comparePackageFiles(sourcePackageFile, targetPackageFile) != 0;
    }

    public static void main(String[] args) {
        Vector packagesV = null;
        String tgtPath = null;
        String src = null;
        Integer requestedAction = null;
        String firstElement = null;
        Vector unExpandFileV = null;
        Vector classpathAddV = null;
        Vector classpathRmvV = null;
        Hashtable argsHashtable = AS400ToolboxInstaller.parseArgs(args);
        if (argsHashtable != null) {
            packagesV = (Vector)argsHashtable.get("packages");
            tgtPath = (String)argsHashtable.get("target");
            requestedAction = (Integer)argsHashtable.get("isinstall");
            src = argsHashtable.containsKey("source") ? (String)argsHashtable.get("source") : null;
            firstElement = (String)packagesV.firstElement();
            URL sourceURL = null;
            try {
                if (src != null) {
                    boolean httpIt = false;
                    if (src.length() < 5) {
                        httpIt = true;
                    } else if (!src.toLowerCase().startsWith("http") && !src.toLowerCase().startsWith("file")) {
                        httpIt = true;
                    }
                    if (httpIt) {
                        src = "http://" + src + "/QIBM/ProdData/HTTP/Public/jt400/";
                    } else if (src.toLowerCase().startsWith("file")) {
                        src = AS400ToolboxInstaller.addTrailingSeparator(src);
                    }
                    sourceURL = new URL(src);
                }
            }
            catch (MalformedURLException e) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_NOT_VALID_URL") + " " + src);
                AS400ToolboxInstaller.printUsage(System.out);
                System.exit(0);
            }
            if (requestedAction == 0) {
                Enumeration e;
                try {
                    if (firstElement.equalsIgnoreCase("*all") && packagesV.size() == 1) {
                        Vector packageList = AS400ToolboxInstaller.getAllPackageNames(sourceURL);
                        if (!isPrompt_) {
                            AS400ToolboxInstaller.install(firstElement, tgtPath, sourceURL);
                            e = packageList.elements();
                            while (e.hasMoreElements()) {
                                String message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_INSTALLED");
                                message = AS400ToolboxInstaller.substitute(message, (String)e.nextElement());
                                System.out.println(message);
                            }
                        } else {
                            e = packageList.elements();
                            while (e.hasMoreElements()) {
                                String str;
                                String pkg = (String)e.nextElement();
                                if (AS400ToolboxInstaller.isInstalled(pkg, tgtPath)) {
                                    if (AS400ToolboxInstaller.isUpdateNeeded(pkg, tgtPath, sourceURL)) {
                                        str = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_ONE");
                                        if (!AS400ToolboxInstaller.prompt(str, pkg)) continue;
                                        AS400ToolboxInstaller.install(pkg, tgtPath, sourceURL);
                                        continue;
                                    }
                                    String message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                                    message = AS400ToolboxInstaller.substitute(message, pkg);
                                    System.out.println(message);
                                    continue;
                                }
                                str = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_TWO");
                                if (!AS400ToolboxInstaller.prompt(str, pkg)) continue;
                                AS400ToolboxInstaller.install(pkg, tgtPath, sourceURL);
                            }
                        }
                    } else {
                        Enumeration e2 = packagesV.elements();
                        while (e2.hasMoreElements()) {
                            int j;
                            String str;
                            String message;
                            String pkg = (String)e2.nextElement();
                            if (!isPrompt_) {
                                AS400ToolboxInstaller.install(pkg, tgtPath, sourceURL);
                                message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_INSTALLED");
                                message = AS400ToolboxInstaller.substitute(message, pkg);
                                System.out.println(message);
                            } else if (AS400ToolboxInstaller.isInstalled(pkg, tgtPath)) {
                                if (AS400ToolboxInstaller.isUpdateNeeded(pkg, tgtPath, sourceURL)) {
                                    str = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_ONE");
                                    if (AS400ToolboxInstaller.prompt(str, pkg)) {
                                        AS400ToolboxInstaller.install(pkg, tgtPath, sourceURL);
                                    }
                                } else {
                                    message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                                    message = AS400ToolboxInstaller.substitute(message, pkg);
                                    System.out.println(message);
                                }
                            } else {
                                str = AS400ToolboxInstaller.getMRIResource().getString("PROMPT_IF_REPLACE_TWO");
                                if (AS400ToolboxInstaller.prompt(str, pkg)) {
                                    AS400ToolboxInstaller.install(pkg, tgtPath, sourceURL);
                                }
                            }
                            if (classpathAddV == null) {
                                classpathAddV = new Vector();
                            }
                            for (j = 0; j < classpathAdditions_.size(); ++j) {
                                if (classpathAddV.contains(classpathAdditions_.elementAt(j))) continue;
                                classpathAddV.addElement(classpathAdditions_.elementAt(j));
                            }
                            if (classpathRmvV == null) {
                                classpathRmvV = new Vector();
                            }
                            for (j = 0; j < classpathRemovals_.size(); ++j) {
                                if (classpathRmvV.contains(classpathRemovals_.elementAt(j))) continue;
                                classpathRmvV.addElement(classpathRemovals_.elementAt(j));
                            }
                            if (unExpandFileV == null) {
                                unExpandFileV = new Vector();
                            }
                            for (j = 0; j < unexpandedFiles_.size(); ++j) {
                                if (unExpandFileV.contains(unexpandedFiles_.elementAt(j))) continue;
                                unExpandFileV.addElement(unexpandedFiles_.elementAt(j));
                            }
                        }
                    }
                }
                catch (IOException e3) {
                    System.out.println(e3.toString());
                }
                if (unExpandFileV == null) {
                    unExpandFileV = AS400ToolboxInstaller.getUnexpandedFiles();
                }
                if (!unExpandFileV.isEmpty()) {
                    StringBuilder unExpandFileStr = new StringBuilder();
                    e = unExpandFileV.elements();
                    while (e.hasMoreElements()) {
                        unExpandFileStr.append("    ");
                        unExpandFileStr.append((String)e.nextElement());
                        unExpandFileStr.append("\n");
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_UNEXPANDED_FILES").trim() + "\n " + unExpandFileStr.toString());
                }
                if (classpathAddV == null) {
                    classpathAddV = AS400ToolboxInstaller.getClasspathAdditions();
                }
                if (!classpathAddV.isEmpty()) {
                    StringBuilder classpathAddStr = new StringBuilder();
                    e = classpathAddV.elements();
                    while (e.hasMoreElements()) {
                        classpathAddStr.append("    ");
                        classpathAddStr.append((String)e.nextElement());
                        classpathAddStr.append("\n");
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_ADD_CLASSPATHS") + "\n" + classpathAddStr.toString());
                }
                if (classpathRmvV == null) {
                    classpathRmvV = AS400ToolboxInstaller.getClasspathRemovals();
                }
                if (!classpathRmvV.isEmpty()) {
                    String classpathRmvStr = "";
                    e = classpathRmvV.elements();
                    while (e.hasMoreElements()) {
                        classpathRmvStr = classpathRmvStr + "    " + (String)e.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_REMOVE_CLASSPATHS").trim() + "\n" + classpathRmvStr);
                }
            } else if (requestedAction == 1) {
                block69: {
                    try {
                        if (firstElement.equalsIgnoreCase("*all") && packagesV.size() == 1) {
                            Enumeration e;
                            Vector<String> packageList = null;
                            Vector<String> tempList = new Vector<String>();
                            try {
                                packageList = AS400ToolboxInstaller.getAllPackageNames(AS400ToolboxInstaller.addTrailingSeparator(tgtPath));
                                e = packageList.elements();
                                while (e.hasMoreElements()) {
                                    String temp = (String)e.nextElement();
                                    File pkg = new File(AS400ToolboxInstaller.addTrailingSeparator(tgtPath) + temp + ".LVL");
                                    if (!pkg.exists()) continue;
                                    tempList.addElement(temp);
                                }
                                packageList = tempList;
                            }
                            catch (FileNotFoundException e4) {
                                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
                                System.exit(0);
                            }
                            AS400ToolboxInstaller.unInstall((String)packagesV.firstElement(), tgtPath);
                            e = packageList.elements();
                            while (e.hasMoreElements()) {
                                String pkg = (String)e.nextElement();
                                String message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_UNINSTALLED");
                                message = AS400ToolboxInstaller.substitute(message, pkg);
                                System.out.println(message);
                            }
                            break block69;
                        }
                        Enumeration e = packagesV.elements();
                        while (e.hasMoreElements()) {
                            String pkg = (String)e.nextElement();
                            AS400ToolboxInstaller.unInstall(pkg, tgtPath);
                            if (classpathRmvV == null) {
                                classpathRmvV = new Vector();
                            }
                            for (int j = 0; j < classpathRemovals_.size(); ++j) {
                                if (classpathRmvV.contains(classpathRemovals_.elementAt(j))) continue;
                                classpathRmvV.addElement(classpathRemovals_.elementAt(j));
                            }
                            String message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_UNINSTALLED");
                            message = AS400ToolboxInstaller.substitute(message, pkg);
                            System.out.println(message);
                        }
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                    }
                }
                if (classpathRmvV == null) {
                    classpathRmvV = AS400ToolboxInstaller.getClasspathRemovals();
                }
                if (!classpathRmvV.isEmpty()) {
                    String classpathRmvStr = "";
                    Enumeration e = classpathRmvV.elements();
                    while (e.hasMoreElements()) {
                        classpathRmvStr = classpathRmvStr + "    " + (String)e.nextElement() + "\n";
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("RESULT_REMOVE_CLASSPATHS").trim() + "\n" + classpathRmvStr);
                }
            } else {
                try {
                    if (firstElement.equalsIgnoreCase("*all") && packagesV.size() == 1) {
                        Vector packageList = AS400ToolboxInstaller.getAllPackageNames(sourceURL);
                        Enumeration e = packageList.elements();
                        while (e.hasMoreElements()) {
                            String message;
                            String pkgStr = (String)e.nextElement();
                            if (AS400ToolboxInstaller.isUpdateNeeded(pkgStr, tgtPath, sourceURL)) {
                                message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NEEDS_UPDATED");
                                message = AS400ToolboxInstaller.substitute(message, pkgStr);
                                System.out.println(message);
                                continue;
                            }
                            message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                            message = AS400ToolboxInstaller.substitute(message, pkgStr);
                            System.out.println(message);
                        }
                    } else {
                        Enumeration e = packagesV.elements();
                        while (e.hasMoreElements()) {
                            String message;
                            String pkgStr = (String)e.nextElement();
                            if (AS400ToolboxInstaller.isUpdateNeeded(pkgStr, tgtPath, sourceURL)) {
                                message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NEEDS_UPDATED");
                                message = AS400ToolboxInstaller.substitute(message, pkgStr);
                                System.out.println(message);
                                continue;
                            }
                            message = AS400ToolboxInstaller.getMRIResource().getString("RESULT_PACKAGE_NOT_NEED_UPDATED");
                            message = AS400ToolboxInstaller.substitute(message, pkgStr);
                            System.out.println(message);
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
            }
        }
        System.exit(0);
    }

    private static void printUsage(PrintStream output) {
        String blankSpace = "  ";
        String help02 = AS400ToolboxInstaller.getMRIResource().getString("HELP02");
        help02 = help02.trim();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < help02.length() + 1; ++i) {
            temp.append(" ");
        }
        String longBlank = temp.toString();
        output.println("");
        output.println(AS400ToolboxInstaller.getMRIResource().getString("HELP01"));
        output.println(blankSpace + help02 + " " + AS400ToolboxInstaller.getMRIResource().getString("HELP03"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP04"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP05"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP06"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP07"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP08"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP09"));
        output.println(blankSpace + longBlank + AS400ToolboxInstaller.getMRIResource().getString("HELP10"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP11"));
        output.println(blankSpace + blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP12"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP13"));
        output.println(blankSpace + blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP14"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP15"));
        output.println(blankSpace + blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP16"));
        output.println("");
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP17"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP18"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP19"));
        output.println(AS400ToolboxInstaller.getMRIResource().getString("HELP20"));
        output.println(blankSpace + AS400ToolboxInstaller.getMRIResource().getString("HELP21"));
    }

    private static Hashtable parseArgs(String[] args) {
        boolean successful = true;
        String delimiter = ",";
        Hashtable<String, Object> arguments = new Hashtable<String, Object>();
        AS400ToolboxInstaller.getMRIResource();
        if (args.length == 0) {
            AS400ToolboxInstaller.printUsage(System.out);
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equalsIgnoreCase("-p") || args[i].equalsIgnoreCase("-package")) {
                    if (arguments.containsKey("packages")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        successful = false;
                        continue;
                    }
                    Vector<String> packages = new Vector<String>();
                    if (i < args.length - 1 && args[i + 1].charAt(0) != '-') {
                        StringTokenizer packstring = new StringTokenizer(args[i + 1], delimiter);
                        while (packstring.hasMoreTokens()) {
                            String packageName = packstring.nextToken();
                            packages.addElement(packageName);
                        }
                        arguments.put("packages", packages);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + args[i]);
                    successful = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("-source")) {
                    if (arguments.containsKey("source")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        successful = false;
                        continue;
                    }
                    if (i < args.length - 1 && args[i + 1].charAt(0) != '-') {
                        arguments.put("source", args[i + 1]);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + args[i]);
                    successful = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-t") || args[i].equalsIgnoreCase("-target")) {
                    if (arguments.containsKey("target")) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        successful = false;
                        continue;
                    }
                    if (i < args.length - 1 && args[i + 1].charAt(0) != '-') {
                        arguments.put("target", args[i + 1]);
                        continue;
                    }
                    System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION_VALUE").trim() + " " + args[i]);
                    successful = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-i") || args[i].equalsIgnoreCase("-install")) {
                    if (arguments.containsKey("isinstall")) {
                        if ((Integer)arguments.get("isinstall") == 0) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + args[i]);
                        }
                        successful = false;
                        continue;
                    }
                    arguments.put("isinstall", 0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-u") || args[i].equalsIgnoreCase("-uninstall")) {
                    if (arguments.containsKey("isinstall")) {
                        if ((Integer)arguments.get("isinstall") == 1) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + args[i]);
                        }
                        successful = false;
                        continue;
                    }
                    arguments.put("isinstall", 1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("-compare")) {
                    if (arguments.containsKey("isinstall")) {
                        if ((Integer)arguments.get("isinstall") == 2) {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        } else {
                            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_OPTION_NOT_COMPATIBLE").trim() + " " + args[i]);
                        }
                        successful = false;
                        continue;
                    }
                    arguments.put("isinstall", 2);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-pr") || args[i].equalsIgnoreCase("-prompt")) {
                    if (isPrompt_) {
                        System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_TOO_MANY_OPTIONS").trim() + " " + args[i]);
                        successful = false;
                        continue;
                    }
                    isPrompt_ = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-?") || args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h")) {
                    AS400ToolboxInstaller.printUsage(System.out);
                    return null;
                }
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_UNEXPECTED_OPTION").trim() + " " + args[i]);
                successful = false;
                continue;
            }
            if (i == 0) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_INVALID_ARGUMENT") + " " + args[i]);
                successful = false;
                continue;
            }
            if (args[i - 1].equalsIgnoreCase("-package") || args[i - 1].equalsIgnoreCase("-p") || args[i - 1].equalsIgnoreCase("-source") || args[i - 1].equalsIgnoreCase("-s") || args[i - 1].equalsIgnoreCase("-target") || args[i - 1].equalsIgnoreCase("-t")) continue;
            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_INVALID_ARGUMENT") + " " + args[i]);
            successful = false;
        }
        if (!successful) {
            AS400ToolboxInstaller.printUsage(System.out);
            return null;
        }
        if (!arguments.containsKey("isinstall")) {
            System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_NO_I_U_C"));
            successful = false;
        } else if ((Integer)arguments.get("isinstall") == 0 || (Integer)arguments.get("isinstall") == 2) {
            if (!arguments.containsKey("source")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " -s");
                successful = false;
            }
            if (!arguments.containsKey("target")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " -t");
                successful = false;
            }
            if (!arguments.containsKey("packages")) {
                Vector<String> packages = new Vector<String>();
                packages.addElement("*ALL");
                arguments.put("packages", packages);
            }
        } else {
            if (arguments.containsKey("source")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("WARNING_SOURCE_URL_NOT_USED"));
            }
            if (!arguments.containsKey("target")) {
                System.out.println(AS400ToolboxInstaller.getMRIResource().getString("ERR_MISSING_OPTION").trim() + " -t");
                successful = false;
            }
            if (!arguments.containsKey("packages")) {
                Vector<String> packages = new Vector<String>();
                packages.addElement("*ALL");
                arguments.put("packages", packages);
            }
        }
        if (!successful) {
            AS400ToolboxInstaller.printUsage(System.out);
            arguments = null;
        }
        return arguments;
    }

    private static boolean prompt(String promptMsg, String pkg) {
        boolean select;
        block3: {
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            select = false;
            String message = AS400ToolboxInstaller.substitute(promptMsg, pkg);
            try {
                String resp;
                do {
                    System.out.print(message);
                    resp = d.readLine();
                    if (!resp.equalsIgnoreCase("y") && !resp.equals("1")) continue;
                    select = true;
                    break block3;
                } while (!resp.equalsIgnoreCase("n") && !resp.equals("0"));
                select = false;
            }
            catch (Exception e) {
                System.out.println("\n" + AS400ToolboxInstaller.getMRIResource().getString("EXC_INSTALLATION_ABORTED"));
            }
        }
        return select;
    }

    static String substitute(String text, String value) {
        String result = text;
        String variable = "&0";
        int j = result.indexOf(variable);
        if (j >= 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(result.substring(0, j));
            buffer.append(value);
            buffer.append(result.substring(j + variable.length()));
            result = buffer.toString();
        }
        return result;
    }

    private static String readFile(FileInputStream file) throws IOException {
        StringBuilder s = new StringBuilder();
        int n = file.read(data_);
        while (n != -1) {
            s.append(new String(data_, 0, n));
            n = file.read(data_);
        }
        file.close();
        return s.toString();
    }

    private static String readFile(URL url) throws IOException {
        InputStream in = url.openStream();
        StringBuilder s = new StringBuilder();
        int n = in.read(data_);
        while (n != -1) {
            s.append(new String(data_, 0, n));
            n = in.read(data_);
        }
        in.close();
        return s.toString();
    }

    public static Vector unInstall(String packageName, String targetPath) throws IOException {
        String temp;
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        if (targetPath == null) {
            throw new NullPointerException("targetPath");
        }
        targetPath = AS400ToolboxInstaller.addTrailingSeparator(targetPath);
        if (packageName.equalsIgnoreCase("*ALL")) {
            Vector packageList;
            try {
                packageList = AS400ToolboxInstaller.getAllPackageNames(targetPath);
            }
            catch (FileNotFoundException e) {
                throw new IOException(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
            }
            boolean packageFound = false;
            Vector results = new Vector();
            Vector tempResults = new Vector();
            Vector cpr = new Vector();
            int size = packageList.size();
            for (int i = 0; i < size; ++i) {
                int j;
                try {
                    tempResults = AS400ToolboxInstaller.unInstall((String)packageList.elementAt(i), targetPath);
                    packageFound = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (j = 0; j < tempResults.size(); ++j) {
                    results.addElement(tempResults.elementAt(j));
                }
                for (j = 0; j < classpathRemovals_.size(); ++j) {
                    if (cpr.contains(classpathRemovals_.elementAt(j))) continue;
                    cpr.addElement(classpathRemovals_.elementAt(j));
                }
            }
            if (!packageFound) {
                throw new IOException(AS400ToolboxInstaller.getMRIResource().getString("EXC_NO_PACKAGES_INSTALLED"));
            }
            classpathRemovals_ = cpr;
            File file = new File(targetPath + "JT400.PKG");
            if (file.exists() && !file.delete()) {
                results.addElement(file.getAbsolutePath());
            }
            if (targetPath.length() > 1) {
                file = new File(targetPath.substring(0, targetPath.length() - 1));
                file.delete();
            }
            return results;
        }
        classpathAdditions_.removeAllElements();
        classpathRemovals_.removeAllElements();
        unexpandedFiles_.removeAllElements();
        Vector<String> errors = new Vector<String>();
        StringBuilder listFileName = new StringBuilder(targetPath);
        listFileName.append(packageName);
        listFileName.append(".LST");
        String listFile = "";
        try {
            listFile = AS400ToolboxInstaller.readFile(new FileInputStream(listFileName.toString()));
        }
        catch (IOException e) {
            throw new IOException("(" + packageName + ") " + AS400ToolboxInstaller.getMRIResource().getString("EXC_PACKAGE_NOT_INSTALLED"));
        }
        File file = new File(targetPath + packageName + ".LVL");
        if (file.exists() && !file.delete()) {
            errors.addElement(file.getAbsolutePath());
        }
        StringTokenizer deletes = new StringTokenizer(listFile, "\n\r");
        Vector<String> paths = new Vector<String>();
        while (deletes.hasMoreTokens()) {
            String name = deletes.nextToken();
            if (changeSlash_) {
                name = name.replace('/', '\\');
            }
            if ((file = new File(targetPath + name)).exists() && !file.delete()) {
                errors.addElement(file.getAbsolutePath());
            }
            String type = name.substring(name.lastIndexOf(46) + 1).toUpperCase();
            temp = new File(targetPath + name).getAbsolutePath();
            if ((type.equalsIgnoreCase("JAR") || type.equalsIgnoreCase("ZIP")) && AS400ToolboxInstaller.classpathContains(temp) != 0 && !classpathRemovals_.contains(temp)) {
                classpathRemovals_.addElement(temp);
            }
            if ((temp = file.getParent()) == null || paths.contains(temp)) continue;
            paths.addElement(temp);
        }
        if (targetPath.length() > 1) {
            temp = targetPath.substring(0, targetPath.length() - 1);
            if (AS400ToolboxInstaller.classpathContains(temp = new File(temp).getAbsolutePath()) != 0 && !classpathRemovals_.contains(temp)) {
                classpathRemovals_.addElement(temp);
            }
        }
        if (errors.size() == 0 && !(file = new File(listFileName.toString())).delete()) {
            errors.addElement(file.getAbsolutePath());
        }
        int size = paths.size();
        temp = targetPath.length() > 1 ? targetPath.substring(0, targetPath.length() - 1) : "";
        block10: for (int j = 0; j < size; ++j) {
            String dir = (String)paths.elementAt(j);
            file = new File(dir);
            while (!file.toString().equalsIgnoreCase(temp)) {
                file.delete();
                if (AS400ToolboxInstaller.classpathContains(dir) != 0 && !classpathRemovals_.contains(dir)) {
                    classpathRemovals_.addElement(dir);
                }
                if (file.getParent() == null) continue block10;
                file = new File(file.getParent());
            }
        }
        if (targetPath.length() > 1) {
            file = new File(targetPath.substring(0, targetPath.length() - 1));
            file.delete();
        }
        return errors;
    }

    static {
        changeSlash_ = !File.separator.equals("/");
    }
}

