/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.documentation;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileExtensionSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.documentation.MetadataDelegate;
import org.apache.hop.documentation.PipelineDocDelegate;
import org.apache.hop.documentation.Toc;
import org.apache.hop.documentation.TocEntry;
import org.apache.hop.documentation.WorkflowDocDelegate;
import org.apache.hop.hop.Hop;
import org.apache.hop.hop.plugin.HopCommand;
import org.apache.hop.hop.plugin.IHopCommand;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, name="doc", description={"Generate documentation"})
@HopCommand(id="doc", description="Generate documentation")
public class DocBuilder
implements Runnable,
IHopCommand,
IHasHopMetadataProvider {
    public static final String PIPELINE_EXTENSION = "hpl";
    public static final String WORKFLOW_EXTENSION = "hwf";
    public static final String DATASETS_FOLDER = "datasets";
    public static final String METADATA_FOLDER = "metadata";
    public static final String STRING_PIPELINE = "pipeline";
    public static final String STRING_WORKFLOW = "workflow";
    public static final String ASSETS_IMAGES = "assets/images/";
    public static final String STYLES_CSS = "assets/styles.css";
    public static final String VAR_PROJECT_HOME = "PROJECT_HOME";
    public static final String VAR_PROJECT_NAME = "HOP_PROJECT_NAME";
    public static final String INDEX_MD = "index.md";
    private ILogChannel log;
    private CommandLine cmd;
    private IVariables variables;
    private MultiMetadataProvider metadataProvider;
    @CommandLine.Option(names={"-t", "--target-folder"}, description={"Specify the target parent folder where the documentation should end up"})
    private String targetParentFolder;
    @CommandLine.Option(names={"-ip", "--include-parameters"}, description={"Include a list of parameters for each pipeline and workflow"})
    private boolean includingParameters;
    @CommandLine.Option(names={"-in", "--include-notes"}, description={"List the text of any notes in alphabetical order"})
    private boolean includingNotes;
    @CommandLine.Option(names={"-im", "--include-metadata"}, description={"Include an overview of the available metadata elements"})
    private boolean includingMetadata;
    @CommandLine.Option(names={"-n", "--project-name"}, description={"The name of the project"})
    private String projectName;
    @CommandLine.Option(names={"-s", "--source-folder"}, description={"The source folder to document"})
    private String sourceFolder;
    @CommandLine.Option(names={"-gh", "--generate-html"}, description={"Generate HTML versions of documentation files"})
    private boolean generateHtml;
    @CommandLine.Option(names={"-rmmd", "--remove-markdown"}, description={"Removes markdown after generating html files"})
    private boolean removeMarkdown;

    public DocBuilder() {
    }

    public DocBuilder(ILogChannel log, IVariables variables, MultiMetadataProvider metadataProvider, String projectName, String projectHome, String targetParentFolder, boolean includingParameters, boolean includingNotes, boolean includingMetadata, boolean generateHtml, boolean removeMarkdown) {
        this.log = log;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        this.projectName = projectName;
        this.sourceFolder = projectHome;
        this.targetParentFolder = targetParentFolder;
        this.includingParameters = includingParameters;
        this.includingNotes = includingNotes;
        this.includingMetadata = includingMetadata;
        this.generateHtml = generateHtml;
        this.removeMarkdown = removeMarkdown;
    }

    public void initialize(CommandLine cmd, IVariables variables, MultiMetadataProvider metadataProvider) throws HopException {
        this.cmd = cmd;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        this.log = new LogChannel((Object)"HopDoc");
        Hop.addMixinPlugins((CommandLine)cmd, (String)"doc");
    }

    protected void handleMixinActions() throws HopException {
        Map mixins = this.cmd.getMixins();
        for (String key : mixins.keySet()) {
            Object mixin = mixins.get(key);
            if (!(mixin instanceof IConfigOptions)) continue;
            IConfigOptions configOptions = (IConfigOptions)mixin;
            configOptions.handleOption(this.log, (IHasHopMetadataProvider)this, this.variables);
        }
    }

    @Override
    public void run() {
        try {
            System.setProperty("HOP_PLATFORM_RUNTIME", "DOC");
            this.handleMixinActions();
            if (StringUtils.isNotEmpty((String)this.variables.getVariable(VAR_PROJECT_NAME))) {
                this.projectName = this.variables.getVariable(VAR_PROJECT_NAME);
            }
            if (StringUtils.isNotEmpty((String)this.variables.getVariable(VAR_PROJECT_HOME))) {
                this.sourceFolder = this.variables.getVariable(VAR_PROJECT_HOME);
            }
            if (StringUtils.isEmpty((String)this.projectName)) {
                this.projectName = "Hop";
            }
            if (StringUtils.isEmpty((String)this.sourceFolder)) {
                this.log.logError("No project home folder specified: giving up.");
                System.exit(1);
            } else {
                this.log.logBasic("Documenting folder: " + this.sourceFolder + " for project " + this.projectName);
            }
            DocBuilder docBuilder = new DocBuilder(this.log, this.variables, this.metadataProvider, this.projectName, this.sourceFolder, this.targetParentFolder, this.includingParameters, this.includingNotes, this.includingMetadata, this.generateHtml, this.removeMarkdown);
            docBuilder.buildDocumentation(new Result());
        }
        catch (Exception e) {
            this.log.logError("Error generating documentation", (Throwable)e);
        }
    }

    public void buildDocumentation(Result result) {
        try {
            Toc toc = new Toc();
            try (FileObject targetParentFolder = HopVfs.getFileObject((String)this.getTargetParentFolder());){
                this.createImagesFolder(targetParentFolder);
                this.writeStylesFile(targetParentFolder);
                try (FileObject parentFolder = HopVfs.getFileObject((String)this.sourceFolder);){
                    List<FileObject> sourceFolders = this.getSourceFolders(parentFolder, true);
                    for (FileObject sourceFolder : sourceFolders) {
                        String relativeName = parentFolder.getName().getRelativeName(sourceFolder.getName());
                        String targetName = String.valueOf(targetParentFolder) + "/" + relativeName;
                        FileObject targetFolder = HopVfs.getFileObject((String)targetName);
                        this.processDocumentationFolder(toc, targetParentFolder, sourceFolder, targetFolder, relativeName);
                    }
                }
                if (this.isIncludingMetadata()) {
                    new MetadataDelegate(this).documentMetadata(toc, targetParentFolder);
                }
            }
            this.writeToc(toc, this.targetParentFolder, this.projectName);
            this.generateHtmlFromToc(toc, this.targetParentFolder);
            this.log.logBasic("Finished generating documentation for project " + this.projectName);
        }
        catch (Exception e) {
            this.log.logError("Error building documentation", (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
    }

    private void writeToc(Toc toc, String targetParentFolder, String projectName) throws Exception {
        String targetFilename = targetParentFolder + "/index.md";
        toc.sortEntries();
        StringBuilder index = new StringBuilder();
        index.append("---").append(Const.CR).append("title: Project ").append(projectName).append(" documentation").append(Const.CR).append("---").append(Const.CR).append(Const.CR);
        index.append("**Project name**: ").append(projectName).append("  ").append(Const.CR);
        index.append("**Source folder**: ").append(this.sourceFolder).append("  ").append(Const.CR);
        index.append("**Updated**: ").append(XmlHandler.date2string((Date)new Date())).append("  ").append(Const.CR);
        index.append("---").append(Const.CR);
        for (TocEntry entry : toc.getEntries()) {
            Object path = entry.relativeFolder().equals(".") ? "" : entry.relativeFolder() + "/";
            index.append("- ").append("[").append(entry.type()).append(" : ").append((String)path).append(entry.description()).append("]").append("(").append(entry.targetDocFile()).append(")").append(Const.CR);
        }
        index.append(Const.CR);
        this.log.logBasic("Saving index (TOC) to " + targetFilename);
        this.saveFile(targetFilename, index.toString());
    }

    private void writeStylesFile(FileObject targetParentFolder) throws Exception {
        String stylesFileName = targetParentFolder.getName().getPath() + "/assets/styles.css";
        String css = "  img {\n    border: 1px solid #555;\n  }\n\n  body {\n    background-color: #ECFFFF;\n  }\n";
        this.saveFile(stylesFileName, css);
    }

    private void createImagesFolder(FileObject targetParentFolder) throws Exception {
        String imagesFolderName;
        FileObject imagesFolder;
        String assetsFolderName = targetParentFolder.getName().getPath() + "/assets";
        FileObject assetsFolder = HopVfs.getFileObject((String)assetsFolderName);
        if (!assetsFolder.exists()) {
            assetsFolder.createFolder();
        }
        if (!(imagesFolder = HopVfs.getFileObject((String)(imagesFolderName = assetsFolder.getName().getPath() + "/images"))).exists()) {
            imagesFolder.createFolder();
        }
    }

    private void processDocumentationFolder(Toc toc, FileObject targetParentFolder, FileObject sourceFolder, FileObject targetFolder, String relativeName) throws Exception {
        this.log.logBasic("Processing documentation folder " + relativeName);
        if (this.isMetadataFolder(relativeName)) {
            this.processMetadataFolders(toc, sourceFolder, targetFolder, relativeName);
        } else if (this.isDatasetsFolder(relativeName)) {
            this.processDatasetsFolder(toc, sourceFolder, targetFolder, relativeName);
        } else {
            this.processHopFolder(toc, 1, targetParentFolder, sourceFolder, targetFolder, relativeName);
        }
    }

    public boolean isMetadataFolder(String name) {
        return METADATA_FOLDER.equals(name);
    }

    public boolean isDatasetsFolder(String name) {
        return DATASETS_FOLDER.equals(name);
    }

    public boolean isPipeline(FileObject fileObject) {
        return PIPELINE_EXTENSION.equals(fileObject.getName().getExtension());
    }

    public boolean isWorkflow(FileObject fileObject) {
        return WORKFLOW_EXTENSION.equals(fileObject.getName().getExtension());
    }

    private void processHopFolder(Toc toc, int level, FileObject targetParentFolder, FileObject sourceFolder, FileObject targetFolder, String relativeName) throws Exception {
        FileObject[] childFiles;
        this.log.logBasic("Processing pipelines and workflows in folder " + relativeName);
        if (!targetFolder.exists()) {
            targetFolder.createFolder();
            this.log.logBasic("Created target folder " + targetFolder.getName().getPath());
        }
        for (FileObject subSourceFolder : this.getSourceFolders(sourceFolder, false)) {
            String relativeSubSourceFolder = sourceFolder.getName().getRelativeName(subSourceFolder.getName());
            FileObject subTargetFolder = HopVfs.getFileObject((String)(targetFolder.getName().getPath() + "/" + relativeSubSourceFolder));
            if (this.isMetadataFolder(relativeSubSourceFolder) || this.isDatasetsFolder(relativeSubSourceFolder) || ".".equals(relativeName)) continue;
            this.processHopFolder(toc, level + 1, targetParentFolder, subSourceFolder, subTargetFolder, relativeSubSourceFolder);
        }
        for (FileObject childFile : childFiles = sourceFolder.findFiles((FileSelector)new FileExtensionSelector(new String[]{PIPELINE_EXTENSION, WORKFLOW_EXTENSION}))) {
            if (!childFile.getParent().equals(sourceFolder)) continue;
            if (this.isPipeline(childFile)) {
                new PipelineDocDelegate(this).buildPipelineDocumentation(toc, targetParentFolder, sourceFolder, targetFolder, relativeName, childFile);
            }
            if (!this.isWorkflow(childFile)) continue;
            new WorkflowDocDelegate(this).buildWorkflowDocumentation(toc, targetParentFolder, sourceFolder, targetFolder, relativeName, childFile);
        }
    }

    public void saveFile(String filename, String content) throws Exception {
        try (OutputStream outputStream = HopVfs.getOutputStream((String)filename, (boolean)false);){
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
    }

    public String readFile(String fileName) throws HopException {
        String string;
        block8: {
            InputStream inputStream = HopVfs.getInputStream((String)fileName);
            try {
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HopException("Unable to read file " + fileName, (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String markdownToHtml(String markdown) {
        Parser parser = Parser.builder().build();
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        Node document = parser.parse(markdown);
        return renderer.render(document);
    }

    private void generateHtmlFromToc(Toc toc, String targetParentFolder) throws Exception {
        this.log.logBasic("generateHtml flag = " + this.generateHtml);
        this.log.logBasic("removeMarkdown flag = " + this.removeMarkdown);
        if (!this.generateHtml) {
            return;
        }
        String indexMdFile = targetParentFolder + "/index.md";
        if (new File(indexMdFile).exists()) {
            String indexMarkdown = this.readFile(indexMdFile);
            String indexHtml = this.markdownToHtml(indexMarkdown);
            indexHtml = indexHtml.replaceAll("\\.md([^a-zA-Z0-9])", ".html$1");
            String indexHtmlFile = indexMdFile.replace(".md", ".html");
            this.saveFile(indexHtmlFile, indexHtml);
            this.log.logBasic("Generated: " + indexHtmlFile + " (with fixed links)");
        }
        if (this.removeMarkdown) {
            File indexFile = new File(indexMdFile);
            if (indexFile.exists() && indexFile.delete()) {
                this.log.logBasic("Deleted index markdown file: " + indexMdFile);
            } else {
                this.log.logBasic("Failed to delete index markdown file: " + indexMdFile);
            }
        }
        for (TocEntry entry : toc.getEntries()) {
            String mdFile = targetParentFolder + "/" + entry.targetDocFile();
            String markdown = this.readFile(mdFile);
            String html = this.markdownToHtml(markdown);
            String htmlFile = mdFile.replace(".md", ".html");
            this.saveFile(htmlFile, html);
            this.log.logBasic("Generated: " + htmlFile);
            if (!this.removeMarkdown) continue;
            File file = new File(mdFile);
            if (file.exists() && file.delete()) {
                this.log.logBasic("Deleted markdown file: " + mdFile);
                continue;
            }
            this.log.logBasic("Failed to delete markdown file (or not found): " + mdFile);
        }
    }

    private void processDatasetsFolder(Toc toc, FileObject sourceFolder, FileObject targetFolder, String relativeName) {
    }

    private void processMetadataFolders(Toc toc, FileObject sourceFolder, FileObject targetFolder, String relativeName) {
    }

    private List<FileObject> getSourceFolders(FileObject parentFolder, boolean includeParent) throws Exception {
        ArrayList<FileObject> sourceFolders = new ArrayList<FileObject>();
        if (includeParent) {
            sourceFolders.add(parentFolder);
        }
        for (FileObject child : parentFolder.getChildren()) {
            if (!child.isFolder() || child.isHidden()) continue;
            sourceFolders.add(child);
        }
        return sourceFolders;
    }

    @Generated
    public ILogChannel getLog() {
        return this.log;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public String getTargetParentFolder() {
        return this.targetParentFolder;
    }

    @Generated
    public boolean isIncludingParameters() {
        return this.includingParameters;
    }

    @Generated
    public boolean isIncludingNotes() {
        return this.includingNotes;
    }

    @Generated
    public boolean isIncludingMetadata() {
        return this.includingMetadata;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getSourceFolder() {
        return this.sourceFolder;
    }

    @Generated
    public boolean isGenerateHtml() {
        return this.generateHtml;
    }

    @Generated
    public boolean isRemoveMarkdown() {
        return this.removeMarkdown;
    }

    @Generated
    public void setLog(ILogChannel log) {
        this.log = log;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setTargetParentFolder(String targetParentFolder) {
        this.targetParentFolder = targetParentFolder;
    }

    @Generated
    public void setIncludingParameters(boolean includingParameters) {
        this.includingParameters = includingParameters;
    }

    @Generated
    public void setIncludingNotes(boolean includingNotes) {
        this.includingNotes = includingNotes;
    }

    @Generated
    public void setIncludingMetadata(boolean includingMetadata) {
        this.includingMetadata = includingMetadata;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Generated
    public void setGenerateHtml(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    @Generated
    public void setRemoveMarkdown(boolean removeMarkdown) {
        this.removeMarkdown = removeMarkdown;
    }
}

