/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.types;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.types.HtmlExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.HopFileTypePlugin;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.capabilities.FileTypeCapabilities;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileType;

@HopFileTypePlugin(id="HtmlExplorerFileType", name="HTML File Type", description="HTML file handling in the explorer perspective", image="ui/images/html.svg")
public class HtmlExplorerFileType
extends BaseExplorerFileType<HtmlExplorerFileTypeHandler> {
    public HtmlExplorerFileType() {
        super("HTML File", ".html", new String[]{"*.html", "*.htm"}, new String[]{"HTML files"}, FileTypeCapabilities.getCapabilities((String[])new String[]{"Save", "SaveAs", "Close", "FileHistory", "Copy", "Select"}));
    }

    public HtmlExplorerFileTypeHandler createFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile file) {
        return new HtmlExplorerFileTypeHandler(hopGui, perspective, file);
    }

    public IHopFileTypeHandler newFile(HopGui hopGui, IVariables parentVariableSpace) throws HopException {
        return new EmptyHopFileTypeHandler();
    }

    public HtmlExplorerFileTypeHandler openFile(HopGui hopGui, String filename, IVariables variables) throws HopException {
        String resolvedFilename = variables.resolve(filename);
        if (resolvedFilename.toLowerCase().startsWith("http://") || resolvedFilename.toLowerCase().startsWith("https://")) {
            ExplorerFile explorerFile = new ExplorerFile();
            explorerFile.setName(resolvedFilename);
            explorerFile.setFilename(resolvedFilename);
            explorerFile.setFileType((IHopFileType)this);
            ExplorerPerspective perspective = ExplorerPerspective.getInstance();
            HtmlExplorerFileTypeHandler handler = this.createFileTypeHandler(hopGui, perspective, explorerFile);
            perspective.addFile((IExplorerFileTypeHandler)handler);
            return handler;
        }
        return (HtmlExplorerFileTypeHandler)super.openFile(hopGui, filename, variables);
    }
}

