/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.internal.core.graph.DsePredicate;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.javatuples.Pair;

public enum CqlCollectionPredicate implements DsePredicate
{
    contains{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument((boolean)(value instanceof Collection));
            return ((Collection)value).contains(condition);
        }
    }
    ,
    containsKey{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument((boolean)(value instanceof Map));
            return ((Map)value).containsKey(condition);
        }
    }
    ,
    containsValue{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument((boolean)(value instanceof Map));
            return ((Map)value).containsValue(condition);
        }
    }
    ,
    entryEq{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument((boolean)(condition instanceof Pair));
            Preconditions.checkArgument((boolean)(value instanceof Map));
            Pair pair = (Pair)condition;
            Map map = (Map)value;
            return Objects.equals(map.get(pair.getValue0()), pair.getValue1());
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        if (condition instanceof Pair) {
            Pair pair = (Pair)condition;
            return pair.getValue0() != null && pair.getValue1() != null;
        }
        return condition != null;
    }
}

