/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;

@Internal
public class JsonPlanGenerator {
    private static final String NOT_SET = "";
    private static final String EMPTY = "{}";

    public static String generatePlan(JobGraph jg) {
        return JsonPlanGenerator.generatePlan(jg.getJobID(), jg.getName(), jg.getJobType(), jg.getVertices(), VertexParallelism.empty());
    }

    public static String generatePlan(JobID jobID, String jobName, JobType jobType, Iterable<JobVertex> vertices, VertexParallelism vertexParallelism) {
        try {
            StringWriter writer = new StringWriter(1024);
            JsonFactory factory = new JsonFactory();
            JsonGenerator gen = factory.createGenerator((Writer)writer);
            gen.writeStartObject();
            gen.writeStringField("jid", jobID.toString());
            gen.writeStringField("name", jobName);
            gen.writeStringField("type", jobType.name());
            gen.writeArrayFieldStart("nodes");
            for (JobVertex vertex : vertices) {
                String operator = vertex.getOperatorName() != null ? vertex.getOperatorName() : NOT_SET;
                String operatorDescr = vertex.getOperatorDescription() != null ? vertex.getOperatorDescription() : NOT_SET;
                String optimizerProps = vertex.getResultOptimizerProperties() != null ? vertex.getResultOptimizerProperties() : EMPTY;
                String description = vertex.getOperatorPrettyName() != null ? vertex.getOperatorPrettyName() : vertex.getName();
                description = StringEscapeUtils.escapeHtml4((String)description);
                description = description.replace("\n", "<br/>");
                description = description.replace("\\", "&#92;");
                operatorDescr = StringEscapeUtils.escapeHtml4((String)operatorDescr);
                operatorDescr = operatorDescr.replace("\n", "<br/>");
                gen.writeStartObject();
                JobVertexID vertexID = vertex.getID();
                gen.writeStringField("id", vertexID.toString());
                gen.writeNumberField("parallelism", vertexParallelism.getParallelismOptional(vertexID).orElse(vertex.getParallelism()).intValue());
                gen.writeStringField("operator", operator);
                gen.writeStringField("operator_strategy", operatorDescr);
                gen.writeStringField("description", description);
                if (!vertex.isInputVertex()) {
                    gen.writeArrayFieldStart("inputs");
                    List<JobEdge> inputs = vertex.getInputs();
                    for (int inputNum = 0; inputNum < inputs.size(); ++inputNum) {
                        JobEdge edge = inputs.get(inputNum);
                        if (edge.getSource() == null) continue;
                        JobVertex predecessor = edge.getSource().getProducer();
                        String shipStrategy = edge.getShipStrategyName();
                        String preProcessingOperation = edge.getPreProcessingOperationName();
                        String operatorLevelCaching = edge.getOperatorLevelCachingDescription();
                        gen.writeStartObject();
                        gen.writeNumberField("num", inputNum);
                        gen.writeStringField("id", predecessor.getID().toString());
                        if (shipStrategy != null) {
                            gen.writeStringField("ship_strategy", shipStrategy);
                        }
                        if (preProcessingOperation != null) {
                            gen.writeStringField("local_strategy", preProcessingOperation);
                        }
                        if (operatorLevelCaching != null) {
                            gen.writeStringField("caching", operatorLevelCaching);
                        }
                        gen.writeStringField("exchange", edge.getSource().getResultType().name().toLowerCase());
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                }
                gen.writeFieldName("optimizer_properties");
                gen.writeRawValue(optimizerProps);
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.close();
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate plan", e);
        }
    }
}

