/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkChecker;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkWithTimestamp;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;

public class PhysicalSlotRequestBulkCheckerImpl
implements PhysicalSlotRequestBulkChecker {
    private ComponentMainThreadExecutor componentMainThreadExecutor = new ComponentMainThreadExecutor.DummyComponentMainThreadExecutor("PhysicalSlotRequestBulkCheckerImpl is not initialized with proper main thread executor, call to PhysicalSlotRequestBulkCheckerImpl#start is required");
    private final Supplier<Set<SlotInfo>> slotsRetriever;
    private final Clock clock;

    PhysicalSlotRequestBulkCheckerImpl(Supplier<Set<SlotInfo>> slotsRetriever, Clock clock) {
        this.slotsRetriever = (Supplier)Preconditions.checkNotNull(slotsRetriever);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public void start(ComponentMainThreadExecutor mainThreadExecutor) {
        this.componentMainThreadExecutor = mainThreadExecutor;
    }

    @Override
    public void schedulePendingRequestBulkTimeoutCheck(PhysicalSlotRequestBulk bulk, Time timeout) {
        PhysicalSlotRequestBulkWithTimestamp bulkWithTimestamp = new PhysicalSlotRequestBulkWithTimestamp(bulk);
        bulkWithTimestamp.markUnfulfillable(this.clock.relativeTimeMillis());
        this.schedulePendingRequestBulkWithTimestampCheck(bulkWithTimestamp, timeout);
    }

    private void schedulePendingRequestBulkWithTimestampCheck(PhysicalSlotRequestBulkWithTimestamp bulk, Time timeout) {
        this.componentMainThreadExecutor.schedule(() -> {
            TimeoutCheckResult result = this.checkPhysicalSlotRequestBulkTimeout(bulk, timeout);
            switch (result) {
                case PENDING: {
                    this.schedulePendingRequestBulkWithTimestampCheck(bulk, timeout);
                    break;
                }
                case TIMEOUT: {
                    NoResourceAvailableException cancellationCause = new NoResourceAvailableException("Slot request bulk is not fulfillable! Could not allocate the required slot within slot request timeout", new TimeoutException("Timeout has occurred: " + timeout));
                    bulk.cancel((Throwable)((Object)cancellationCause));
                    break;
                }
            }
        }, timeout.getSize(), timeout.getUnit());
    }

    @VisibleForTesting
    TimeoutCheckResult checkPhysicalSlotRequestBulkTimeout(PhysicalSlotRequestBulkWithTimestamp slotRequestBulk, Time slotRequestTimeout) {
        if (slotRequestBulk.getPendingRequests().isEmpty()) {
            return TimeoutCheckResult.FULFILLED;
        }
        boolean fulfillable = PhysicalSlotRequestBulkCheckerImpl.isSlotRequestBulkFulfillable(slotRequestBulk, this.slotsRetriever);
        if (fulfillable) {
            slotRequestBulk.markFulfillable();
        } else {
            long currentTimestamp = this.clock.relativeTimeMillis();
            slotRequestBulk.markUnfulfillable(currentTimestamp);
            long unfulfillableSince = slotRequestBulk.getUnfulfillableSince();
            if (unfulfillableSince + slotRequestTimeout.toMilliseconds() <= currentTimestamp) {
                return TimeoutCheckResult.TIMEOUT;
            }
        }
        return TimeoutCheckResult.PENDING;
    }

    @VisibleForTesting
    static boolean isSlotRequestBulkFulfillable(PhysicalSlotRequestBulk slotRequestBulk, Supplier<Set<SlotInfo>> slotsRetriever) {
        Set<AllocationID> assignedSlots = slotRequestBulk.getAllocationIdsOfFulfilledRequests();
        Set<SlotInfo> reusableSlots = PhysicalSlotRequestBulkCheckerImpl.getReusableSlots(slotsRetriever, assignedSlots);
        return PhysicalSlotRequestBulkCheckerImpl.areRequestsFulfillableWithSlots(slotRequestBulk.getPendingRequests(), reusableSlots);
    }

    private static Set<SlotInfo> getReusableSlots(Supplier<Set<SlotInfo>> slotsRetriever, Set<AllocationID> slotsToExclude) {
        return slotsRetriever.get().stream().filter(slotInfo -> !slotInfo.willBeOccupiedIndefinitely()).filter(slotInfo -> !slotsToExclude.contains((Object)slotInfo.getAllocationId())).collect(Collectors.toSet());
    }

    private static boolean areRequestsFulfillableWithSlots(Collection<ResourceProfile> requestResourceProfiles, Set<SlotInfo> slots) {
        HashSet<SlotInfo> remainingSlots = new HashSet<SlotInfo>(slots);
        for (ResourceProfile requestResourceProfile : requestResourceProfiles) {
            Optional<SlotInfo> matchedSlot = PhysicalSlotRequestBulkCheckerImpl.findMatchingSlotForRequest(requestResourceProfile, remainingSlots);
            if (matchedSlot.isPresent()) {
                remainingSlots.remove(matchedSlot.get());
                continue;
            }
            return false;
        }
        return true;
    }

    private static Optional<SlotInfo> findMatchingSlotForRequest(ResourceProfile requestResourceProfile, Collection<SlotInfo> slots) {
        return slots.stream().filter(slot -> slot.getResourceProfile().isMatching(requestResourceProfile)).findFirst();
    }

    public static PhysicalSlotRequestBulkCheckerImpl createFromSlotPool(SlotPool slotPool, Clock clock) {
        return new PhysicalSlotRequestBulkCheckerImpl(() -> PhysicalSlotRequestBulkCheckerImpl.getAllSlotInfos(slotPool), clock);
    }

    private static Set<SlotInfo> getAllSlotInfos(SlotPool slotPool) {
        return Stream.concat(slotPool.getFreeSlotInfoTracker().getFreeSlotsInformation().stream(), slotPool.getAllocatedSlotsInformation().stream()).collect(Collectors.toSet());
    }

    static enum TimeoutCheckResult {
        PENDING,
        FULFILLED,
        TIMEOUT;

    }
}

