/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.aws.sqs.AwsSqsReader;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderData;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderMeta;

public class SqsReader
extends BaseTransform<SqsReaderMeta, SqsReaderData> {
    private static Class<?> PKG = SqsReaderMeta.class;

    public SqsReader(TransformMeta transformMeta, SqsReaderMeta meta, SqsReaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((SqsReaderData)this.data).aws_sqs = new AwsSqsReader((SqsReaderMeta)this.meta, this.getPipelineMeta(), this);
        if (!((SqsReaderData)this.data).aws_sqs.getAWSConnection()) {
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        ((SqsReaderData)this.data).realSQSQueue = this.resolve(((SqsReaderMeta)this.meta).getSqsQueue());
        ((SqsReaderData)this.data).realMessageIDFieldName = this.resolve(((SqsReaderMeta)this.meta).getTFldMessageID());
        ((SqsReaderData)this.data).realMessageBodyFieldName = this.resolve(((SqsReaderMeta)this.meta).getTFldMessageBody());
        ((SqsReaderData)this.data).realReceiptHandleFieldName = this.resolve(((SqsReaderMeta)this.meta).getTFldReceiptHandle());
        ((SqsReaderData)this.data).realBodyMD5FieldName = this.resolve(((SqsReaderMeta)this.meta).getTFldBodyMD5());
        ((SqsReaderData)this.data).realSNSMessageFieldName = this.resolve(((SqsReaderMeta)this.meta).getTFldSNSMessage());
        try {
            ((SqsReaderData)this.data).realMaxMessages = Integer.valueOf(this.resolve(((SqsReaderMeta)this.meta).getTFldMaxMessages()));
            if (((SqsReaderData)this.data).realMaxMessages < 0) {
                throw new NumberFormatException("Max Messages value < 0");
            }
        }
        catch (NumberFormatException e) {
            this.logError(BaseMessages.getString(PKG, (String)"SQSReader.Log.MaxMessagesNumber.ERROR", (String[])new String[0]));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return super.init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean processRow() throws HopException {
        block15: {
            if (this.first) {
                this.first = false;
                ((SqsReaderData)this.data).outputRowMeta = new RowMeta();
                ((SqsReaderMeta)this.meta).getFields(((SqsReaderData)this.data).outputRowMeta, this.getTransformName(), null, null, this.variables, null);
                if (this.isBasic()) {
                    this.logBasic("Start reading from queue");
                }
            }
            if (Utils.isEmpty((CharSequence)((SqsReaderData)this.data).realMessageIDFieldName) || Utils.isEmpty((CharSequence)((SqsReaderData)this.data).realMessageBodyFieldName)) {
                this.logError(BaseMessages.getString(PKG, (String)"SQSReader.Log.NoMessageFields.ERROR", (String[])new String[0]));
                throw new HopException(BaseMessages.getString(PKG, (String)"SQSReader.Log.NoMessageFields.ERROR", (String[])new String[0]));
            }
            if (((SqsReaderData)this.data).realMaxMessages == 0 || this.getLinesInput() < (long)((SqsReaderData)this.data).realMaxMessages.intValue()) {
                int numMessages = (int)(((SqsReaderData)this.data).realMaxMessages == 0 ? 10L : (long)((SqsReaderData)this.data).realMaxMessages.intValue() - this.getLinesInput());
                List<Message> messages = ((SqsReaderData)this.data).aws_sqs.readMessages(((SqsReaderData)this.data).realSQSQueue, numMessages, this.getPipeline().isPreview());
                if (!messages.isEmpty()) {
                    for (Message m : messages) {
                        int idxSNSMessageField;
                        int idxBodyMD5Field;
                        int idxReceiptHandleField;
                        int idxMessageBodyField;
                        Object[] outputRow = RowDataUtil.allocateRowData((int)((SqsReaderData)this.data).outputRowMeta.size());
                        int idxMessageIdField = ((SqsReaderData)this.data).outputRowMeta.indexOfValue(((SqsReaderData)this.data).realMessageIDFieldName);
                        if (idxMessageIdField >= 0) {
                            outputRow[idxMessageIdField] = m.getMessageId();
                        }
                        if ((idxMessageBodyField = ((SqsReaderData)this.data).outputRowMeta.indexOfValue(((SqsReaderData)this.data).realMessageBodyFieldName)) >= 0) {
                            outputRow[idxMessageBodyField] = m.getBody();
                        }
                        if ((idxReceiptHandleField = ((SqsReaderData)this.data).outputRowMeta.indexOfValue(((SqsReaderData)this.data).realReceiptHandleFieldName)) >= 0) {
                            outputRow[idxReceiptHandleField] = m.getReceiptHandle();
                        }
                        if ((idxBodyMD5Field = ((SqsReaderData)this.data).outputRowMeta.indexOfValue(((SqsReaderData)this.data).realBodyMD5FieldName)) >= 0) {
                            outputRow[idxBodyMD5Field] = m.getMD5OfBody();
                        }
                        if ((idxSNSMessageField = ((SqsReaderData)this.data).outputRowMeta.indexOfValue(((SqsReaderData)this.data).realSNSMessageFieldName)) >= 0) {
                            outputRow[idxSNSMessageField] = this.getSNSMessageContent(m.getBody());
                        }
                        this.putRow(((SqsReaderData)this.data).outputRowMeta, outputRow);
                        this.incrementLinesInput();
                    }
                    break block15;
                } else {
                    this.setOutputDone();
                    if (this.isBasic()) {
                        this.logBasic("Finished reading from queue");
                    }
                    return false;
                }
            }
            this.setOutputDone();
            if (this.isBasic()) {
                this.logBasic("Finished reading from queue");
            }
            return false;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private String getSNSMessageContent(String body) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory factory = new JsonFactory();
            factory.setCodec((ObjectCodec)mapper);
            JsonParser parser = factory.createParser(body);
            JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
            JsonNode statusNode = jsonNode.get("Message");
            return statusNode.textValue();
        }
        catch (JsonParseException e) {
            this.logError("Error parsing JSON: " + e.getMessage());
            return "";
        }
        catch (IOException e) {
            this.logError("IO Error: " + e.getMessage());
            return "";
        }
    }
}

