/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.concurrent.LocalAwareExecutorPlus;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Future;

public enum Stage {
    READ(false, "ReadStage", "request", DatabaseDescriptor::getConcurrentReaders, DatabaseDescriptor::setConcurrentReaders, Stage::multiThreadedLowSignalStage),
    MUTATION(true, "MutationStage", "request", DatabaseDescriptor::getConcurrentWriters, DatabaseDescriptor::setConcurrentWriters, Stage::multiThreadedLowSignalStage),
    COUNTER_MUTATION(true, "CounterMutationStage", "request", DatabaseDescriptor::getConcurrentCounterWriters, DatabaseDescriptor::setConcurrentCounterWriters, Stage::multiThreadedLowSignalStage),
    VIEW_MUTATION(true, "ViewMutationStage", "request", DatabaseDescriptor::getConcurrentViewWriters, DatabaseDescriptor::setConcurrentViewWriters, Stage::multiThreadedLowSignalStage),
    GOSSIP(true, "GossipStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    REQUEST_RESPONSE(false, "RequestResponseStage", "request", FBUtilities::getAvailableProcessors, null, Stage::multiThreadedLowSignalStage),
    ANTI_ENTROPY(false, "AntiEntropyStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    MIGRATION(false, "MigrationStage", "internal", () -> 1, null, Stage::migrationStage),
    MISC(false, "MiscStage", "internal", () -> 1, null, Stage::singleThreadedStage),
    TRACING(false, "TracingStage", "internal", () -> 1, null, Stage::tracingStage),
    INTERNAL_RESPONSE(false, "InternalResponseStage", "internal", FBUtilities::getAvailableProcessors, null, Stage::multiThreadedStage),
    IMMEDIATE(false, "ImmediateStage", "internal", () -> 0, null, Stage::immediateExecutor),
    PAXOS_REPAIR(false, "PaxosRepairStage", "internal", FBUtilities::getAvailableProcessors, null, Stage::multiThreadedStage);

    public final String jmxName;
    private final Supplier<ExecutorPlus> executorSupplier;
    private volatile ExecutorPlus executor;
    public final boolean shutdownBeforeCommitlog;
    private static final Map<String, Stage> nameMap;

    private Stage(boolean shutdownBeforeCommitlog, String jmxName, String jmxType, IntSupplier numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize, ExecutorServiceInitialiser executorSupplier) {
        this.shutdownBeforeCommitlog = shutdownBeforeCommitlog;
        this.jmxName = jmxName;
        this.executorSupplier = () -> executorSupplier.init(jmxName, jmxType, numThreads.getAsInt(), onSetMaximumPoolSize);
    }

    private static String normalizeName(String stageName) {
        String upperStageName = stageName.toUpperCase();
        if (upperStageName.endsWith("STAGE")) {
            upperStageName = upperStageName.substring(0, stageName.length() - 5);
        }
        return upperStageName;
    }

    public static Stage fromPoolName(String stageName) {
        String upperStageName = Stage.normalizeName(stageName);
        Stage result = nameMap.get(upperStageName);
        if (result != null) {
            return result;
        }
        try {
            return Stage.valueOf(upperStageName);
        }
        catch (IllegalArgumentException e) {
            switch (upperStageName) {
                case "CONCURRENT_READS": {
                    return READ;
                }
                case "CONCURRENT_WRITERS": {
                    return MUTATION;
                }
                case "CONCURRENT_COUNTER_WRITES": {
                    return COUNTER_MUTATION;
                }
                case "CONCURRENT_MATERIALIZED_VIEW_WRITES": {
                    return VIEW_MUTATION;
                }
            }
            throw new IllegalStateException("Must be one of " + Arrays.stream(Stage.values()).map(Enum::toString).collect(Collectors.joining(",")));
        }
    }

    public void execute(Runnable task) {
        this.executor().execute(task);
    }

    public void execute(ExecutorLocals locals, Runnable task) {
        this.executor().execute(locals, task);
    }

    public void maybeExecuteImmediately(Runnable task) {
        this.executor().maybeExecuteImmediately(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor().submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this.executor().submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor().submit(task, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorPlus executor() {
        if (this.executor == null) {
            Stage stage = this;
            synchronized (stage) {
                if (this.executor == null) {
                    this.executor = this.executorSupplier.get();
                }
            }
        }
        return this.executor;
    }

    private static List<ExecutorPlus> executors() {
        return Stream.of(Stage.values()).map(Stage::executor).collect(Collectors.toList());
    }

    private static List<ExecutorPlus> mutatingExecutors() {
        return Stream.of(Stage.values()).filter(stage -> stage.shutdownBeforeCommitlog).map(Stage::executor).collect(Collectors.toList());
    }

    public static void shutdownNow() {
        ExecutorUtils.shutdownNow(Stage.executors());
    }

    public static void shutdownAndAwaitMutatingExecutors(boolean interrupt, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        List<ExecutorPlus> executors = Stage.mutatingExecutors();
        ExecutorUtils.shutdown(interrupt, executors);
        ExecutorUtils.awaitTermination(timeout, units, executors);
    }

    public static boolean areMutationExecutorsTerminated() {
        return Stage.mutatingExecutors().stream().allMatch(ExecutorService::isTerminated);
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        List<ExecutorPlus> executors = Stage.executors();
        ExecutorUtils.shutdownNow(executors);
        ExecutorUtils.awaitTermination(timeout, units, executors);
    }

    private static ExecutorPlus tracingStage(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return (ExecutorPlus)ExecutorFactory.Global.executorFactory().withJmx(jmxType).configureSequential(jmxName).withQueueLimit(1000).withRejectedExecutionHandler((r, executor) -> MessagingService.instance().metrics.recordSelfDroppedMessage(Verb._TRACE)).build();
    }

    private static ExecutorPlus migrationStage(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return ExecutorFactory.Global.executorFactory().localAware().withJmx(jmxType).sequential(jmxName);
    }

    private static LocalAwareExecutorPlus singleThreadedStage(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return (LocalAwareExecutorPlus)ExecutorFactory.Global.executorFactory().localAware().withJmx(jmxType).sequential(jmxName);
    }

    static LocalAwareExecutorPlus multiThreadedStage(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return (LocalAwareExecutorPlus)ExecutorFactory.Global.executorFactory().localAware().withJmx(jmxType).pooled(jmxName, numThreads);
    }

    static LocalAwareExecutorPlus multiThreadedLowSignalStage(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return ExecutorFactory.Global.executorFactory().localAware().withJmx(jmxType).shared(jmxName, numThreads, onSetMaximumPoolSize);
    }

    static LocalAwareExecutorPlus immediateExecutor(String jmxName, String jmxType, int numThreads, ExecutorPlus.MaximumPoolSizeListener onSetMaximumPoolSize) {
        return ImmediateExecutor.INSTANCE;
    }

    public int getCorePoolSize() {
        return this.executor().getCorePoolSize();
    }

    public void setCorePoolSize(int newCorePoolSize) {
        this.executor().setCorePoolSize(newCorePoolSize);
    }

    public int getMaximumPoolSize() {
        return this.executor().getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int newMaximumPoolSize) {
        this.executor().setMaximumPoolSize(newMaximumPoolSize);
    }

    static {
        nameMap = Arrays.stream(Stage.values()).collect(Collectors.toMap(s -> Stage.normalizeName(s.jmxName), s -> s));
    }

    @FunctionalInterface
    public static interface ExecutorServiceInitialiser {
        public ExecutorPlus init(String var1, String var2, int var3, ExecutorPlus.MaximumPoolSizeListener var4);
    }
}

