/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class DoFnRunnerWithMetricsUpdate<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer container;
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> delegate;

    public DoFnRunnerWithMetricsUpdate(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> delegate, @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer metricContainer) {
        this.stepName = stepName;
        this.delegate = delegate;
        this.container = metricContainer;
    }

    public void startBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.startBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.processElement(elem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
            this.delegate.finishBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.container.updateMetrics(this.stepName);
    }

    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        this.delegate.onWindowExpiration(window, timestamp, key);
    }

    public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
        return this.delegate.getFn();
    }
}

