/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.io.BsonOutput;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    static final int MESSAGE_PROLOGUE_LENGTH = 16;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, MessageSettings settings) {
        this(opCode, REQUEST_ID.getAndIncrement(), settings);
    }

    RequestMessage(OpCode opCode, int requestId, MessageSettings settings) {
        this.settings = settings;
        this.id = requestId;
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public void encode(ByteBufferBsonOutput bsonOutput, OperationContext operationContext) {
        Assertions.notNull("operationContext", operationContext);
        int messageStartPosition = bsonOutput.getPosition();
        this.writeMessagePrologue((BsonOutput)bsonOutput);
        this.encodeMessageBody(bsonOutput, operationContext);
        BsonWriterHelper.backpatchLength(messageStartPosition, (BsonOutput)bsonOutput);
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract void encodeMessageBody(ByteBufferBsonOutput var1, OperationContext var2);
}

