/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.FieldNameValidator;

public final class UpdateFieldNameValidator
implements FieldNameValidator {
    private boolean encounteredField = false;

    public boolean validate(String fieldName) {
        this.encounteredField = true;
        return fieldName.startsWith("$");
    }

    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(fieldName.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", fieldName);
    }

    public FieldNameValidator getValidatorForField(String fieldName) {
        return NoOpFieldNameValidator.INSTANCE;
    }

    public void start() {
        this.reset();
    }

    public void end() {
        if (!this.encounteredField) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }

    public UpdateFieldNameValidator reset() {
        this.encounteredField = false;
        return this;
    }
}

