/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.repeatfields;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.repeatfields.Repeat;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFieldsData;
import org.apache.hop.pipeline.transforms.repeatfields.RepeatFieldsMeta;

public class RepeatFields
extends BaseTransform<RepeatFieldsMeta, RepeatFieldsData> {
    public RepeatFields(TransformMeta transformMeta, RepeatFieldsMeta meta, RepeatFieldsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((RepeatFieldsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((RepeatFieldsMeta)this.meta).getFields(((RepeatFieldsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((RepeatFieldsData)this.data).groupIndexes = new ArrayList<Integer>();
            for (String groupField : ((RepeatFieldsMeta)this.meta).getGroupFields()) {
                int index = this.getInputRowMeta().indexOfValue(groupField);
                if (index < 0) {
                    throw new HopException("Unable to find group field: " + groupField);
                }
                ((RepeatFieldsData)this.data).groupIndexes.add(index);
            }
            ((RepeatFieldsData)this.data).sourceIndexes = new ArrayList<Integer>();
            ((RepeatFieldsData)this.data).indicatorIndexes = new ArrayList<Integer>();
            for (Repeat repeat : ((RepeatFieldsMeta)this.meta).getRepeats()) {
                String sourceFieldName = this.resolve(repeat.getSourceField());
                int index = this.getInputRowMeta().indexOfValue(sourceFieldName);
                if (index < 0) {
                    throw new HopException("Unable to find source field to repeat: " + sourceFieldName);
                }
                ((RepeatFieldsData)this.data).sourceIndexes.add(index);
                int indicatorIndex = -1;
                String indicatorFieldName = this.resolve(repeat.getIndicatorFieldName());
                if (StringUtils.isNotEmpty((String)indicatorFieldName) && (indicatorIndex = this.getInputRowMeta().indexOfValue(indicatorFieldName)) < 0) {
                    throw new HopException("Unable to find indicator field: " + indicatorFieldName);
                }
                ((RepeatFieldsData)this.data).indicatorIndexes.add(indicatorIndex);
            }
        }
        if (this.isNewGroup(r, ((RepeatFieldsData)this.data).previousRow)) {
            this.startNewGroup();
        }
        Object[] outputRow = RowDataUtil.resizeArray((Object[])r, (int)((RepeatFieldsData)this.data).outputRowMeta.size());
        int targetIndex = this.getInputRowMeta().size();
        for (int i = 0; i < ((RepeatFieldsMeta)this.meta).getRepeats().size(); ++i) {
            Object sourceValue;
            Repeat repeat = ((RepeatFieldsMeta)this.meta).getRepeats().get(i);
            int sourceIndex = ((RepeatFieldsData)this.data).sourceIndexes.get(i);
            IValueMeta sourceValueMeta = this.getInputRowMeta().getValueMeta(sourceIndex);
            Object targetValue = sourceValue = r[sourceIndex];
            switch (repeat.getType()) {
                case Previous: {
                    targetValue = this.getPreviousValue(sourceValue, targetIndex);
                    break;
                }
                case PreviousWhenNull: {
                    if (!sourceValueMeta.isNull(sourceValue)) break;
                    targetValue = this.getPreviousValue(null, targetIndex);
                    break;
                }
                case CurrentWhenIndicated: {
                    targetValue = this.getCurrentValueWhenIndicated(i, repeat, r, sourceValue, targetIndex);
                }
            }
            outputRow[targetIndex] = targetValue;
            ++targetIndex;
        }
        ((RepeatFieldsData)this.data).previousRow = ((RepeatFieldsData)this.data).outputRowMeta.cloneRow(outputRow);
        this.putRow(((RepeatFieldsData)this.data).outputRowMeta, outputRow);
        return true;
    }

    private Object getCurrentValueWhenIndicated(int i, Repeat repeat, Object[] r, Object sourceValue, int targetIndex) throws HopException {
        int indicatorIndex = ((RepeatFieldsData)this.data).indicatorIndexes.get(i);
        if (indicatorIndex < 0) {
            throw new HopException("Unable to find indicator field: " + repeat.getIndicatorFieldName());
        }
        String indicator = this.getInputRowMeta().getString(r, indicatorIndex);
        if (StringUtils.isEmpty((String)indicator)) {
            throw new HopException("No indicator value was found in field " + repeat.getIndicatorFieldName());
        }
        Object targetValue = indicator.equals(repeat.getIndicatorValue()) ? sourceValue : (((RepeatFieldsData)this.data).previousRow == null ? sourceValue : ((RepeatFieldsData)this.data).previousRow[targetIndex]);
        return targetValue;
    }

    private Object getPreviousValue(Object sourceValue, int targetIndex) {
        Object value = sourceValue;
        if (((RepeatFieldsData)this.data).previousRow != null) {
            value = ((RepeatFieldsData)this.data).previousRow[targetIndex];
        }
        return value;
    }

    private void startNewGroup() {
        ((RepeatFieldsData)this.data).previousRow = null;
    }

    private boolean isNewGroup(Object[] currentRow, Object[] previousRow) throws HopValueException {
        if (previousRow == null) {
            return true;
        }
        int compare = this.getInputRowMeta().compare(currentRow, previousRow, Ints.toArray(((RepeatFieldsData)this.data).groupIndexes));
        return compare != 0;
    }
}

