/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.UInt32Value;
import io.grpc.Attributes;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalGracefulServerCloseCommand;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.FilterChainSelectorManager;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsServerWrapper;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.internal.security.SecurityProtocolNegotiators;
import io.grpc.xds.internal.security.SslContextProviderSupplier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class FilterChainMatchingProtocolNegotiators {
    private static final Logger log = Logger.getLogger(FilterChainMatchingProtocolNegotiators.class.getName());
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"http");

    private FilterChainMatchingProtocolNegotiators() {
    }

    private static class GracefullyShutdownChannelRunnable
    implements Runnable {
        private final Channel channel;
        private final long drainGraceTime;
        @Nullable
        private final TimeUnit drainGraceTimeUnit;

        public GracefullyShutdownChannelRunnable(Channel channel, long drainGraceTime, @Nullable TimeUnit drainGraceTimeUnit) {
            this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
            this.drainGraceTime = drainGraceTime;
            this.drainGraceTimeUnit = drainGraceTimeUnit;
        }

        @Override
        public void run() {
            Object gracefulCloseCommand = InternalGracefulServerCloseCommand.create((String)"xds_drain", (long)this.drainGraceTime, (TimeUnit)this.drainGraceTimeUnit);
            this.channel.writeAndFlush(gracefulCloseCommand).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    private static class FilterChainSelectorManagerDeregister
    implements ChannelFutureListener {
        private final FilterChainSelectorManager filterChainSelectorManager;
        private final FilterChainSelectorManager.Closer closer;

        public FilterChainSelectorManagerDeregister(FilterChainSelectorManager filterChainSelectorManager, FilterChainSelectorManager.Closer closer) {
            this.filterChainSelectorManager = (FilterChainSelectorManager)Preconditions.checkNotNull((Object)filterChainSelectorManager, (Object)"filterChainSelectorManager");
            this.closer = (FilterChainSelectorManager.Closer)Preconditions.checkNotNull((Object)closer, (Object)"closer");
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.filterChainSelectorManager.deregister(this.closer);
        }
    }

    private static final class SelectedConfig {
        private final AtomicReference<XdsServerWrapper.ServerRoutingConfig> routingConfig;
        @Nullable
        private final SslContextProviderSupplier sslContextProviderSupplier;

        private SelectedConfig(AtomicReference<XdsServerWrapper.ServerRoutingConfig> routingConfig, @Nullable SslContextProviderSupplier sslContextProviderSupplier) {
            this.routingConfig = (AtomicReference)Preconditions.checkNotNull(routingConfig, (Object)"routingConfig");
            this.sslContextProviderSupplier = sslContextProviderSupplier;
        }
    }

    static final class FilterChainMatchingNegotiatorServerFactory
    implements InternalProtocolNegotiator.ServerFactory {
        private final InternalProtocolNegotiator.ServerFactory delegate;

        public FilterChainMatchingNegotiatorServerFactory(InternalProtocolNegotiator.ServerFactory delegate) {
            this.delegate = (InternalProtocolNegotiator.ServerFactory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator(final ObjectPool<? extends Executor> offloadExecutorPool) {
            class FilterChainMatchingNegotiator
            implements InternalProtocolNegotiator.ProtocolNegotiator {
                FilterChainMatchingNegotiator() {
                }

                public AsciiString scheme() {
                    return SCHEME;
                }

                public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                    FilterChainSelectorManager filterChainSelectorManager = (FilterChainSelectorManager)grpcHandler.getEagAttributes().get(XdsAttributes.ATTR_FILTER_CHAIN_SELECTOR_MANAGER);
                    Preconditions.checkNotNull((Object)filterChainSelectorManager, (Object)"filterChainSelectorManager");
                    return new FilterChainMatchingHandler(grpcHandler, filterChainSelectorManager, FilterChainMatchingNegotiatorServerFactory.this.delegate.newNegotiator(offloadExecutorPool));
                }

                public void close() {
                }
            }
            return new FilterChainMatchingNegotiator();
        }
    }

    @VisibleForTesting
    static final class FilterChainMatchingHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final FilterChainSelectorManager filterChainSelectorManager;
        private final InternalProtocolNegotiator.ProtocolNegotiator delegate;

        FilterChainMatchingHandler(GrpcHttp2ConnectionHandler grpcHandler, FilterChainSelectorManager filterChainSelectorManager, InternalProtocolNegotiator.ProtocolNegotiator delegate) {
            this.grpcHandler = (GrpcHttp2ConnectionHandler)Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.filterChainSelectorManager = (FilterChainSelectorManager)Preconditions.checkNotNull((Object)filterChainSelectorManager, (Object)"filterChainSelectorManager");
            this.delegate = (InternalProtocolNegotiator.ProtocolNegotiator)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof ProtocolNegotiationEvent)) {
                super.userEventTriggered(ctx, evt);
                return;
            }
            long drainGraceTime = 0L;
            TimeUnit drainGraceTimeUnit = null;
            Long drainGraceNanosObj = (Long)this.grpcHandler.getEagAttributes().get(XdsAttributes.ATTR_DRAIN_GRACE_NANOS);
            if (drainGraceNanosObj != null) {
                drainGraceTime = drainGraceNanosObj;
                drainGraceTimeUnit = TimeUnit.NANOSECONDS;
            }
            FilterChainSelectorManager.Closer closer = new FilterChainSelectorManager.Closer(new GracefullyShutdownChannelRunnable(ctx.channel(), drainGraceTime, drainGraceTimeUnit));
            FilterChainSelector selector = this.filterChainSelectorManager.register(closer);
            ctx.channel().closeFuture().addListener((GenericFutureListener)new FilterChainSelectorManagerDeregister(this.filterChainSelectorManager, closer));
            Preconditions.checkNotNull((Object)selector, (Object)"selector");
            SelectedConfig config = selector.select((InetSocketAddress)ctx.channel().localAddress(), (InetSocketAddress)ctx.channel().remoteAddress());
            if (config == null) {
                log.log(Level.WARNING, "Connection from {0} to {1} has no matching filter chain. Closing", new Object[]{ctx.channel().remoteAddress(), ctx.channel().localAddress()});
                ctx.close().addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                return;
            }
            ProtocolNegotiationEvent pne = (ProtocolNegotiationEvent)evt;
            Attributes attr = InternalProtocolNegotiationEvent.getAttributes((ProtocolNegotiationEvent)pne).toBuilder().set(SecurityProtocolNegotiators.ATTR_SERVER_SSL_CONTEXT_PROVIDER_SUPPLIER, (Object)config.sslContextProviderSupplier).set(XdsServerWrapper.ATTR_SERVER_ROUTING_CONFIG, (Object)config.routingConfig).build();
            pne = InternalProtocolNegotiationEvent.withAttributes((ProtocolNegotiationEvent)pne, (Attributes)attr);
            ctx.pipeline().replace((ChannelHandler)this, null, this.delegate.newHandler(this.grpcHandler));
            ctx.fireUserEventTriggered((Object)pne);
        }

        static final class FilterChainSelector {
            public static final FilterChainSelector NO_FILTER_CHAIN = new FilterChainSelector(Collections.emptyMap(), null, new AtomicReference<XdsServerWrapper.ServerRoutingConfig>());
            private final Map<EnvoyServerProtoData.FilterChain, AtomicReference<XdsServerWrapper.ServerRoutingConfig>> routingConfigs;
            @Nullable
            private final SslContextProviderSupplier defaultSslContextProviderSupplier;
            private final AtomicReference<XdsServerWrapper.ServerRoutingConfig> defaultRoutingConfig;

            FilterChainSelector(Map<EnvoyServerProtoData.FilterChain, AtomicReference<XdsServerWrapper.ServerRoutingConfig>> routingConfigs, @Nullable SslContextProviderSupplier defaultSslContextProviderSupplier, AtomicReference<XdsServerWrapper.ServerRoutingConfig> defaultRoutingConfig) {
                this.routingConfigs = (Map)Preconditions.checkNotNull(routingConfigs, (Object)"routingConfigs");
                this.defaultSslContextProviderSupplier = defaultSslContextProviderSupplier;
                this.defaultRoutingConfig = (AtomicReference)Preconditions.checkNotNull(defaultRoutingConfig, (Object)"defaultRoutingConfig");
            }

            @VisibleForTesting
            Map<EnvoyServerProtoData.FilterChain, AtomicReference<XdsServerWrapper.ServerRoutingConfig>> getRoutingConfigs() {
                return this.routingConfigs;
            }

            @VisibleForTesting
            AtomicReference<XdsServerWrapper.ServerRoutingConfig> getDefaultRoutingConfig() {
                return this.defaultRoutingConfig;
            }

            @VisibleForTesting
            SslContextProviderSupplier getDefaultSslContextProviderSupplier() {
                return this.defaultSslContextProviderSupplier;
            }

            SelectedConfig select(InetSocketAddress localAddr, InetSocketAddress remoteAddr) {
                Collection<EnvoyServerProtoData.FilterChain> filterChains = this.routingConfigs.keySet();
                filterChains = FilterChainSelector.filterOnDestinationPort(filterChains);
                filterChains = FilterChainSelector.filterOnIpAddress(filterChains, localAddr.getAddress(), true);
                filterChains = FilterChainSelector.filterOnServerNames(filterChains);
                filterChains = FilterChainSelector.filterOnTransportProtocol(filterChains);
                filterChains = FilterChainSelector.filterOnApplicationProtocols(filterChains);
                filterChains = FilterChainSelector.filterOnSourceType(filterChains, remoteAddr.getAddress(), localAddr.getAddress());
                filterChains = FilterChainSelector.filterOnIpAddress(filterChains, remoteAddr.getAddress(), false);
                if ((filterChains = FilterChainSelector.filterOnSourcePort(filterChains, remoteAddr.getPort())).size() > 1) {
                    throw new IllegalStateException("Found more than one matching filter chains. This should not be possible as ClientXdsClient validated the chains for uniqueness.");
                }
                if (filterChains.size() == 1) {
                    EnvoyServerProtoData.FilterChain selected = (EnvoyServerProtoData.FilterChain)Iterables.getOnlyElement(filterChains);
                    return new SelectedConfig(this.routingConfigs.get(selected), selected.sslContextProviderSupplier());
                }
                if (this.defaultRoutingConfig.get() != null) {
                    return new SelectedConfig(this.defaultRoutingConfig, this.defaultSslContextProviderSupplier);
                }
                return null;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnApplicationProtocols(Collection<EnvoyServerProtoData.FilterChain> filterChains) {
                ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    if (!filterChainMatch.applicationProtocols().isEmpty()) continue;
                    filtered.add(filterChain);
                }
                return filtered;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnTransportProtocol(Collection<EnvoyServerProtoData.FilterChain> filterChains) {
                ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    String transportProtocol = filterChainMatch.transportProtocol();
                    if (!Strings.isNullOrEmpty((String)transportProtocol) && !"raw_buffer".equals(transportProtocol)) continue;
                    filtered.add(filterChain);
                }
                return filtered;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnServerNames(Collection<EnvoyServerProtoData.FilterChain> filterChains) {
                ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    if (!filterChainMatch.serverNames().isEmpty()) continue;
                    filtered.add(filterChain);
                }
                return filtered;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnDestinationPort(Collection<EnvoyServerProtoData.FilterChain> filterChains) {
                ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    if (filterChainMatch.destinationPort() != UInt32Value.getDefaultInstance().getValue()) continue;
                    filtered.add(filterChain);
                }
                return filtered;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnSourcePort(Collection<EnvoyServerProtoData.FilterChain> filterChains, int sourcePort) {
                ArrayList<EnvoyServerProtoData.FilterChain> filteredOnMatch = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                ArrayList<EnvoyServerProtoData.FilterChain> filteredOnEmpty = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    ImmutableList<Integer> sourcePortsToMatch = filterChainMatch.sourcePorts();
                    if (sourcePortsToMatch.isEmpty()) {
                        filteredOnEmpty.add(filterChain);
                        continue;
                    }
                    if (!sourcePortsToMatch.contains(sourcePort)) continue;
                    filteredOnMatch.add(filterChain);
                }
                return filteredOnMatch.isEmpty() ? filteredOnEmpty : filteredOnMatch;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnSourceType(Collection<EnvoyServerProtoData.FilterChain> filterChains, InetAddress sourceAddress, InetAddress destAddress) {
                ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.filterChainMatch();
                    EnvoyServerProtoData.ConnectionSourceType sourceType = filterChainMatch.connectionSourceType();
                    boolean matching = false;
                    matching = sourceType == EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK ? sourceAddress.isLoopbackAddress() || sourceAddress.isAnyLocalAddress() || sourceAddress.equals(destAddress) : (sourceType == EnvoyServerProtoData.ConnectionSourceType.EXTERNAL ? !sourceAddress.isLoopbackAddress() && !sourceAddress.isAnyLocalAddress() : true);
                    if (!matching) continue;
                    filtered.add(filterChain);
                }
                return filtered;
            }

            private static int getMatchingPrefixLength(EnvoyServerProtoData.FilterChainMatch filterChainMatch, InetAddress address, boolean forDestination) {
                int matchingPrefixLength;
                ImmutableList<EnvoyServerProtoData.CidrRange> cidrRanges;
                boolean isIPv6 = address instanceof Inet6Address;
                ImmutableList<EnvoyServerProtoData.CidrRange> immutableList = cidrRanges = forDestination ? filterChainMatch.prefixRanges() : filterChainMatch.sourcePrefixRanges();
                if (cidrRanges.isEmpty()) {
                    matchingPrefixLength = 0;
                } else {
                    matchingPrefixLength = -1;
                    for (EnvoyServerProtoData.CidrRange cidrRange : cidrRanges) {
                        int prefixLen;
                        Matchers.CidrMatcher matcher;
                        InetAddress cidrAddr = cidrRange.addressPrefix();
                        boolean cidrIsIpv6 = cidrAddr instanceof Inet6Address;
                        if (isIPv6 != cidrIsIpv6 || !(matcher = Matchers.CidrMatcher.create(cidrAddr, prefixLen = cidrRange.prefixLen())).matches(address) || prefixLen <= matchingPrefixLength) continue;
                        matchingPrefixLength = prefixLen;
                    }
                }
                return matchingPrefixLength;
            }

            private static Collection<EnvoyServerProtoData.FilterChain> filterOnIpAddress(Collection<EnvoyServerProtoData.FilterChain> filterChains, InetAddress address, boolean forDestination) {
                ArrayList<EnvoyServerProtoData.FilterChain> topOnes = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
                int topMatchingPrefixLen = -1;
                for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                    int currentMatchingPrefixLen = FilterChainSelector.getMatchingPrefixLength(filterChain.filterChainMatch(), address, forDestination);
                    if (currentMatchingPrefixLen < 0 || currentMatchingPrefixLen < topMatchingPrefixLen) continue;
                    if (currentMatchingPrefixLen > topMatchingPrefixLen) {
                        topMatchingPrefixLen = currentMatchingPrefixLen;
                        topOnes.clear();
                    }
                    topOnes.add(filterChain);
                }
                return topOnes;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("routingConfigs", this.routingConfigs).add("defaultSslContextProviderSupplier", (Object)this.defaultSslContextProviderSupplier).add("defaultRoutingConfig", this.defaultRoutingConfig).toString();
            }
        }
    }
}

