/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class ClassicRequestBuilderTest {
    ClassicRequestBuilderTest() {
    }

    @Test
    void constructor() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = new ClassicRequestBuilder(Method.HEAD);
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder2 = new ClassicRequestBuilder(Method.HEAD.name());
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder2.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = new ClassicRequestBuilder(Method.HEAD.name(), URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)URIBuilder.localhost().getHost(), (Object)classicRequestBuilder3.getAuthority().getHostName());
        ClassicRequestBuilder classicRequestBuilder4 = new ClassicRequestBuilder(Method.HEAD, URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder4.getMethod());
        Assertions.assertEquals((Object)URIBuilder.localhost().getHost(), (Object)classicRequestBuilder4.getAuthority().getHostName());
        ClassicRequestBuilder classicRequestBuilder5 = new ClassicRequestBuilder(Method.HEAD, "/localhost");
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder5.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder5.getPath());
        ClassicRequestBuilder classicRequestBuilder6 = new ClassicRequestBuilder(Method.HEAD.name(), "/localhost");
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder6.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder6.getPath());
    }

    @Test
    void create() {
        ClassicHttpRequest classicHttpRequest = ClassicRequestBuilder.create((String)Method.HEAD.name()).build();
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicHttpRequest.getMethod());
    }

    @Test
    void get() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.get();
        Assertions.assertEquals((Object)Method.GET.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.get((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.GET.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.get((String)"/localhost");
        Assertions.assertEquals((Object)Method.GET.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void head() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.head();
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.head((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.head((String)"/localhost");
        Assertions.assertEquals((Object)Method.HEAD.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void patch() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.patch();
        Assertions.assertEquals((Object)Method.PATCH.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.patch((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.PATCH.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.patch((String)"/localhost");
        Assertions.assertEquals((Object)Method.PATCH.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void post() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.post();
        Assertions.assertEquals((Object)Method.POST.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.post((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.POST.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.post((String)"/localhost");
        Assertions.assertEquals((Object)Method.POST.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void put() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.put();
        Assertions.assertEquals((Object)Method.PUT.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.put((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.PUT.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.put((String)"/localhost");
        Assertions.assertEquals((Object)Method.PUT.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void delete() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.delete();
        Assertions.assertEquals((Object)Method.DELETE.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.delete((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.DELETE.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.delete((String)"/localhost");
        Assertions.assertEquals((Object)Method.DELETE.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void trace() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.trace();
        Assertions.assertEquals((Object)Method.TRACE.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.trace((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.TRACE.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.trace((String)"/localhost");
        Assertions.assertEquals((Object)Method.TRACE.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void option() throws UnknownHostException, URISyntaxException {
        ClassicRequestBuilder classicRequestBuilder = ClassicRequestBuilder.options();
        Assertions.assertEquals((Object)Method.OPTIONS.name(), (Object)classicRequestBuilder.getMethod());
        ClassicRequestBuilder classicRequestBuilder1 = ClassicRequestBuilder.options((URI)URIBuilder.localhost().build());
        Assertions.assertEquals((Object)Method.OPTIONS.name(), (Object)classicRequestBuilder1.getMethod());
        ClassicRequestBuilder classicRequestBuilder3 = ClassicRequestBuilder.options((String)"/localhost");
        Assertions.assertEquals((Object)Method.OPTIONS.name(), (Object)classicRequestBuilder3.getMethod());
        Assertions.assertEquals((Object)"/localhost", (Object)classicRequestBuilder3.getPath());
    }

    @Test
    void builder() {
        BasicHeader header = new BasicHeader("header2", (Object)"blah");
        ClassicHttpRequest classicHttpRequest = ClassicRequestBuilder.get().setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setCharset(StandardCharsets.US_ASCII).setAuthority(new URIAuthority("host")).setEntity("<html><body><h1>Access denied</h1></body></html>", ContentType.TEXT_HTML).setHeader((Header)new BasicHeader("header2", (Object)"blah")).setHeader("X-Test-Filter", "active").setHeader((Header)header).setPath("path/").setScheme("http").addHeader((Header)header).addHeader("header", ".addHeader(header)").addParameter((NameValuePair)new BasicHeader("header2", (Object)"blah")).addParameter("param1", "value1").addParameters(new NameValuePair[]{new BasicNameValuePair("param3", "value3"), new BasicNameValuePair("param4", null)}).setAbsoluteRequestUri(true).setEntity((HttpEntity)new StringEntity("requestBody")).setEntity((HttpEntity)new ByteArrayEntity(new byte[10240], ContentType.TEXT_PLAIN)).setEntity(new byte[10240], ContentType.TEXT_HTML).setEntity("requestBody").setUri("theUri").setHttpHost(new HttpHost("httpbin.org")).build();
        Assertions.assertAll((String)"Should return address of Oracle's headquarter", (Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)classicHttpRequest.getEntity()), () -> Assertions.assertEquals((Object)Method.GET.name(), (Object)classicHttpRequest.getMethod()), () -> Assertions.assertEquals((Object)"http", (Object)classicHttpRequest.getScheme()), () -> Assertions.assertEquals((Object)"httpbin.org", (Object)classicHttpRequest.getAuthority().getHostName()), () -> Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)classicHttpRequest.getVersion()), () -> Assertions.assertEquals((int)4, (int)classicHttpRequest.getHeaders().length), () -> Assertions.assertNotNull((Object)ClassicRequestBuilder.get().toString()), () -> Assertions.assertEquals((Object)"http://httpbin.org/theUri?header2=blah&param1=value1&param3=value3&param4", (Object)new String(classicHttpRequest.getRequestUri().getBytes()))});
    }

    @Test
    void builderTraceThrowsIllegalStateException() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClassicRequestBuilder.trace().setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setEntity((HttpEntity)new ByteArrayEntity(new byte[10240], ContentType.TEXT_PLAIN)).build());
    }
}

