/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheableRequestPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(CacheableRequestPolicy.class);

    CacheableRequestPolicy() {
    }

    public boolean canBeServedFromCache(RequestCacheControl cacheControl, HttpRequest request) {
        HttpVersion pv;
        String method = request.getMethod();
        Object object = pv = request.getVersion() != null ? request.getVersion() : HttpVersion.DEFAULT;
        if (HttpVersion.HTTP_1_1.compareToVersion((ProtocolVersion)pv) != 0) {
            LOG.debug("non-HTTP/1.1 request cannot be served from cache");
            return false;
        }
        if (!Method.GET.isSame(method) && !Method.HEAD.isSame(method)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request cannot be served from cache", (Object)method);
            }
            return false;
        }
        if (cacheControl.isNoStore()) {
            LOG.debug("Request with no-store cannot be served from cache");
            return false;
        }
        if (cacheControl.isNoCache()) {
            LOG.debug("Request with no-cache cannot be served from cache");
            return false;
        }
        LOG.debug("Request can be served from cache");
        return true;
    }
}

