/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscription;

public final class BlockingFlowableIterable<T>
implements Iterable<T> {
    final Flowable<T> source;
    final int bufferSize;

    public BlockingFlowableIterable(Flowable<T> source, int bufferSize) {
        this.source = source;
        this.bufferSize = bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        BlockingFlowableIterator it = new BlockingFlowableIterator(this.bufferSize);
        this.source.subscribe(it);
        return it;
    }

    static final class BlockingFlowableIterator<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Iterator<T>,
    Runnable,
    Disposable {
        private static final long serialVersionUID = 6695226475494099826L;
        final SpscArrayQueue<T> queue;
        final long batchSize;
        final long limit;
        final Lock lock;
        final Condition condition;
        long produced;
        volatile boolean done;
        volatile Throwable error;

        BlockingFlowableIterator(int batchSize) {
            this.queue = new SpscArrayQueue(batchSize);
            this.batchSize = batchSize;
            this.limit = batchSize - (batchSize >> 2);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        @Override
        public boolean hasNext() {
            block5: while (true) {
                if (this.isDisposed()) {
                    Throwable e = this.error;
                    if (e != null) {
                        throw ExceptionHelper.wrapOrThrow(e);
                    }
                    return false;
                }
                boolean d = this.done;
                boolean empty = this.queue.isEmpty();
                if (d) {
                    Throwable e = this.error;
                    if (e != null) {
                        throw ExceptionHelper.wrapOrThrow(e);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                BlockingHelper.verifyNonBlocking();
                this.lock.lock();
                try {
                    while (true) {
                        if (this.done || !this.queue.isEmpty() || this.isDisposed()) continue block5;
                        this.condition.await();
                    }
                }
                catch (InterruptedException ex) {
                    this.run();
                    throw ExceptionHelper.wrapOrThrow(ex);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T v = this.queue.poll();
                long p = this.produced + 1L;
                if (p == this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this, s, this.batchSize);
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.error = new QueueOverflowException();
                SubscriptionHelper.cancel(this);
                this.onComplete();
            } else {
                this.signalConsumer();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.signalConsumer();
        }

        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            SubscriptionHelper.cancel(this);
            this.signalConsumer();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
            this.signalConsumer();
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }
}

