/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.client;

import com.fasterxml.jackson.databind.module.SimpleModule;
import jakarta.ws.rs.core.Response;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.rest.AbstractRestClient;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.serializer.PathDeserializer;
import org.apache.hugegraph.structure.graph.Path;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.VersionUtil;

public class RestClient
extends AbstractRestClient {
    private static final int SECOND = 1000;
    private VersionUtil.Version apiVersion = null;

    public RestClient(String url, String username, String password, int timeout) {
        super(url, username, password, timeout * 1000);
    }

    public RestClient(String url, String username, String password, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        super(url, username, password, timeout * 1000, maxConns, maxConnsPerRoute, trustStoreFile, trustStorePassword);
    }

    public void apiVersion(VersionUtil.Version version) {
        E.checkNotNull(version, "api version");
        this.apiVersion = version;
    }

    public VersionUtil.Version apiVersion() {
        return this.apiVersion;
    }

    public void checkApiVersion(String minVersion, String message) {
        if (this.apiVersionLt(minVersion)) {
            throw new ClientException("HugeGraphServer API version must be >= %s to support %s, but current HugeGraphServer API version is: %s", minVersion, message, this.apiVersion.get());
        }
    }

    public boolean apiVersionLt(String minVersion) {
        String apiVersion = this.apiVersion == null ? null : this.apiVersion.get();
        return apiVersion != null && !VersionUtil.gte(apiVersion, minVersion);
    }

    @Override
    protected void checkStatus(Response response, Response.Status ... statuses) {
        boolean match = false;
        for (Response.Status status : statuses) {
            if (status.getStatusCode() != response.getStatus()) continue;
            match = true;
            break;
        }
        if (!match) {
            throw ServerException.fromResponse(response);
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Path.class, new PathDeserializer());
        RestResult.registerModule(module);
    }
}

