/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import java.nio.ByteBuffer;
import java.util.zip.CRC32C;
import org.caffinitas.ohc.chunked.Crc32Hash;
import org.caffinitas.ohc.chunked.Hasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Crc32cHash {
    private static final Logger LOGGER;
    static final boolean AVAILABLE;

    Crc32cHash() {
    }

    static Hasher newInstance() {
        if (AVAILABLE) {
            return new Crc32cHashImpl();
        }
        LOGGER.warn("CRC32C hash is only available with Java 11 or newer. Falling back to CRC32.");
        return new Crc32Hash();
    }

    static {
        boolean avail;
        LOGGER = LoggerFactory.getLogger(Hasher.class);
        try {
            Class.forName("java.util.zip.CRC32C").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            avail = true;
        }
        catch (Exception e) {
            avail = false;
        }
        AVAILABLE = avail;
    }

    static final class Crc32cHashImpl
    extends Hasher {
        Crc32cHashImpl() {
        }

        @Override
        long hash(ByteBuffer buffer) {
            CRC32C crc = new CRC32C();
            crc.update(buffer);
            return crc.getValue();
        }
    }
}

