/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.iterator.Metadatable;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.serializer.Serializer;
import org.apache.hugegraph.traversal.algorithm.CustomizedCrosspointsTraverser;
import org.apache.hugegraph.traversal.algorithm.FusiformSimilarityTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.SingleSourceShortestPathTraverser;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class JsonSerializer
implements Serializer {
    private static final int LBUF_SIZE = 1024;
    private static final String MEASURE_KEY = "measure";
    private static final JsonSerializer INSTANCE = new JsonSerializer();
    private Map<String, Object> apiMeasure = null;

    private JsonSerializer() {
    }

    private JsonSerializer(Map<String, Object> apiMeasure) {
        this.apiMeasure = apiMeasure;
    }

    public static JsonSerializer instance() {
        return INSTANCE;
    }

    public static JsonSerializer instance(Map<String, Object> apiMeasure) {
        return new JsonSerializer(apiMeasure);
    }

    @Override
    public String writeMap(Map<?, ?> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(map);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeList(String label, Collection<?> list) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            out.write(String.format("{\"%s\": ", label).getBytes("UTF-8"));
            out.write(JsonUtil.toJson(list).getBytes("UTF-8"));
            if (this.apiMeasure != null) {
                out.write(String.format(",\"%s\": ", MEASURE_KEY).getBytes("UTF-8"));
                out.write(JsonUtil.toJson(this.apiMeasure).getBytes("UTF-8"));
            }
            out.write("}".getBytes("UTF-8"));
            string = out.toString("UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HugeException("Failed to serialize %s", (Throwable)e, new Object[]{label});
            }
        }
        out.close();
        return string;
    }

    /*
     * Loose catch block
     */
    private String writeIterator(String label, Iterator<?> iter, boolean paging) {
        iter.hasNext();
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        out.write("{".getBytes("UTF-8"));
        out.write(String.format("\"%s\":[", label).getBytes("UTF-8"));
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                out.write(",".getBytes("UTF-8"));
            } else {
                first = false;
            }
            out.write(JsonUtil.toJson(iter.next()).getBytes("UTF-8"));
        }
        out.write("]".getBytes("UTF-8"));
        if (paging) {
            String page;
            if (iter instanceof GraphTraversal) {
                page = TraversalUtil.page((GraphTraversal)((GraphTraversal)iter));
            } else if (iter instanceof Metadatable) {
                page = PageInfo.pageInfo(iter);
            } else {
                throw new HugeException("Invalid paging iterator: %s", new Object[]{iter.getClass()});
            }
            page = page != null ? String.format(",\"page\": \"%s\"", page) : ",\"page\": null";
            out.write(page.getBytes("UTF-8"));
        }
        if (this.apiMeasure != null) {
            out.write(String.format(",\"%s\":[", MEASURE_KEY).getBytes("UTF-8"));
            out.write(JsonUtil.toJson(this.apiMeasure).getBytes("UTF-8"));
        }
        out.write("}".getBytes("UTF-8"));
        String string = out.toString("UTF-8");
        out.close();
        try {
            CloseableIterator.closeIterator(iter);
        }
        catch (Exception e) {
            throw new HugeException("Failed to close for %s", (Throwable)e, new Object[]{label});
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (HugeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new HugeException("Failed to serialize %s", (Throwable)e, new Object[]{label});
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        CloseableIterator.closeIterator(iter);
                    }
                    catch (Exception e) {
                        throw new HugeException("Failed to close for %s", (Throwable)e, new Object[]{label});
                    }
                    throw throwable3;
                }
            }
        }
    }

    @Override
    public String writePropertyKey(PropertyKey propertyKey) {
        return JsonUtil.toJson((Object)propertyKey);
    }

    @Override
    public String writeTaskWithSchema(SchemaElement.TaskWithSchema taskWithSchema) {
        String schema;
        String type;
        StringBuilder builder = new StringBuilder();
        long id = taskWithSchema.task() == null ? 0L : taskWithSchema.task().asLong();
        SchemaElement schemaElement = taskWithSchema.schemaElement();
        if (schemaElement instanceof PropertyKey) {
            type = "property_key";
            schema = this.writePropertyKey((PropertyKey)schemaElement);
        } else if (schemaElement instanceof IndexLabel) {
            type = "index_label";
            schema = this.writeIndexlabel((IndexLabel)schemaElement);
        } else {
            throw new HugeException("Invalid schema element '%s' in TaskWithSchema, only support [PropertyKey, IndexLabel]", new Object[]{schemaElement});
        }
        builder.append("{\"").append(type).append("\": ").append(schema).append(", \"task_id\": ").append(id);
        if (this.apiMeasure != null) {
            builder.append(String.format(",\"%s\":[", MEASURE_KEY));
            builder.append(JsonUtil.toJson(this.apiMeasure));
        }
        return builder.append("}").toString();
    }

    @Override
    public String writePropertyKeys(List<PropertyKey> propertyKeys) {
        return this.writeList("propertykeys", propertyKeys);
    }

    @Override
    public String writeVertexLabel(VertexLabel vertexLabel) {
        return JsonUtil.toJson((Object)vertexLabel);
    }

    @Override
    public String writeVertexLabels(List<VertexLabel> vertexLabels) {
        return this.writeList("vertexlabels", vertexLabels);
    }

    @Override
    public String writeEdgeLabel(EdgeLabel edgeLabel) {
        return JsonUtil.toJson((Object)edgeLabel);
    }

    @Override
    public String writeEdgeLabels(List<EdgeLabel> edgeLabels) {
        return this.writeList("edgelabels", edgeLabels);
    }

    @Override
    public String writeIndexlabel(IndexLabel indexLabel) {
        return JsonUtil.toJson((Object)indexLabel);
    }

    @Override
    public String writeIndexlabels(List<IndexLabel> indexLabels) {
        return this.writeList("indexlabels", indexLabels);
    }

    @Override
    public String writeVertex(Vertex vertex) {
        return JsonUtil.toJson((Object)vertex);
    }

    @Override
    public String writeVertices(Iterator<Vertex> vertices, boolean paging) {
        return this.writeIterator("vertices", vertices, paging);
    }

    @Override
    public String writeEdge(Edge edge) {
        return JsonUtil.toJson((Object)edge);
    }

    @Override
    public String writeEdges(Iterator<Edge> edges, boolean paging) {
        return this.writeIterator("edges", edges, paging);
    }

    @Override
    public String writeIds(List<Id> ids) {
        return JsonUtil.toJson(ids);
    }

    @Override
    public String writeAuthElement(SchemaDefine.AuthElement elem) {
        return this.writeMap(elem.asMap());
    }

    @Override
    public <V extends SchemaDefine.AuthElement> String writeAuthElements(String label, List<V> elems) {
        ArrayList<Map> list = new ArrayList<Map>(elems.size());
        for (SchemaDefine.AuthElement elem : elems) {
            list.add(elem.asMap());
        }
        return this.writeList(label, list);
    }

    @Override
    public String writePaths(String name, Collection<HugeTraverser.Path> paths, boolean withCrossPoint, Iterator<?> vertices, Iterator<?> edges) {
        ArrayList<Map> pathList = new ArrayList<Map>(paths.size());
        for (HugeTraverser.Path path : paths) {
            pathList.add(path.toMap(withCrossPoint));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)name, pathList);
        if (vertices != null) {
            builder.put((Object)"vertices", vertices);
        }
        if (edges != null) {
            builder.put((Object)"edges", edges);
        }
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeCrosspoints(CustomizedCrosspointsTraverser.CrosspointsPaths paths, Iterator<?> vertices, Iterator<?> edges, boolean withPath) {
        Object pathList;
        if (withPath) {
            pathList = new ArrayList();
            for (HugeTraverser.Path path : paths.paths()) {
                pathList.add(path.toMap(false));
            }
        } else {
            pathList = ImmutableList.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"crosspoints", (Object)paths.crosspoints()).put((Object)"paths", pathList).put((Object)"vertices", vertices).put((Object)"edges", edges);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeSimilars(FusiformSimilarityTraverser.SimilarsMap similars, Iterator<?> vertices) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"similars", (Object)similars.toMap()).put((Object)"vertices", vertices);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeWeightedPath(SingleSourceShortestPathTraverser.NodeWithWeight path, Iterator<?> vertices, Iterator<?> edges) {
        Object pathMap = path == null ? ImmutableMap.of() : path.toMap();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"path", pathMap).put((Object)"vertices", vertices).put((Object)"edges", edges);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeWeightedPaths(SingleSourceShortestPathTraverser.WeightedPaths paths, Iterator<?> vertices, Iterator<?> edges) {
        Object pathMap = paths == null ? ImmutableMap.of() : paths.toMap();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"paths", pathMap).put((Object)"vertices", vertices).put((Object)"edges", edges);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }

    @Override
    public String writeNodesWithPath(String name, List<Id> nodes, long size, Collection<HugeTraverser.Path> paths, Iterator<?> vertices, Iterator<?> edges) {
        ArrayList<Map> pathList = new ArrayList<Map>();
        for (HugeTraverser.Path path : paths) {
            pathList.add(path.toMap(false));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)name, nodes).put((Object)"size", (Object)size).put((Object)"paths", pathList).put((Object)"vertices", vertices).put((Object)"edges", edges);
        if (this.apiMeasure != null) {
            builder.put((Object)MEASURE_KEY, this.apiMeasure);
        }
        return JsonUtil.toJson((Object)builder.build());
    }
}

