/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class HugeProject
extends SchemaDefine.Entity {
    private static final long serialVersionUID = 8681323499069874520L;
    private String name;
    private Id adminGroupId;
    private Id opGroupId;
    private Set<String> graphs;
    private Id targetId;
    private String description;

    public HugeProject(Id id) {
        this(id, null, null, null, null, null, null);
    }

    public HugeProject(String name) {
        this(name, null);
    }

    public HugeProject(String name, String description) {
        this(null, name, description, null, null, null, null);
    }

    public HugeProject(Id id, String name, String description, Id adminGroupId, Id opGroupId, Set<String> graphs, Id targetId) {
        this.name = name;
        this.description = description;
        this.adminGroupId = adminGroupId;
        this.opGroupId = opGroupId;
        this.graphs = graphs;
        this.id = id;
        this.targetId = targetId;
    }

    @Override
    public ResourceType type() {
        return ResourceType.PROJECT;
    }

    @Override
    public String label() {
        return P.PROJECT;
    }

    public Id adminGroupId() {
        return this.adminGroupId;
    }

    public void adminGroupId(Id id) {
        this.adminGroupId = id;
    }

    public Id opGroupId() {
        return this.opGroupId;
    }

    public void opGroupId(Id id) {
        this.opGroupId = id;
    }

    public Set<String> graphs() {
        return this.graphs == null ? Collections.emptySet() : Collections.unmodifiableSet(this.graphs);
    }

    public void graphs(Set<String> graphs) {
        this.graphs = graphs;
    }

    public Id targetId() {
        return this.targetId;
    }

    public void targetId(Id targetId) {
        this.targetId = targetId;
    }

    public String description() {
        return this.description;
    }

    public void description(String desc) {
        this.description = desc;
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((!StringUtils.isEmpty((String)this.name) ? 1 : 0) != 0, (String)"The name of project can't be null", (Object[])new Object[0]);
        E.checkState((this.adminGroupId != null ? 1 : 0) != 0, (String)"The admin group id of project '%s' can't be null", (Object[])new Object[]{this.name});
        E.checkState((this.opGroupId != null ? 1 : 0) != 0, (String)"The op group id of project '%s' can't be null", (Object[])new Object[]{this.name});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~project_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~project_admin_group"), this.adminGroupId.toString());
        map.put(Graph.Hidden.unHide((String)"~project_op_group"), this.opGroupId.toString());
        if (this.graphs != null && !this.graphs.isEmpty()) {
            map.put(Graph.Hidden.unHide((String)"~project_graphs"), this.graphs);
        }
        if (!StringUtils.isEmpty((String)this.description)) {
            map.put(Graph.Hidden.unHide((String)"~project_description"), this.description);
        }
        if (this.targetId != null) {
            map.put(Graph.Hidden.unHide((String)"~project_target"), this.targetId.toString());
        }
        return super.asMap(map);
    }

    @Override
    protected Object[] asArray() {
        E.checkState((!StringUtils.isEmpty((String)this.name) ? 1 : 0) != 0, (String)"The name of project can't be null", (Object[])new Object[0]);
        E.checkState((this.adminGroupId != null ? 1 : 0) != 0, (String)"The admin group id of project '%s' can't be null", (Object[])new Object[]{this.name});
        E.checkState((this.opGroupId != null ? 1 : 0) != 0, (String)"The op group id of project '%s' can't be null", (Object[])new Object[]{this.name});
        ArrayList<Object> list = new ArrayList<Object>(16);
        list.add(T.label);
        list.add(P.PROJECT);
        list.add("~project_name");
        list.add(this.name);
        if (!StringUtils.isEmpty((String)this.description)) {
            list.add("~project_description");
            list.add(this.description);
        }
        if (this.graphs != null && !this.graphs.isEmpty()) {
            list.add("~project_graphs");
            list.add(this.graphs);
        }
        list.add("~project_admin_group");
        list.add(this.adminGroupId.toString());
        list.add("~project_op_group");
        list.add(this.opGroupId.toString());
        if (this.targetId != null) {
            list.add("~project_target");
            list.add(this.targetId.toString());
        }
        return super.asArray(list);
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~project_name": {
                this.name = (String)value;
                break;
            }
            case "~project_graphs": {
                this.graphs = (Set)value;
                break;
            }
            case "~project_description": {
                this.description = (String)value;
                break;
            }
            case "~project_admin_group": {
                this.adminGroupId = IdGenerator.of(value);
                break;
            }
            case "~project_op_group": {
                this.opGroupId = IdGenerator.of(value);
                break;
            }
            case "~project_target": {
                this.targetId = IdGenerator.of(value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    public static HugeProject fromVertex(Vertex vertex) {
        HugeProject target = new HugeProject((Id)vertex.id());
        return HugeProject.fromVertex(vertex, target);
    }

    @Override
    public String name() {
        return this.name;
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.PROJECT);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)this.schema().vertexLabel(this.label).enableLabelIndex(true).usePrimaryKeyId().primaryKeys("~project_name").nullableKeys("~project_description", "~project_graphs", "~project_target").properties(properties).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~project_admin_group", DataType.TEXT));
            props.add(this.createPropertyKey("~project_op_group", DataType.TEXT));
            props.add(this.createPropertyKey("~project_graphs", DataType.TEXT, Cardinality.SET));
            props.add(this.createPropertyKey("~project_name", DataType.TEXT));
            props.add(this.createPropertyKey("~project_description", DataType.TEXT));
            props.add(this.createPropertyKey("~project_target", DataType.TEXT));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String PROJECT = Graph.Hidden.hide((String)"project");
        public static final String LABEL = T.label.getAccessor();
        public static final String ADMIN_GROUP = "~project_admin_group";
        public static final String OP_GROUP = "~project_op_group";
        public static final String GRAPHS = "~project_graphs";
        public static final String NAME = "~project_name";
        public static final String DESCRIPTIONS = "~project_description";
        public static final String TARGET = "~project_target";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"project_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

