/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeResource;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class RolePermission {
    public static final RolePermission NONE = RolePermission.role("none", HugePermission.NONE);
    public static final RolePermission ADMIN = RolePermission.role("admin", HugePermission.ANY);
    @JsonProperty(value="roles")
    private final Map<String, Map<HugePermission, List<HugeResource>>> roles;

    public RolePermission() {
        this(new TreeMap<String, Map<HugePermission, List<HugeResource>>>());
    }

    private RolePermission(Map<String, Map<HugePermission, List<HugeResource>>> roles) {
        this.roles = roles;
    }

    protected void add(String graph, String action, List<HugeResource> resources) {
        this.add(graph, HugePermission.valueOf(action), resources);
    }

    protected void add(String graph, HugePermission action, List<HugeResource> resources) {
        List<HugeResource> mergedResources;
        Map<HugePermission, List<HugeResource>> permissions = this.roles.get(graph);
        if (permissions == null) {
            permissions = new TreeMap<HugePermission, List<HugeResource>>();
            this.roles.put(graph, permissions);
        }
        if ((mergedResources = permissions.get(action)) == null) {
            mergedResources = new ArrayList<HugeResource>();
            permissions.put(action, mergedResources);
        }
        mergedResources.addAll(resources);
    }

    public Map<String, Map<HugePermission, List<HugeResource>>> map() {
        return Collections.unmodifiableMap(this.roles);
    }

    public boolean contains(RolePermission other) {
        for (Map.Entry<String, Map<HugePermission, List<HugeResource>>> e1 : other.roles.entrySet()) {
            String g = e1.getKey();
            Map<HugePermission, List<HugeResource>> perms = this.roles.get(g);
            if (perms == null) {
                return false;
            }
            for (Map.Entry<HugePermission, List<HugeResource>> e2 : e1.getValue().entrySet()) {
                List<HugeResource> ress = perms.get(e2.getKey());
                if (ress == null) {
                    return false;
                }
                for (HugeResource r : e2.getValue()) {
                    boolean contains = false;
                    for (HugeResource res : ress) {
                        if (!res.contains(r)) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RolePermission)) {
            return false;
        }
        RolePermission other = (RolePermission)object;
        return Objects.equals(this.roles, other.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    public String toString() {
        return this.roles.toString();
    }

    public String toJson() {
        return JsonUtil.toJson(this);
    }

    public static RolePermission fromJson(Object json) {
        RolePermission role;
        if (json instanceof String) {
            role = JsonUtil.fromJson((String)json, RolePermission.class);
        } else {
            E.checkArgument((boolean)(json instanceof RolePermission), (String)"Invalid role value: %s", (Object[])new Object[]{json});
            role = (RolePermission)json;
        }
        return role;
    }

    public static RolePermission all(String graph) {
        return RolePermission.role(graph, HugePermission.ANY);
    }

    public static RolePermission role(String graph, HugePermission perm) {
        RolePermission role = new RolePermission();
        role.add(graph, perm, HugeResource.ALL_RES);
        return role;
    }

    public static RolePermission none() {
        return NONE;
    }

    public static RolePermission admin() {
        return ADMIN;
    }

    public static RolePermission builtin(RolePermission role) {
        E.checkNotNull((Object)role, (String)"role");
        if (role == ADMIN || role.equals(ADMIN)) {
            return ADMIN;
        }
        if (role == NONE || role.equals(NONE)) {
            return NONE;
        }
        return role;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RolePermission.class, (JsonSerializer)new RolePermissionSer());
        module.addDeserializer(RolePermission.class, (JsonDeserializer)new RolePermissionDeser());
        JsonUtil.registerModule((Module)module);
    }

    private static class RolePermissionDeser
    extends StdDeserializer<RolePermission> {
        private static final long serialVersionUID = -2038234657843260957L;

        public RolePermissionDeser() {
            super(RolePermission.class);
        }

        public RolePermission deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            TypeReference<TreeMap<String, TreeMap<HugePermission, List<HugeResource>>>> type = new TypeReference<TreeMap<String, TreeMap<HugePermission, List<HugeResource>>>>(){};
            if ("roles".equals(parser.nextFieldName())) {
                parser.nextValue();
                return new RolePermission((Map)parser.readValueAs((TypeReference)type));
            }
            throw JsonMappingException.from((JsonParser)parser, (String)"Expect field roles");
        }
    }

    private static class RolePermissionSer
    extends StdSerializer<RolePermission> {
        private static final long serialVersionUID = -2533310506459479383L;

        public RolePermissionSer() {
            super(RolePermission.class);
        }

        public void serialize(RolePermission role, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeObjectField("roles", role.roles);
            generator.writeEndObject();
        }
    }
}

