/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.collection.CollectionFactory;

public class SystemSchemaStore {
    private static final int SYSTEM_SCHEMA_MAX_NUMS = 128;
    private SchemaElement[] storeByIds = new SchemaElement[128];
    private final Map<String, SchemaElement> storeByNames = CollectionFactory.newMap(CollectionType.EC, 128);

    public void add(SchemaElement schema) {
        long idValue = schema.id().asLong();
        assert (idValue < 0L);
        int index = (int)Math.abs(idValue);
        if (index >= this.storeByIds.length) {
            this.expandCapacity();
        }
        this.storeByIds[index] = schema;
        this.storeByNames.put(schema.name(), schema);
    }

    public <T extends SchemaElement> T get(Id id) {
        long idValue = id.asLong();
        assert (idValue < 0L);
        int index = (int)Math.abs(idValue);
        return (T)this.storeByIds[index];
    }

    public <T extends SchemaElement> T get(String name) {
        return (T)this.storeByNames.get(name);
    }

    private void expandCapacity() {
        int newLength = this.storeByIds.length << 1;
        SchemaElement[] newStoreByIds = new SchemaElement[newLength];
        System.arraycopy(this.storeByIds, 0, newStoreByIds, 0, this.storeByIds.length);
        this.storeByIds = newStoreByIds;
    }
}

