/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.HgNodePartition;

@ThreadSafe
class NodeTkv {
    private final HgNodePartition nodePartition;
    private final String table;
    private final HgOwnerKey key;
    private final HgOwnerKey endKey;
    private HgStoreSession session;

    NodeTkv(HgNodePartition nodePartition, String table, HgOwnerKey key) {
        this.nodePartition = nodePartition;
        this.table = table;
        this.key = key;
        this.endKey = key;
        this.key.setKeyCode(this.nodePartition.getKeyCode());
    }

    NodeTkv(HgNodePartition nodePartition, String table, HgOwnerKey key, int keyCode) {
        this.nodePartition = nodePartition;
        this.table = table;
        this.key = key;
        this.endKey = key;
        this.key.setKeyCode(keyCode);
    }

    NodeTkv(HgNodePartition nodePartition, String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        this.nodePartition = nodePartition;
        this.table = table;
        this.key = startKey;
        this.endKey = endKey;
        this.key.setKeyCode(nodePartition.getStartKey());
        this.endKey.setKeyCode(nodePartition.getEndKey());
    }

    public Long getNodeId() {
        return this.nodePartition.getNodeId();
    }

    public String getTable() {
        return this.table;
    }

    public HgOwnerKey getKey() {
        return this.key;
    }

    public HgOwnerKey getEndKey() {
        return this.endKey;
    }

    public NodeTkv setKeyCode(int code) {
        this.key.setKeyCode(code);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeTkv nptKv = (NodeTkv)o;
        return Objects.equals(this.nodePartition, nptKv.nodePartition) && Objects.equals(this.table, nptKv.table) && Objects.equals(this.key, nptKv.key) && Objects.equals(this.endKey, nptKv.endKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.nodePartition, this.table, this.key, this.endKey);
        return result;
    }

    public String toString() {
        return "NptKv{nodePartition=" + this.nodePartition + ", table='" + this.table + "', key=" + this.key + ", endKey=" + this.endKey + "}";
    }

    public HgStoreSession getSession() {
        return this.session;
    }

    public void setSession(HgStoreSession session) {
        this.session = session;
    }
}

