/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.NodeTkv;
import org.apache.hugegraph.store.client.NodeTxSessionProxy;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.term.HgPair;
import org.apache.hugegraph.store.term.HgTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class NodeTxExecutor {
    private static final Logger log = LoggerFactory.getLogger(NodeTxExecutor.class);
    private static final String maxTryMsg = "the number of retries reached the upper limit : 10,caused by:";
    private static final String msg = "Not all tx-data delivered to real-node-session successfully.";
    private final String graphName;
    NodeTxSessionProxy proxy;
    Collector<NodeTkv, ?, Map<Long, List<HgOwnerKey>>> collector = Collectors.groupingBy(nkv -> nkv.getNodeId(), Collectors.mapping(NodeTkv::getKey, Collectors.toList()));
    private Map<Long, HgStoreSession> sessions = new HashMap<Long, HgStoreSession>(32, 1.0f);
    private boolean isTx;
    private List<HgPair<HgTriple<String, HgOwnerKey, Object>, Function<NodeTkv, Boolean>>> entries = new LinkedList<HgPair<HgTriple<String, HgOwnerKey, Object>, Function<NodeTkv, Boolean>>>();

    private NodeTxExecutor(String graphName, NodeTxSessionProxy proxy) {
        this.graphName = graphName;
        this.proxy = proxy;
    }

    static NodeTxExecutor graphOf(String graphName, NodeTxSessionProxy proxy) {
        return new NodeTxExecutor(graphName, proxy);
    }

    public boolean isTx() {
        return this.isTx;
    }

    void setTx(boolean tx) {
        this.isTx = tx;
    }

    void commitTx() {
        if (!this.isTx) {
            throw new IllegalStateException("It's not in tx state");
        }
        this.doCommit();
    }

    void rollbackTx() {
        if (!this.isTx) {
            return;
        }
        try {
            this.sessions.values().stream().filter(HgStoreSession::isTx).forEach(HgStoreSession::rollback);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.isTx = false;
            this.sessions.clear();
        }
    }

    void doCommit() {
        try {
            this.retryingInvoke(() -> {
                if (this.entries.isEmpty()) {
                    return true;
                }
                AtomicBoolean allSuccess = new AtomicBoolean(true);
                for (HgPair<HgTriple<String, HgOwnerKey, Object>, Function<NodeTkv, Boolean>> e2 : this.entries) {
                    this.doAction((HgTriple<String, HgOwnerKey, Object>)((HgTriple)e2.getKey()), (Function)e2.getValue());
                }
                if (!allSuccess.get()) {
                    throw HgStoreClientException.of(msg);
                }
                AtomicReference throwable = new AtomicReference();
                Collection<HgStoreSession> sessions = this.sessions.values();
                sessions.parallelStream().forEach(e -> {
                    if (e.isTx()) {
                        try {
                            e.commit();
                        }
                        catch (Throwable t) {
                            throwable.compareAndSet(null, t);
                            allSuccess.set(false);
                        }
                    }
                });
                if (!allSuccess.get()) {
                    Throwable cause;
                    if (this.isTx) {
                        try {
                            sessions.stream().forEach(HgStoreSession::rollback);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((cause = (Throwable)throwable.get()).getCause() != null) {
                        cause = cause.getCause();
                    }
                    if (cause instanceof HgStoreClientException) {
                        throw (HgStoreClientException)cause;
                    }
                    throw HgStoreClientException.of(cause);
                }
                return true;
            });
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.isTx = false;
            this.entries = new LinkedList<HgPair<HgTriple<String, HgOwnerKey, Object>, Function<NodeTkv, Boolean>>>();
            this.sessions = new HashMap<Long, HgStoreSession>(32, 1.0f);
        }
    }

    private boolean doAction(HgTriple<String, HgOwnerKey, Object> nodeParams, Function<NodeTkv, Boolean> action) {
        if (nodeParams.getZ() == null) {
            return this.proxy.doAction((String)nodeParams.getX(), (HgOwnerKey)nodeParams.getY(), (HgOwnerKey)nodeParams.getY(), action);
        }
        if (nodeParams.getZ() instanceof HgOwnerKey) {
            boolean result = this.proxy.doAction((String)nodeParams.getX(), (HgOwnerKey)nodeParams.getY(), (HgOwnerKey)nodeParams.getZ(), action);
            return result;
        }
        if (nodeParams.getZ() instanceof Integer) {
            return this.proxy.doAction((String)nodeParams.getX(), (HgOwnerKey)nodeParams.getY(), (Integer)nodeParams.getZ(), action);
        }
        HgAssert.isTrue(nodeParams.getZ() instanceof byte[], "Illegal parameter to get node id");
        throw new RuntimeException("not implemented");
    }

    boolean prepareTx(HgTriple<String, HgOwnerKey, Object> nodeParams, Function<NodeTkv, Boolean> sessionMapper) {
        if (this.isTx) {
            return this.entries.add((HgPair<HgTriple<String, HgOwnerKey, Object>, Function<NodeTkv, Boolean>>)new HgPair(nodeParams, sessionMapper));
        }
        return this.isAllTrue(nodeParams, sessionMapper);
    }

    public HgStoreSession openNodeSession(HgStoreNode node) {
        HgStoreSession res = this.sessions.get(node.getNodeId());
        if (res == null) {
            res = node.openSession(this.graphName);
            this.sessions.put(node.getNodeId(), res);
        }
        if (this.isTx) {
            res.beginTx();
        }
        return res;
    }

    <R> R limitOne(Supplier<Stream<HgPair<HgStoreNode, NodeTkv>>> nodeStreamSupplier, Function<SessionData<NodeTkv>, R> sessionMapper, R emptyObj) {
        Optional<Object> res = this.retryingInvoke(() -> ((Stream)((Stream)nodeStreamSupplier.get()).parallel()).map(pair -> new SessionData<NodeTkv>(this.openNodeSession((HgStoreNode)pair.getKey()), (NodeTkv)pair.getValue())).map(sessionMapper).filter(r -> this.isValid(r)).findAny().orElseGet(() -> emptyObj));
        return (R)res.orElse(emptyObj);
    }

    <R> List<R> toList(Function<Long, HgStoreNode> nodeFunction, List<HgOwnerKey> keyList, Function<HgOwnerKey, Stream<NodeTkv>> flatMapper, Function<SessionData<List<HgOwnerKey>>, List<R>> sessionMapper) {
        Optional<List> res = this.retryingInvoke(() -> ((Stream)keyList.stream().flatMap(flatMapper).collect(this.collector).entrySet().stream().map(e -> new SessionData<List>(this.openNodeSession((HgStoreNode)nodeFunction.apply((Long)e.getKey())), (List)e.getValue())).parallel()).map(sessionMapper).flatMap(e -> e.stream()).collect(Collectors.toList()));
        return res.orElse(HgStoreClientConst.EMPTY_LIST);
    }

    private boolean isAllTrue(HgTriple<String, HgOwnerKey, Object> nodeParams, Function<NodeTkv, Boolean> action) {
        Optional<Boolean> res = this.retryingInvoke(() -> this.doAction(nodeParams, action));
        return res.orElse(false);
    }

    boolean isAllTrue(Supplier<Stream<HgPair<HgStoreNode, NodeTkv>>> dataSource, Function<SessionData<NodeTkv>, Boolean> action) {
        Optional<Boolean> res = this.retryingInvoke(() -> ((Stream)((Stream)dataSource.get()).parallel()).map(pair -> new SessionData<NodeTkv>(this.openNodeSession((HgStoreNode)pair.getKey()), (NodeTkv)pair.getValue())).map(action).allMatch(Boolean::booleanValue));
        return res.orElse(false);
    }

    boolean ifAnyTrue(Supplier<Stream<HgPair<HgStoreNode, NodeTkv>>> nodeStreamSupplier, Function<SessionData<NodeTkv>, Boolean> sessionMapper) {
        Optional<Boolean> res = this.retryingInvoke(() -> ((Stream)((Stream)nodeStreamSupplier.get()).parallel()).map(pair -> new SessionData<NodeTkv>(this.openNodeSession((HgStoreNode)pair.getKey()), (NodeTkv)pair.getValue())).map(sessionMapper).anyMatch(Boolean::booleanValue));
        return res.orElse(false);
    }

    <T> Optional<T> retryingInvoke(Supplier<T> supplier) {
        return IntStream.rangeClosed(0, 10).boxed().map(i -> {
            Object buffer = null;
            try {
                buffer = supplier.get();
            }
            catch (Throwable t) {
                if (i + 1 <= 10) {
                    try {
                        int sleepTime = i < 3 ? 1 : i - 1;
                        log.info("Waiting {} seconds for the next try.", (Object)sleepTime);
                        Thread.sleep((long)sleepTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        log.error("Failed to sleep", (Throwable)e);
                    }
                }
                log.error(maxTryMsg, t);
                throw HgStoreClientException.of(t.getMessage(), t);
            }
            return buffer;
        }).filter(e -> e != null).findFirst();
    }

    private boolean isValid(Object obj) {
        if (obj == null) {
            return false;
        }
        if (HgStoreClientConst.EMPTY_BYTES.equals(obj)) {
            return false;
        }
        return !HgStoreClientConst.EMPTY_LIST.equals(obj);
    }

    static {
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(Runtime.getRuntime().availableProcessors() * 2));
    }

    class SessionData<T> {
        HgStoreSession session;
        T data;

        SessionData(HgStoreSession session, T data) {
            this.session = session;
            this.data = data;
        }
    }
}

