/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractBlockingStub;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.store.client.grpc.AbstractGrpcClient;
import org.apache.hugegraph.store.grpc.state.HgStoreStateGrpc;
import org.apache.hugegraph.store.grpc.state.ScanState;
import org.apache.hugegraph.store.grpc.state.SubStateReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GrpcStoreStateClient
extends AbstractGrpcClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcStoreStateClient.class);
    private final PDConfig pdConfig;
    private final PDClient pdClient;

    public GrpcStoreStateClient(PDConfig pdConfig) {
        this.pdConfig = pdConfig;
        this.pdClient = PDClient.create((PDConfig)this.pdConfig);
    }

    public Set<ScanState> getScanState() throws Exception {
        List activeStores = this.pdClient.getActiveStores();
        Set<ScanState> states = activeStores.parallelStream().map(node -> {
            String address = node.getAddress();
            HgStoreStateGrpc.HgStoreStateBlockingStub stub = (HgStoreStateGrpc.HgStoreStateBlockingStub)this.getBlockingStub(address);
            SubStateReq req = SubStateReq.newBuilder().build();
            return stub.getScanState(req);
        }).collect(Collectors.toSet());
        return states;
    }

    @Override
    public AbstractBlockingStub getBlockingStub(ManagedChannel channel) {
        HgStoreStateGrpc.HgStoreStateBlockingStub stub = HgStoreStateGrpc.newBlockingStub((Channel)channel);
        return stub;
    }
}

