/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.hugegraph.store.node.metrics.ProcFileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProcfsRecord {
    private static final Logger logger = LoggerFactory.getLogger(ProcfsRecord.class);
    private final Object syncLock = new Object();
    private final ProcFileHandler fileReader;
    private long lastProcessedTime = -1L;

    protected ProcfsRecord(ProcFileHandler fileReader) {
        this.fileReader = Objects.requireNonNull(fileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void gatherData() {
        Object object = this.syncLock;
        synchronized (object) {
            try {
                ProcFileHandler.ReadResult readResult = this.fileReader.readFile();
                if (readResult != null && (this.lastProcessedTime == -1L || this.lastProcessedTime != readResult.getReadTime())) {
                    this.clear();
                    this.process((Collection)readResult.getLines());
                    this.lastProcessedTime = readResult.getReadTime();
                }
            }
            catch (IOException e) {
                this.clear();
                logger.warn("Failed reading '" + this.fileReader.getFilePath() + "'!", (Throwable)e);
            }
        }
    }

    protected abstract void clear();

    protected abstract void process(Collection<String> var1);
}

