/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MatchableInvocation;

public class SmartPrinter {
    private final String wanted;
    private final List<String> actuals;

    public SmartPrinter(MatchableInvocation wanted, Invocation actual, Integer ... indexesOfMatchersToBeDescribedWithExtraTypeInfo) {
        this(wanted, Collections.singletonList(actual), indexesOfMatchersToBeDescribedWithExtraTypeInfo);
    }

    public SmartPrinter(MatchableInvocation wanted, List<Invocation> allActualInvocations, Integer ... indexesOfMatchersToBeDescribedWithExtraTypeInfo) {
        PrintSettings printSettings = new PrintSettings();
        printSettings.setMultiline(SmartPrinter.isMultiLine(wanted, allActualInvocations));
        printSettings.setMatchersToBeDescribedWithExtraTypeInfo(indexesOfMatchersToBeDescribedWithExtraTypeInfo);
        this.wanted = printSettings.print(wanted);
        ArrayList<String> actuals = new ArrayList<String>();
        for (Invocation actual : allActualInvocations) {
            actuals.add(printSettings.print(actual));
        }
        this.actuals = Collections.unmodifiableList(actuals);
    }

    public String getWanted() {
        return this.wanted;
    }

    public List<String> getActuals() {
        return this.actuals;
    }

    private static boolean isMultiLine(MatchableInvocation wanted, List<Invocation> allActualInvocations) {
        boolean isWantedMultiline = wanted.toString().contains("\n");
        boolean isAnyActualMultiline = false;
        for (Invocation invocation : allActualInvocations) {
            isAnyActualMultiline |= invocation.toString().contains("\n");
        }
        return isWantedMultiline || isAnyActualMultiline;
    }
}

