/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryAbstractIdentityResolver;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryArrayIdentityResolver
extends BinaryAbstractIdentityResolver {
    private static final BinaryArrayIdentityResolver INSTANCE = new BinaryArrayIdentityResolver();

    public static BinaryArrayIdentityResolver instance() {
        return INSTANCE;
    }

    @Override
    protected int hashCode0(BinaryObject obj) {
        if (obj instanceof BinaryObjectExImpl) {
            BinaryObjectExImpl ex = (BinaryObjectExImpl)obj;
            int start = ex.dataStartOffset();
            int end = ex.footerStartOffset();
            if (ex.hasArray()) {
                return this.hashCode(ex.array(), start, end);
            }
            int hash = 1;
            long ptr = ex.offheapAddress();
            for (int i = start; i < end; ++i) {
                hash = 31 * hash + BinaryPrimitives.readByte(ptr, i);
            }
            return hash;
        }
        if (obj instanceof BinaryEnumObjectImpl) {
            int hash = 1;
            int ord = obj.enumOrdinal();
            hash = 31 * hash + (ord & 0xFF);
            hash = 31 * hash + (ord & 0xFF00);
            hash = 31 * hash + (ord & 0xFF0000);
            hash = 31 * hash + (ord & 0xFF000000);
            return hash;
        }
        throw new BinaryObjectException("Array identity resolver cannot be used with provided BinaryObject implementation: " + obj.getClass().getName());
    }

    public int hashCode(byte[] data, int startPos, int endPos) {
        int hash = 1;
        for (int i = startPos; i < endPos; ++i) {
            hash = 31 * hash + data[i];
        }
        return hash;
    }

    @Override
    protected boolean equals0(BinaryObject o1, BinaryObject o2) {
        if (o1 instanceof BinaryObjectEx && o2 instanceof BinaryObjectEx) {
            BinaryObjectEx ex1 = (BinaryObjectEx)o1;
            BinaryObjectEx ex2 = (BinaryObjectEx)o2;
            if (ex1.typeId() != ex2.typeId()) {
                return false;
            }
            if (ex1 instanceof BinaryObjectExImpl) {
                assert (ex2 instanceof BinaryObjectExImpl);
                BinaryObjectExImpl exx1 = (BinaryObjectExImpl)ex1;
                BinaryObjectExImpl exx2 = (BinaryObjectExImpl)ex2;
                if (exx1.hasArray()) {
                    return exx2.hasArray() ? BinaryArrayIdentityResolver.equalsHeap(exx1, exx2) : BinaryArrayIdentityResolver.equalsHeapOffheap(exx1, exx2);
                }
                return exx2.hasArray() ? BinaryArrayIdentityResolver.equalsHeapOffheap(exx2, exx1) : BinaryArrayIdentityResolver.equalsOffheap(exx1, exx2);
            }
            assert (ex1 instanceof BinaryEnumObjectImpl);
            assert (ex2 instanceof BinaryEnumObjectImpl);
            return ex1.enumOrdinal() == ex2.enumOrdinal();
        }
        BinaryObject o = o1 instanceof BinaryObjectEx ? o2 : o1;
        throw new BinaryObjectException("Array identity resolver cannot be used with provided BinaryObject implementation: " + o.getClass().getName());
    }

    private static boolean equalsHeap(BinaryObjectExImpl o1, BinaryObjectExImpl o2) {
        byte[] arr1 = o1.array();
        byte[] arr2 = o2.array();
        assert (arr1 != null && arr2 != null);
        int i = o1.dataStartOffset();
        int j = o2.dataStartOffset();
        int end = o1.footerStartOffset();
        if (end - i != o2.footerStartOffset() - j) {
            return false;
        }
        while (i < end) {
            if (arr1[i] != arr2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean equalsHeapOffheap(BinaryObjectExImpl o1, BinaryObjectExImpl o2) {
        byte[] arr1 = o1.array();
        long ptr2 = o2.offheapAddress();
        assert (arr1 != null && ptr2 != 0L);
        int i = o1.dataStartOffset();
        int j = o2.dataStartOffset();
        int end = o1.footerStartOffset();
        if (end - i != o2.footerStartOffset() - j) {
            return false;
        }
        while (i < end) {
            if (arr1[i] != BinaryPrimitives.readByte(ptr2, j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean equalsOffheap(BinaryObjectExImpl o1, BinaryObjectExImpl o2) {
        long ptr1 = o1.offheapAddress();
        long ptr2 = o2.offheapAddress();
        assert (ptr1 != 0L && ptr2 != 0L);
        int i = o1.dataStartOffset();
        int j = o2.dataStartOffset();
        int end = o1.footerStartOffset();
        if (end - i != o2.footerStartOffset() - j) {
            return false;
        }
        while (i < end) {
            if (BinaryPrimitives.readByte(ptr1, i) != BinaryPrimitives.readByte(ptr2, j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public String toString() {
        return S.toString(BinaryArrayIdentityResolver.class, this);
    }
}

