/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.jta;

import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionState;

final class CacheJtaResource
implements XAResource,
Synchronization {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static final Xid[] NO_XID;
    private GridNearTxLocal cacheTx;
    private Xid xid;
    private final GridKernalContext ctx;

    CacheJtaResource(GridNearTxLocal cacheTx, GridKernalContext ctx) {
        assert (cacheTx != null);
        assert (ctx != null);
        this.cacheTx = cacheTx;
        this.ctx = ctx;
        if (log == null) {
            log = U.logger((GridKernalContext)ctx, logRef, CacheJtaResource.class);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("XA resource start(...) [xid=" + xid + ", flags=<" + this.flags(flags) + ">]");
        }
        this.xid = xid;
        if ((flags & 0x8000000) == 0x8000000) {
            try {
                this.cacheTx.resume();
            }
            catch (IgniteCheckedException e) {
                this.throwException("Failed to resume cache transaction: " + e.getMessage(), e);
            }
        }
    }

    private void throwException(String msg, Throwable cause) throws XAException {
        XAException ex = new XAException(msg);
        ex.initCause(cause);
        throw ex;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (log.isDebugEnabled()) {
            log.debug("XA resource rollback(...) [xid=" + xid + "]");
        }
        try {
            this.ctx.cache().context().rollbackTxAsync(this.cacheTx).get();
        }
        catch (IgniteCheckedException e) {
            this.throwException("Failed to rollback cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (log.isDebugEnabled()) {
            log.debug("XA resource prepare(...) [xid=" + xid + "]");
        }
        if (this.cacheTx.state() != TransactionState.ACTIVE) {
            throw new XAException("Cache transaction is not in active state.");
        }
        try {
            this.cacheTx.prepare(true);
        }
        catch (IgniteCheckedException e) {
            this.throwException("Failed to prepare cache transaction.", e);
        }
        return 0;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        assert (this.xid.equals(xid));
        if (log.isDebugEnabled()) {
            log.debug("XA resource end(...) [xid=" + xid + ", flags=<" + this.flags(flags) + ">]");
        }
        if ((flags & 0x20000000) > 0) {
            this.cacheTx.setRollbackOnly();
        } else if ((flags & 0x2000000) == 0x2000000) {
            try {
                this.cacheTx.suspend();
            }
            catch (IgniteCheckedException e) {
                this.throwException("Failed to suspend cache transaction: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        assert (this.xid.equals(xid));
        if (log.isDebugEnabled()) {
            log.debug("XA resource commit(...) [xid=" + xid + ", onePhase=" + onePhase + "]");
        }
        try {
            this.ctx.cache().context().commitTxAsync(this.cacheTx).get();
        }
        catch (IgniteCheckedException e) {
            this.throwException("Failed to commit cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (log.isDebugEnabled()) {
            log.debug("XA resource forget(...) [xid=" + xid + "]");
        }
        try {
            this.ctx.cache().context().rollbackTxAsync(this.cacheTx).get();
        }
        catch (IgniteCheckedException e) {
            this.throwException("Failed to forget cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public Xid[] recover(int i) {
        if (this.cacheTx.state() == TransactionState.PREPARED) {
            return new Xid[]{this.xid};
        }
        return NO_XID;
    }

    private String flags(int flags) {
        StringBuilder res = new StringBuilder();
        this.addFlag(res, flags, 0x800000, "TMENDRSCAN");
        this.addFlag(res, flags, 0x20000000, "TMFAIL");
        this.addFlag(res, flags, 0x200000, "TMJOIN");
        this.addFlag(res, flags, 0, "TMNOFLAGS");
        this.addFlag(res, flags, 0x40000000, "TMONEPHASE");
        this.addFlag(res, flags, 0x8000000, "TMRESUME");
        this.addFlag(res, flags, 0x1000000, "TMSTARTRSCAN");
        this.addFlag(res, flags, 0x4000000, "TMSUCCESS");
        this.addFlag(res, flags, 0x2000000, "TMSUSPEND");
        return res.toString();
    }

    private StringBuilder addFlag(StringBuilder sb, int flags, int mask, String flagName) {
        if ((flags & mask) > 0) {
            sb.append(sb.length() > 0 ? "," : "").append(flagName);
        }
        return sb;
    }

    @Override
    public int getTransactionTimeout() {
        return (int)(this.cacheTx.timeout() / 1000L);
    }

    @Override
    public boolean setTransactionTimeout(int i) {
        this.cacheTx.timeout((long)(i * 1000));
        return true;
    }

    @Override
    public boolean isSameRM(XAResource xar) {
        if (xar == this) {
            return true;
        }
        if (!(xar instanceof CacheJtaResource)) {
            return false;
        }
        CacheJtaResource other = (CacheJtaResource)xar;
        return this.cacheTx == other.cacheTx;
    }

    public void beforeCompletion() {
        if (log.isDebugEnabled()) {
            log.debug("Synchronization.beforeCompletion() [xid=" + this.cacheTx.xid() + "]");
        }
        if (this.cacheTx.state() != TransactionState.ACTIVE) {
            throw new CacheException("Cache transaction is not in active state.");
        }
        try {
            this.cacheTx.prepare(true);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException("Failed to prepare cache transaction.", (Throwable)e);
        }
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 3: {
                if (log.isDebugEnabled()) {
                    log.debug("Synchronization.afterCompletion(STATUS_COMMITTED) [xid=" + this.cacheTx.xid() + "]");
                }
                try {
                    this.ctx.cache().context().commitTxAsync(this.cacheTx).get();
                    break;
                }
                catch (IgniteCheckedException e) {
                    throw new CacheException("Failed to commit cache transaction.", (Throwable)e);
                }
            }
            case 4: {
                if (log.isDebugEnabled()) {
                    log.debug("Synchronization.afterCompletion(STATUS_ROLLEDBACK) [xid=" + this.cacheTx.xid() + "]");
                }
                try {
                    this.ctx.cache().context().rollbackTxAsync(this.cacheTx).get();
                    break;
                }
                catch (IgniteCheckedException e) {
                    throw new CacheException("Failed to rollback cache transaction.", (Throwable)e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction status: " + status);
            }
        }
    }

    boolean isFinished() {
        TransactionState state = this.cacheTx.state();
        return state == TransactionState.COMMITTED || state == TransactionState.ROLLED_BACK;
    }

    GridNearTxLocal cacheTx() {
        return this.cacheTx;
    }

    public String toString() {
        return S.toString(CacheJtaResource.class, (Object)this);
    }

    static {
        NO_XID = new Xid[0];
    }
}

