/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.IterableAccumulator;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.MemoryTrackingNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;

public abstract class AggregateNode<Row>
extends MemoryTrackingNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    protected final AggregateType type;
    protected final Supplier<List<AccumulatorWrapper<Row>>> accFactory;
    protected final RowHandler.RowFactory<Row> rowFactory;
    protected final boolean hasAggAccum;

    protected AggregateNode(ExecutionContext<Row> ctx, RelDataType rowType, AggregateType type, Supplier<List<AccumulatorWrapper<Row>>> accFactory, RowHandler.RowFactory<Row> rowFactory, long rowOverhead) {
        super(ctx, rowType, rowOverhead);
        this.type = type;
        this.accFactory = accFactory;
        this.rowFactory = rowFactory;
        this.hasAggAccum = this.hasAggAccumulators();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    protected boolean hasAccumulators() {
        return this.accFactory != null;
    }

    private boolean hasAggAccumulators() {
        return this.accFactory != null && this.accFactory.get().stream().anyMatch(aw -> aw.accumulator() instanceof IterableAccumulator);
    }
}

