/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.compute.message.ExecuteResponse;
import org.apache.ignite.internal.compute.message.ExecuteResponseBuilder;
import org.apache.ignite.internal.compute.message.ExecuteResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ExecuteResponseImpl
implements ExecuteResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final UUID jobId;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private ExecuteResponseImpl(UUID jobId, Throwable throwable, byte[] throwableByteArray) {
        this.jobId = jobId;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return ExecuteResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(ExecuteResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExecuteResponseImpl otherMessage = (ExecuteResponseImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobId, this.throwable);
        return result;
    }

    public ExecuteResponseImpl clone() {
        try {
            return (ExecuteResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ExecuteResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements ExecuteResponseBuilder {
        private UUID jobId;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public ExecuteResponseBuilder jobId(UUID jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public ExecuteResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public ExecuteResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public ExecuteResponse build() {
            return new ExecuteResponseImpl(this.jobId, this.throwable, this.throwableByteArray);
        }
    }
}

