/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.io;

import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.tostring.S;

public final class IoVersions<V extends PageIo> {
    private final V[] vers;
    private final int type;
    private final V latest;

    @SafeVarargs
    public IoVersions(V ... vers) {
        assert (vers != null);
        assert (vers.length > 0);
        this.vers = vers;
        this.type = ((PageIo)vers[0]).getType();
        this.latest = vers[vers.length - 1];
        assert (this.checkVersions());
    }

    public int getType() {
        return this.type;
    }

    private boolean checkVersions() {
        byte flag = ((PageIo)this.vers[0]).getFlag();
        for (int i = 0; i < this.vers.length; ++i) {
            V v = this.vers[i];
            if (((PageIo)v).getType() == this.type && ((PageIo)v).getVersion() == i + 1 && ((PageIo)v).getFlag() == flag) continue;
            return false;
        }
        return true;
    }

    public V latest() {
        return this.latest;
    }

    public V forVersion(int ver) {
        if (ver == 0) {
            throw new IllegalStateException("Failed to get page IO instance (page content is corrupted)");
        }
        return this.vers[ver - 1];
    }

    public V forPage(long pageAddr) {
        int ver = PageIo.getVersion(pageAddr);
        V res = this.forVersion(ver);
        assert (((PageIo)res).getType() == PageIo.getType(pageAddr)) : "resType=" + ((PageIo)res).getType() + ", pageType=" + PageIo.getType(pageAddr);
        return res;
    }

    public String toString() {
        return S.toString(IoVersions.class, (Object)this);
    }
}

