/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.netty.ConnectTTLHandler;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.IdleTimeoutHandler;
import io.micronaut.http.client.netty.IdlingConnectionHandler;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.SimpleChannelInboundHandlerInstrumented;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.stream.DefaultHttp2Content;
import io.micronaut.http.netty.stream.Http2Content;
import io.micronaut.http.netty.stream.HttpStreamsClientHandler;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
final class ConnectionManager {
    final ChannelPoolMap<DefaultHttpClient.RequestKey, ChannelPool> poolMap;
    final InvocationInstrumenter instrumenter;
    final HttpVersion httpVersion;
    private final AttributeKey<NettyClientCustomizer> CHANNEL_CUSTOMIZER_KEY = AttributeKey.valueOf((String)"micronaut.http.customizer");
    private final AttributeKey<Future<?>> STREAM_CHANNEL_INITIALIZED = AttributeKey.valueOf((String)"micronaut.http.streamChannelInitialized");
    private final AttributeKey<Http2Stream> STREAM_KEY = AttributeKey.valueOf((String)"micronaut.http2.stream");
    private final Logger log;
    private EventLoopGroup group;
    private final boolean shutdownGroup;
    private final ThreadFactory threadFactory;
    private final ChannelFactory<? extends Channel> socketChannelFactory;
    private Bootstrap bootstrap;
    private final HttpClientConfiguration configuration;
    @Nullable
    private final Long readTimeoutMillis;
    @Nullable
    private final Long connectionTimeAliveMillis;
    private final SslContext sslContext;
    private final NettyClientCustomizer clientCustomizer;
    private final Collection<ChannelPipelineListener> pipelineListeners;
    private final String informationalServiceId;

    ConnectionManager(Logger log, @Nullable EventLoopGroup eventLoopGroup, ThreadFactory threadFactory, HttpClientConfiguration configuration, HttpVersion httpVersion, InvocationInstrumenter instrumenter, ChannelFactory<? extends Channel> socketChannelFactory, NettyClientSslBuilder nettyClientSslBuilder, NettyClientCustomizer clientCustomizer, Collection<ChannelPipelineListener> pipelineListeners, String informationalServiceId) {
        int maxConnections;
        if (httpVersion == null) {
            httpVersion = configuration.getHttpVersion();
        }
        this.log = log;
        this.httpVersion = httpVersion;
        this.threadFactory = threadFactory;
        this.socketChannelFactory = socketChannelFactory;
        this.configuration = configuration;
        this.instrumenter = instrumenter;
        this.clientCustomizer = clientCustomizer;
        this.pipelineListeners = pipelineListeners;
        this.informationalServiceId = informationalServiceId;
        this.connectionTimeAliveMillis = configuration.getConnectTtl().map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        this.readTimeoutMillis = configuration.getReadTimeout().map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        this.sslContext = nettyClientSslBuilder.build(configuration.getSslConfiguration(), httpVersion).orElse(null);
        if (eventLoopGroup != null) {
            this.group = eventLoopGroup;
            this.shutdownGroup = false;
        } else {
            this.group = ConnectionManager.createEventLoopGroup(configuration, threadFactory);
            this.shutdownGroup = true;
        }
        this.initBootstrap();
        final ChannelHealthChecker channelHealthChecker = channel -> channel.eventLoop().newSucceededFuture((Object)(channel.isActive() && !ConnectTTLHandler.isChannelExpired(channel) ? 1 : 0));
        final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration = configuration.getConnectionPoolConfiguration();
        this.poolMap = connectionPoolConfiguration.isEnabled() || httpVersion == HttpVersion.HTTP_2_0 ? ((maxConnections = connectionPoolConfiguration.getMaxConnections()) > -1 ? new AbstractChannelPoolMap<DefaultHttpClient.RequestKey, ChannelPool>(){

            protected ChannelPool newPool(DefaultHttpClient.RequestKey key) {
                Bootstrap newBootstrap = ConnectionManager.this.bootstrap.clone(ConnectionManager.this.group);
                ConnectionManager.this.initBootstrapForProxy(newBootstrap, key.isSecure(), key.getHost(), key.getPort());
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = ConnectionManager.this.newPoolHandler(key);
                long acquireTimeoutMillis = connectionPoolConfiguration.getAcquireTimeout().map(Duration::toMillis).orElse(-1L);
                return new FixedChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler, channelHealthChecker, (FixedChannelPool.AcquireTimeoutAction)(acquireTimeoutMillis > -1L ? FixedChannelPool.AcquireTimeoutAction.FAIL : null), acquireTimeoutMillis, maxConnections, connectionPoolConfiguration.getMaxPendingAcquires());
            }
        } : new AbstractChannelPoolMap<DefaultHttpClient.RequestKey, ChannelPool>(){

            protected ChannelPool newPool(DefaultHttpClient.RequestKey key) {
                Bootstrap newBootstrap = ConnectionManager.this.bootstrap.clone(ConnectionManager.this.group);
                ConnectionManager.this.initBootstrapForProxy(newBootstrap, key.isSecure(), key.getHost(), key.getPort());
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = ConnectionManager.this.newPoolHandler(key);
                return new SimpleChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler, channelHealthChecker);
            }
        }) : null;
        Optional connectTimeout = configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)duration.toMillis())));
        for (Map.Entry entry : configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            String channelOption = (String)entry.getKey();
            this.bootstrap.option(ChannelOption.valueOf((String)channelOption), v);
        }
    }

    private static NioEventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        OptionalInt numOfThreads = configuration.getNumOfThreads();
        Optional threadFactoryType = configuration.getThreadFactory();
        boolean hasThreads = numOfThreads.isPresent();
        boolean hasFactory = threadFactoryType.isPresent();
        NioEventLoopGroup group = hasThreads && hasFactory ? new NioEventLoopGroup(numOfThreads.getAsInt(), (ThreadFactory)InstantiationUtils.instantiate((Class)((Class)threadFactoryType.get()))) : (hasThreads ? (threadFactory != null ? new NioEventLoopGroup(numOfThreads.getAsInt(), threadFactory) : new NioEventLoopGroup(numOfThreads.getAsInt())) : (threadFactory != null ? new NioEventLoopGroup(NettyThreadFactory.DEFAULT_EVENT_LOOP_THREADS, threadFactory) : new NioEventLoopGroup()));
        return group;
    }

    public void start() {
        if (this.shutdownGroup) {
            this.group = ConnectionManager.createEventLoopGroup(this.configuration, this.threadFactory);
            this.initBootstrap();
        }
    }

    private void initBootstrap() {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channelFactory(this.socketChannelFactory)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    public void shutdown() {
        if (this.poolMap instanceof Iterable) {
            Iterable i = (Iterable)this.poolMap;
            for (Map.Entry entry : i) {
                ChannelPool cp = (ChannelPool)entry.getValue();
                try {
                    if (cp instanceof SimpleChannelPool) {
                        this.addInstrumentedListener(((SimpleChannelPool)cp).closeAsync(), future -> {
                            Throwable cause;
                            if (!future.isSuccess() && (cause = future.cause()) != null) {
                                this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), cause);
                            }
                        });
                        continue;
                    }
                    cp.close();
                }
                catch (Exception cause) {
                    this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), (Throwable)cause);
                }
            }
        }
        if (this.shutdownGroup) {
            Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
            Duration shutdownQuietPeriod = this.configuration.getShutdownQuietPeriod().orElse(Duration.ofMillis(1L));
            Future future2 = this.group.shutdownGracefully(shutdownQuietPeriod.toMillis(), shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
            try {
                future2.await(shutdownTimeout.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return !this.group.isShutdown();
    }

    public Scheduler getEventLoopScheduler() {
        return Schedulers.fromExecutor((Executor)this.group);
    }

    private ChannelFuture doConnect(DefaultHttpClient.RequestKey requestKey, boolean isStream, boolean isProxy, boolean acceptsEvents, Consumer<ChannelHandlerContext> contextConsumer) throws HttpClientException {
        SslContext sslCtx = this.buildSslContext(requestKey);
        String host = requestKey.getHost();
        int port = requestKey.getPort();
        Bootstrap localBootstrap = this.bootstrap.clone();
        this.initBootstrapForProxy(localBootstrap, sslCtx != null, host, port);
        localBootstrap.handler((ChannelHandler)new HttpClientInitializer(sslCtx, host, port, isStream, isProxy, acceptsEvents, contextConsumer));
        return localBootstrap.connect(host, port);
    }

    private void initBootstrapForProxy(Bootstrap localBootstrap, boolean sslCtx, String host, int port) {
        Proxy proxy = this.configuration.resolveProxy(sslCtx, host, port);
        if (proxy.type() != Proxy.Type.DIRECT) {
            localBootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
    }

    private SslContext buildSslContext(DefaultHttpClient.RequestKey requestKey) {
        SslContext sslCtx;
        if (requestKey.isSecure()) {
            sslCtx = this.sslContext;
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw this.customizeException(new HttpClientException("Cannot send HTTPS request. SSL is disabled"));
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    private PoolHandle mockPoolHandle(Channel channel) {
        return new PoolHandle(null, channel);
    }

    Mono<PoolHandle> connectForExchange(DefaultHttpClient.RequestKey requestKey, boolean multipart, boolean acceptEvents) {
        return Mono.create(emitter -> {
            if (this.poolMap != null && !multipart) {
                try {
                    ChannelPool channelPool = this.poolMap.get((Object)requestKey);
                    this.addInstrumentedListener(channelPool.acquire(), future -> {
                        if (future.isSuccess()) {
                            Channel channel = (Channel)future.get();
                            PoolHandle poolHandle = new PoolHandle(channelPool, channel);
                            Future initFuture = (Future)channel.attr(this.STREAM_CHANNEL_INITIALIZED).get();
                            emitter.onCancel(poolHandle::release);
                            if (initFuture == null) {
                                emitter.success((Object)poolHandle);
                            } else {
                                this.addInstrumentedListener(initFuture, f -> emitter.success((Object)poolHandle));
                            }
                        } else {
                            Throwable cause = future.cause();
                            emitter.error((Throwable)this.customizeException(new HttpClientException("Connect Error: " + cause.getMessage(), cause)));
                        }
                    });
                }
                catch (HttpClientException e) {
                    emitter.error((Throwable)e);
                }
            } else {
                ChannelFuture connectionFuture = this.doConnect(requestKey, false, false, acceptEvents, null);
                this.addInstrumentedListener((Future)connectionFuture, (GenericFutureListener)future -> {
                    if (!future.isSuccess()) {
                        Throwable cause = future.cause();
                        emitter.error((Throwable)this.customizeException(new HttpClientException("Connect Error: " + cause.getMessage(), cause)));
                    } else {
                        PoolHandle ph = this.mockPoolHandle(connectionFuture.channel());
                        emitter.onCancel(ph::release);
                        emitter.success((Object)ph);
                    }
                });
            }
        }).delayUntil(this::delayUntilHttp2Ready).map(poolHandle -> {
            this.addReadTimeoutHandler(poolHandle.channel.pipeline());
            return poolHandle;
        });
    }

    private Publisher<?> delayUntilHttp2Ready(PoolHandle poolHandle) {
        Http2SettingsHandler settingsHandler = (Http2SettingsHandler)poolHandle.channel.pipeline().get("http2-settings");
        if (settingsHandler == null) {
            return Flux.empty();
        }
        Sinks.Empty empty = Sinks.empty();
        this.addInstrumentedListener((Future)settingsHandler.promise, (GenericFutureListener)future -> {
            if (future.isSuccess()) {
                empty.tryEmitEmpty();
            } else {
                poolHandle.taint();
                poolHandle.release();
                empty.tryEmitError(future.cause());
            }
        });
        return empty.asMono();
    }

    Mono<PoolHandle> connectForStream(DefaultHttpClient.RequestKey requestKey, boolean isProxy, boolean acceptEvents) {
        return Mono.create(emitter -> {
            try {
                if (this.httpVersion == HttpVersion.HTTP_2_0) {
                    ChannelFuture channelFuture = this.doConnect(requestKey, true, isProxy, acceptEvents, channelHandlerContext -> {
                        try {
                            Channel channel = channelHandlerContext.channel();
                            emitter.success((Object)this.mockPoolHandle(channel));
                        }
                        catch (Exception e) {
                            emitter.error((Throwable)e);
                        }
                    });
                } else {
                    ChannelFuture channelFuture = this.doConnect(requestKey, true, isProxy, acceptEvents, null);
                    this.addInstrumentedListener((Future)channelFuture, (GenericFutureListener)((ChannelFutureListener)f -> {
                        if (f.isSuccess()) {
                            Channel channel = f.channel();
                            emitter.success((Object)this.mockPoolHandle(channel));
                        } else {
                            Throwable cause = f.cause();
                            emitter.error((Throwable)this.customizeException(new HttpClientException("Connect error:" + cause.getMessage(), cause)));
                        }
                    }));
                }
            }
            catch (HttpClientException e) {
                emitter.error((Throwable)e);
                return;
            }
        }).delayUntil(this::delayUntilHttp2Ready).map(poolHandle -> {
            this.addReadTimeoutHandler(poolHandle.channel.pipeline());
            return poolHandle;
        });
    }

    Mono<?> connectForWebsocket(DefaultHttpClient.RequestKey requestKey, final ChannelHandler handler) {
        final Sinks.Empty initial = Sinks.empty();
        Bootstrap bootstrap = this.bootstrap.clone();
        SslContext sslContext = this.buildSslContext(requestKey);
        bootstrap.remoteAddress(requestKey.getHost(), requestKey.getPort());
        this.initBootstrapForProxy(bootstrap, sslContext != null, requestKey.getHost(), requestKey.getPort());
        bootstrap.handler((ChannelHandler)new HttpClientInitializer(sslContext, requestKey.getHost(), requestKey.getPort(), false, false, false, null){

            @Override
            protected void addFinalHandler(ChannelPipeline pipeline) {
                Duration duration;
                Optional readIdleTime;
                pipeline.remove("http-decoder");
                ReadTimeoutHandler readTimeoutHandler = (ReadTimeoutHandler)pipeline.get(ReadTimeoutHandler.class);
                if (readTimeoutHandler != null) {
                    pipeline.remove((ChannelHandler)readTimeoutHandler);
                }
                if ((readIdleTime = ConnectionManager.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                try {
                    pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                    pipeline.addLast("micronaut-websocket-client", handler);
                    initial.tryEmitEmpty();
                }
                catch (Throwable e) {
                    initial.tryEmitError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                }
            }
        });
        this.addInstrumentedListener((Future)bootstrap.connect(), (GenericFutureListener)future -> {
            if (!future.isSuccess()) {
                initial.tryEmitError(future.cause());
            }
        });
        return initial.asMono();
    }

    private AbstractChannelPoolHandler newPoolHandler(final DefaultHttpClient.RequestKey key) {
        return new AbstractChannelPoolHandler(){

            public void channelCreated(Channel ch) {
                ChannelPromise streamPipelineBuilt = ch.newPromise();
                ch.attr(ConnectionManager.this.STREAM_CHANNEL_INITIALIZED).set((Object)streamPipelineBuilt);
                ChannelInboundHandlerAdapter failureHandler = new ChannelInboundHandlerAdapter((Promise)streamPipelineBuilt){
                    final /* synthetic */ Promise val$streamPipelineBuilt;
                    {
                        this.val$streamPipelineBuilt = promise;
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) {
                        this.val$streamPipelineBuilt.trySuccess(null);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        this.val$streamPipelineBuilt.trySuccess(null);
                        ctx.fireChannelInactive();
                    }
                };
                ch.pipeline().addLast(new ChannelHandler[]{failureHandler});
                ch.pipeline().addLast("http-client-init", (ChannelHandler)new HttpClientInitializer(key.isSecure() ? ConnectionManager.this.sslContext : null, key.getHost(), key.getPort(), false, false, false, null, (Promise)streamPipelineBuilt, ch, (ChannelHandler)failureHandler){
                    final /* synthetic */ Promise val$streamPipelineBuilt;
                    final /* synthetic */ Channel val$ch;
                    final /* synthetic */ ChannelHandler val$failureHandler;
                    {
                        this.val$streamPipelineBuilt = promise;
                        this.val$ch = channel;
                        this.val$failureHandler = channelHandler;
                        super(sslContext, host, port, stream, proxy, acceptsEvents, contextConsumer);
                    }

                    @Override
                    protected void addFinalHandler(ChannelPipeline pipeline) {
                    }

                    @Override
                    void onStreamPipelineBuilt() {
                        super.onStreamPipelineBuilt();
                        this.val$streamPipelineBuilt.trySuccess(null);
                        this.val$ch.pipeline().remove(this.val$failureHandler);
                        this.val$ch.attr(ConnectionManager.this.STREAM_CHANNEL_INITIALIZED).set(null);
                    }
                });
                if (ConnectionManager.this.connectionTimeAliveMillis != null) {
                    ch.pipeline().addLast("connect-ttl", (ChannelHandler)new ConnectTTLHandler(ConnectionManager.this.connectionTimeAliveMillis));
                }
            }

            public void channelReleased(Channel ch) {
                Duration idleTimeout = ConnectionManager.this.configuration.getConnectionPoolIdleTimeout().orElse(Duration.ofNanos(0L));
                ChannelPipeline pipeline = ch.pipeline();
                if (ch.isOpen()) {
                    ch.config().setAutoRead(true);
                    pipeline.addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
                    if (idleTimeout.toNanos() > 0L) {
                        pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(idleTimeout.toNanos(), idleTimeout.toNanos(), 0L, TimeUnit.NANOSECONDS));
                        pipeline.addLast(new ChannelHandler[]{IdleTimeoutHandler.INSTANCE});
                    }
                }
                if (ConnectTTLHandler.isChannelExpired(ch) && ch.isOpen() && !ch.eventLoop().isShuttingDown()) {
                    ch.close();
                }
                ConnectionManager.this.removeReadTimeoutHandler(pipeline);
            }

            public void channelAcquired(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (pipeline.context((ChannelHandler)IdlingConnectionHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
                }
                if (pipeline.context("idle-state") != null) {
                    pipeline.remove("idle-state");
                }
                if (pipeline.context((ChannelHandler)IdleTimeoutHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdleTimeoutHandler.INSTANCE);
                }
            }
        };
    }

    private void configureHttp2Ssl(final HttpClientInitializer httpClientInitializer, final @NonNull SocketChannel ch, @NonNull SslContext sslCtx, String host, int port, HttpToHttp2ConnectionHandler connectionHandler) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)this.configureSslHandler(sslCtx.newHandler(ch.alloc(), host, port)));
        pipeline.addLast("http2-protocol-negotiator", (ChannelHandler)new ApplicationProtocolNegotiationHandler("h2"){

            public void handlerRemoved(ChannelHandlerContext ctx) {
                Consumer<ChannelHandlerContext> contextConsumer = httpClientInitializer.contextConsumer;
                if (contextConsumer != null) {
                    contextConsumer.accept(ctx);
                }
            }

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                if ("h2".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    if (httpClientInitializer.stream) {
                        ctx.channel().config().setAutoRead(false);
                    }
                    p.addLast("http2-settings", (ChannelHandler)new Http2SettingsHandler(ch.newPromise()));
                    httpClientInitializer.addEventStreamHandlerIfNecessary(p);
                    httpClientInitializer.addFinalHandler(p);
                    for (ChannelPipelineListener pipelineListener : ConnectionManager.this.pipelineListeners) {
                        pipelineListener.onConnect(p);
                    }
                } else if ("http/1.1".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    httpClientInitializer.addHttp1Handlers(p);
                } else {
                    ctx.close();
                    throw ConnectionManager.this.customizeException(new HttpClientException("Unknown Protocol: " + protocol));
                }
                httpClientInitializer.onStreamPipelineBuilt();
            }
        });
        pipeline.addLast("http2-connection", (ChannelHandler)connectionHandler);
    }

    private void configureHttp2ClearText(final HttpClientInitializer httpClientInitializer, @NonNull SocketChannel ch, @NonNull HttpToHttp2ConnectionHandler connectionHandler) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec("http2-connection", (Http2ConnectionHandler)connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("http-client-codec", (ChannelHandler)sourceCodec);
        httpClientInitializer.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        pipeline.addLast(new ChannelHandler[]{upgradeHandler});
        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                ctx.fireUserEventTriggered(evt);
                if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
                    httpClientInitializer.onStreamPipelineBuilt();
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        }});
        pipeline.addLast("http2-upgrade-request", (ChannelHandler)new H2cUpgradeRequestHandler(httpClientInitializer));
    }

    @NonNull
    private static HttpToHttp2ConnectionHandlerBuilder newHttp2ConnectionHandlerBuilder(@NonNull Http2Connection connection, @NonNull HttpClientConfiguration configuration, boolean stream) {
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder();
        builder.validateHeaders(true);
        Object http2ToHttpAdapter = !stream ? new InboundHttp2ToHttpAdapterBuilder(connection).maxContentLength(configuration.getMaxContentLength()).validateHttpHeaders(true).propagateSettings(true).build() : new StreamingInboundHttp2ToHttpAdapter(connection, configuration.getMaxContentLength());
        return builder.connection(connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(connection, (Http2FrameListener)http2ToHttpAdapter));
    }

    private void configureProxy(ChannelPipeline pipeline, boolean secure, String host, int port) {
        InetSocketAddress isa;
        Proxy proxy = this.configuration.resolveProxy(secure, host, port);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return;
        }
        Proxy.Type proxyType = proxy.type();
        SocketAddress proxyAddress = proxy.address();
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (proxyAddress instanceof InetSocketAddress && (isa = (InetSocketAddress)proxyAddress).isUnresolved()) {
            proxyAddress = new InetSocketAddress(isa.getHostString(), isa.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    <V, C extends Future<V>> Future<V> addInstrumentedListener(Future<V> channelFuture, GenericFutureListener<C> listener) {
        return channelFuture.addListener(f -> {
            try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
                listener.operationComplete(f);
            }
        });
    }

    private <E extends HttpClientException> E customizeException(E exc) {
        DefaultHttpClient.customizeException0(this.configuration, this.informationalServiceId, exc);
        return exc;
    }

    private void addReadTimeoutHandler(ChannelPipeline pipeline) {
        if (this.readTimeoutMillis != null) {
            if (this.httpVersion == HttpVersion.HTTP_2_0) {
                pipeline.addBefore("http2-connection", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
            } else {
                pipeline.addBefore("http-client-codec", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
            }
        }
    }

    private void removeReadTimeoutHandler(ChannelPipeline pipeline) {
        if (this.readTimeoutMillis != null && pipeline.context("read-timeout") != null) {
            pipeline.remove("read-timeout");
        }
    }

    private SslHandler configureSslHandler(SslHandler sslHandler) {
        sslHandler.setHandshakeTimeoutMillis(this.configuration.getSslConfiguration().getHandshakeTimeout().toMillis());
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    final class PoolHandle {
        final Channel channel;
        private final ChannelPool channelPool;
        private boolean canReturn;

        private PoolHandle(ChannelPool channelPool, Channel channel) {
            this.channel = channel;
            this.channelPool = channelPool;
            this.canReturn = channelPool != null;
        }

        void taint() {
            this.canReturn = false;
        }

        void release() {
            if (this.channelPool != null) {
                ConnectionManager.this.removeReadTimeoutHandler(this.channel.pipeline());
                if (!this.canReturn) {
                    this.channel.closeFuture().addListener(future -> this.channelPool.release(this.channel));
                } else {
                    this.channelPool.release(this.channel);
                }
            } else {
                this.channel.close();
            }
        }

        public boolean canReturn() {
            return this.canReturn;
        }

        void notifyRequestPipelineBuilt() {
            ((NettyClientCustomizer)this.channel.attr(ConnectionManager.this.CHANNEL_CUSTOMIZER_KEY).get()).onRequestPipelineBuilt();
        }
    }

    private class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        final SslContext sslContext;
        final String host;
        final int port;
        final boolean stream;
        final boolean proxy;
        final boolean acceptsEvents;
        Http2SettingsHandler settingsHandler;
        final Consumer<ChannelHandlerContext> contextConsumer;
        private NettyClientCustomizer channelCustomizer;

        protected HttpClientInitializer(SslContext sslContext, String host, int port, boolean stream, boolean proxy, boolean acceptsEvents, Consumer<ChannelHandlerContext> contextConsumer) {
            this.sslContext = sslContext;
            this.stream = stream;
            this.host = host;
            this.port = port;
            this.proxy = proxy;
            this.acceptsEvents = acceptsEvents;
            this.contextConsumer = contextConsumer;
        }

        protected void initChannel(SocketChannel ch) {
            this.channelCustomizer = ConnectionManager.this.clientCustomizer.specializeForChannel((Channel)ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ch.attr(ConnectionManager.this.CHANNEL_CUSTOMIZER_KEY).set((Object)this.channelCustomizer);
            ChannelPipeline p = ch.pipeline();
            ConnectionManager.this.configureProxy(p, this.sslContext != null, this.host, this.port);
            if (ConnectionManager.this.httpVersion == HttpVersion.HTTP_2_0) {
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                HttpToHttp2ConnectionHandlerBuilder builder = ConnectionManager.newHttp2ConnectionHandlerBuilder((Http2Connection)connection, ConnectionManager.this.configuration, this.stream);
                ConnectionManager.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        builder.frameLogger(new Http2FrameLogger(nettyLevel, DefaultHttpClient.class));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConnectionManager.this.customizeException(new HttpClientException("Unsupported log level: " + logLevel));
                    }
                });
                HttpToHttp2ConnectionHandler connectionHandler = builder.build();
                if (this.sslContext != null) {
                    ConnectionManager.this.configureHttp2Ssl(this, ch, this.sslContext, this.host, this.port, connectionHandler);
                } else {
                    ConnectionManager.this.configureHttp2ClearText(this, ch, connectionHandler);
                }
                this.channelCustomizer.onInitialPipelineBuilt();
            } else {
                Duration duration;
                Optional readIdleTime;
                if (this.stream) {
                    ch.config().setAutoRead(false);
                }
                ConnectionManager.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        p.addLast(new ChannelHandler[]{new LoggingHandler(DefaultHttpClient.class, nettyLevel)});
                    }
                    catch (IllegalArgumentException e) {
                        throw ConnectionManager.this.customizeException(new HttpClientException("Unsupported log level: " + logLevel));
                    }
                });
                if (this.sslContext != null) {
                    p.addLast("ssl", (ChannelHandler)ConnectionManager.this.configureSslHandler(this.sslContext.newHandler(ch.alloc(), this.host, this.port)));
                }
                if (ConnectionManager.this.poolMap == null && this.stream && (readIdleTime = ConnectionManager.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    p.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                this.addHttp1Handlers(p);
                this.channelCustomizer.onInitialPipelineBuilt();
                this.onStreamPipelineBuilt();
            }
        }

        void onStreamPipelineBuilt() {
            this.channelCustomizer.onStreamPipelineBuilt();
        }

        void addHttp1Handlers(ChannelPipeline p) {
            p.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec());
            p.addLast("http-decoder", (ChannelHandler)new HttpContentDecompressor());
            int maxContentLength = ConnectionManager.this.configuration.getMaxContentLength();
            if (!this.stream) {
                p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength){

                    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
                        if (!HttpUtil.isContentLengthSet((HttpMessage)aggregated) && aggregated.content().readableBytes() > 0) {
                            super.finishAggregation(aggregated);
                        }
                    }
                });
            }
            this.addEventStreamHandlerIfNecessary(p);
            this.addFinalHandler(p);
            for (ChannelPipelineListener pipelineListener : ConnectionManager.this.pipelineListeners) {
                pipelineListener.onConnect(p);
            }
        }

        void addEventStreamHandlerIfNecessary(ChannelPipeline p) {
            if (this.acceptsEventStream() && !this.proxy) {
                p.addLast("micronaut-sse-event-stream", (ChannelHandler)new LineBasedFrameDecoder(ConnectionManager.this.configuration.getMaxContentLength(), true, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof HttpContent) {
                            if (msg instanceof LastHttpContent) {
                                super.channelRead(ctx, msg);
                            } else {
                                Attribute streamKey = ctx.channel().attr(ConnectionManager.this.STREAM_KEY);
                                if (msg instanceof Http2Content) {
                                    streamKey.set((Object)((Http2Content)msg).stream());
                                }
                                try {
                                    super.channelRead(ctx, (Object)((HttpContent)msg).content());
                                }
                                finally {
                                    streamKey.set(null);
                                }
                            }
                        } else {
                            super.channelRead(ctx, msg);
                        }
                    }
                });
                p.addLast("micronaut-sse-content", (ChannelHandler)new SimpleChannelInboundHandlerInstrumented<ByteBuf>(ConnectionManager.this.instrumenter, false){

                    public boolean acceptInboundMessage(Object msg) {
                        return msg instanceof ByteBuf;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void channelReadInstrumented(ChannelHandlerContext ctx, ByteBuf msg) {
                        try {
                            Attribute streamKey = ctx.channel().attr(ConnectionManager.this.STREAM_KEY);
                            Http2Stream http2Stream = (Http2Stream)streamKey.get();
                            if (http2Stream != null) {
                                ctx.fireChannelRead((Object)new DefaultHttp2Content(msg.copy(), http2Stream));
                            } else {
                                ctx.fireChannelRead((Object)new DefaultHttpContent(msg.copy()));
                            }
                        }
                        finally {
                            msg.release();
                        }
                    }
                });
            }
        }

        protected void addFinalHandler(ChannelPipeline pipeline) {
            pipeline.addLast("http-streams-codec", (ChannelHandler)new HttpStreamsClientHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent) {
                        ctx.close();
                    }
                    super.userEventTriggered(ctx, evt);
                }
            });
        }

        private boolean acceptsEventStream() {
            return this.acceptsEvents;
        }
    }

    private class Http2SettingsHandler
    extends SimpleChannelInboundHandlerInstrumented<Http2Settings> {
        final ChannelPromise promise;

        Http2SettingsHandler(ChannelPromise promise) {
            super(ConnectionManager.this.instrumenter);
            this.promise = promise;
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, Http2Settings msg) {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (!this.promise.isDone()) {
                this.promise.tryFailure((Throwable)new HttpClientException("Channel became inactive before settings frame was received"));
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved(ctx);
            if (!this.promise.isDone()) {
                this.promise.tryFailure((Throwable)new HttpClientException("Handler was removed before settings frame was received"));
            }
        }
    }

    private class H2cUpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final HttpClientInitializer initializer;

        public H2cUpgradeRequestHandler(HttpClientInitializer initializer) {
            this.initializer = initializer;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.addLast("http2-settings", (ChannelHandler)this.initializer.settingsHandler);
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            String hostString = remote.getHostString();
            if (hostString == null) {
                hostString = remote.getAddress().getHostAddress();
            }
            upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(hostString + ':' + remote.getPort()));
            ctx.writeAndFlush((Object)upgradeRequest);
            ctx.fireChannelActive();
            if (this.initializer.contextConsumer != null) {
                this.initializer.contextConsumer.accept(ctx);
            }
            this.initializer.addFinalHandler(pipeline);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            int streamId;
            if (msg instanceof HttpMessage && (streamId = ((HttpMessage)msg).headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), -1)) == 1) {
                if (ConnectionManager.this.log.isDebugEnabled()) {
                    ConnectionManager.this.log.debug("Received response on HTTP2 stream 1, the stream used to respond to the initial upgrade request. Ignoring.");
                }
                ReferenceCountUtil.release((Object)msg);
                if (msg instanceof LastHttpContent) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
                return;
            }
            super.channelRead(ctx, msg);
        }
    }
}

