/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.ArrayOpCode;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import java.util.List;
import java.util.Objects;

class SetArrayElementBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final BytecodeExpression index;
    private final BytecodeExpression value;
    private final InstructionNode arrayStoreInstruction;

    SetArrayElementBytecodeExpression(BytecodeExpression instance, BytecodeExpression index, BytecodeExpression value) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.value = Objects.requireNonNull(value, "value is null");
        ParameterizedType componentType = instance.getType().getArrayComponentType();
        BytecodeUtils.checkArgument(index.getType().getPrimitiveType() == Integer.TYPE, "index must be int type, but is " + String.valueOf(index.getType()), new Object[0]);
        BytecodeUtils.checkArgument(componentType.equals(value.getType()), "value must be %s type, but is %s", componentType, value.getType());
        this.arrayStoreInstruction = ArrayOpCode.getArrayOpCode(componentType).getStore();
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.index).append(this.value).append(this.arrayStoreInstruction);
    }

    @Override
    protected String formatOneLine() {
        return String.valueOf(this.instance) + "[" + String.valueOf(this.index) + "] = " + String.valueOf(this.value);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.index, this.value);
    }
}

