/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster.exceptions;

import org.apache.ignite.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite.lang.ErrorGroups;

public class IllegalPartitionIdException
extends DisasterRecoveryException {
    private static final long serialVersionUID = -9215416423159317425L;

    public IllegalPartitionIdException(int partitionId) {
        super(ErrorGroups.DisasterRecovery.ILLEGAL_PARTITION_ID_ERR, "Partition ID can't be negative, found: " + partitionId);
    }

    public IllegalPartitionIdException(int partitionId, int partitions, String zoneName) {
        super(ErrorGroups.DisasterRecovery.ILLEGAL_PARTITION_ID_ERR, String.format("Partition IDs should be in range [0, %d] for zone %s, found: %d", partitions - 1, zoneName, partitionId));
    }
}

