/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.systemviews;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.apache.ignite.internal.util.TransformingIterator;

public final class ZonesSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        return List.of(ZonesSystemViewProvider.getZoneView(catalogSupplier), ZonesSystemViewProvider.getStorageProfilesView(catalogSupplier));
    }

    private static SystemView<?> getZoneView(Supplier<Catalog> catalogSupplier) {
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("ZONES")).addColumn("ZONE_NAME", NativeTypes.STRING, wrapper -> wrapper.zone.name())).addColumn("ZONE_PARTITIONS", NativeTypes.INT32, wrapper -> wrapper.zone.partitions())).addColumn("ZONE_REPLICAS", NativeTypes.INT32, wrapper -> wrapper.zone.replicas())).addColumn("DATA_NODES_AUTO_ADJUST_SCALE_UP", NativeTypes.INT32, wrapper -> wrapper.zone.dataNodesAutoAdjustScaleUp())).addColumn("DATA_NODES_AUTO_ADJUST_SCALE_DOWN", NativeTypes.INT32, wrapper -> wrapper.zone.dataNodesAutoAdjustScaleDown())).addColumn("DATA_NODES_FILTER", NativeTypes.STRING, wrapper -> wrapper.zone.filter())).addColumn("IS_DEFAULT_ZONE", NativeTypes.BOOLEAN, wrapper -> wrapper.isDefault)).addColumn("ZONE_CONSISTENCY_MODE", NativeTypes.STRING, wrapper -> wrapper.zone.consistencyMode().name())).addColumn("ZONE_ID", NativeTypes.INT32, wrapper -> wrapper.zone.id())).addColumn("NAME", NativeTypes.STRING, wrapper -> wrapper.zone.name())).addColumn("PARTITIONS", NativeTypes.INT32, wrapper -> wrapper.zone.partitions())).addColumn("REPLICAS", NativeTypes.INT32, wrapper -> wrapper.zone.replicas())).addColumn("CONSISTENCY_MODE", NativeTypes.STRING, wrapper -> wrapper.zone.consistencyMode().name())).addColumn("ZONE_QUORUM_SIZE", NativeTypes.INT32, wrapper -> wrapper.zone.quorumSize())).dataProvider(SubscriptionUtils.fromIterable(() -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            CatalogZoneDescriptor defaultZone = catalog.defaultZone();
            return new TransformingIterator(catalog.zones().iterator(), zone -> new ZoneWithDefaultMarker((CatalogZoneDescriptor)zone, defaultZone != null && defaultZone.id() == zone.id()));
        }))).build();
    }

    private static SystemView<?> getStorageProfilesView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.zones().stream().flatMap(zone -> {
                List<CatalogStorageProfileDescriptor> profiles = zone.storageProfiles().profiles();
                CatalogStorageProfileDescriptor defaultProfile = zone.storageProfiles().defaultProfile();
                return profiles.stream().map(profile -> new ZoneWithProfile((CatalogZoneDescriptor)zone, profile.storageProfile(), Objects.equals(profile.storageProfile(), defaultProfile.storageProfile())));
            }).iterator();
        };
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("ZONE_STORAGE_PROFILES")).addColumn("ZONE_NAME", NativeTypes.STRING, zone -> zone.descriptor.name())).addColumn("STORAGE_PROFILE", NativeTypes.STRING, zone -> zone.profileName)).addColumn("IS_DEFAULT_PROFILE", NativeTypes.BOOLEAN, zone -> zone.isDefaultProfile)).addColumn("ZONE_ID", NativeTypes.INT32, zone -> zone.descriptor.id())).dataProvider(SubscriptionUtils.fromIterable(viewData))).build();
    }

    private static class ZoneWithProfile {
        private final CatalogZoneDescriptor descriptor;
        private final String profileName;
        private final boolean isDefaultProfile;

        private ZoneWithProfile(CatalogZoneDescriptor zone, String profileName, boolean defaultProfile) {
            this.descriptor = zone;
            this.profileName = profileName;
            this.isDefaultProfile = defaultProfile;
        }
    }

    static class ZoneWithDefaultMarker {
        private final CatalogZoneDescriptor zone;
        private final boolean isDefault;

        ZoneWithDefaultMarker(CatalogZoneDescriptor zone, boolean isDefault) {
            this.zone = zone;
            this.isDefault = isDefault;
        }
    }
}

