/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

public class GridLocalConfigManager {
    private final boolean startClientCaches = IgniteSystemProperties.getBoolean("IGNITE_START_CACHES_ON_JOIN", false);
    private final List<BiConsumer<String, File>> lsnrs = new CopyOnWriteArrayList<BiConsumer<String, File>>();
    private final Deque<String> stopSeq = new LinkedList<String>();
    private final IgniteLogger log;
    private Set<String> localCachesOnStart;
    private final GridCacheProcessor cacheProcessor;
    private final File storeWorkDir;
    private final Marshaller marshaller;
    private final GridKernalContext ctx;
    private final ReentrantReadWriteLock chgLock = new ReentrantReadWriteLock();

    public GridLocalConfigManager(GridCacheProcessor cacheProcessor, GridKernalContext kernalCtx) throws IgniteCheckedException {
        this.cacheProcessor = cacheProcessor;
        this.ctx = kernalCtx;
        this.log = this.ctx.log(this.getClass());
        this.marshaller = this.ctx.marshallerContext().jdkMarshaller();
        PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> folderSettings = this.ctx.pdsFolderResolver().resolveFolders();
        if (!this.ctx.clientNode() && folderSettings.persistentStoreRootPath() != null) {
            this.storeWorkDir = folderSettings.persistentStoreNodePath();
            U.ensureDirectory(this.storeWorkDir, "page store work directory", this.log);
        } else {
            this.storeWorkDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigurationFiles(List<CacheConfiguration<?, ?>> ccfgs, BiConsumer<CacheConfiguration<?, ?>, File> ccfgCons) {
        this.chgLock.writeLock().lock();
        try {
            for (CacheConfiguration<?, ?> ccfg : ccfgs) {
                File[] ccfgFiles;
                File cacheDir = this.cacheWorkDir(ccfg);
                if (!cacheDir.exists() || (ccfgFiles = cacheDir.listFiles((dir, name) -> name.endsWith("cache_data.dat"))) == null) continue;
                for (File ccfgFile : ccfgFiles) {
                    ccfgCons.accept(ccfg, ccfgFile);
                }
            }
        }
        finally {
            this.chgLock.writeLock().unlock();
        }
    }

    public Map<String, StoredCacheData> readCacheConfigurations() throws IgniteCheckedException {
        if (this.ctx.clientNode()) {
            return Collections.emptyMap();
        }
        Object[] files = this.storeWorkDir.listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        HashMap<String, StoredCacheData> ccfgs = new HashMap<String, StoredCacheData>();
        Arrays.sort(files);
        for (Object file : files) {
            if (!((File)file).isDirectory()) continue;
            this.readCacheConfigurations((File)file, ccfgs);
        }
        return ccfgs;
    }

    public StoredCacheData readCacheData(File conf) throws IgniteCheckedException {
        return GridLocalConfigManager.readCacheData(conf, this.marshaller, this.ctx.config());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StoredCacheData readCacheData(File conf, @Nullable Marshaller marshaller, @Nullable IgniteConfiguration cfg) throws IgniteCheckedException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(conf.toPath(), new OpenOption[0]));){
            if (marshaller == null || cfg == null) {
                try (ObjectInputStream ostream = new ObjectInputStream(stream);){
                    StoredCacheData storedCacheData = (StoredCacheData)ostream.readObject();
                    return storedCacheData;
                }
            }
            StoredCacheData storedCacheData = (StoredCacheData)marshaller.unmarshal(stream, U.resolveClassLoader(cfg));
            return storedCacheData;
        }
        catch (IOException | ClassNotFoundException | IgniteCheckedException e) {
            throw new IgniteCheckedException("An error occurred during cache configuration loading from file [file=" + conf.getAbsolutePath() + "]", e);
        }
    }

    public static Map<File, StoredCacheData> readCachesData(File dbDir, @Nullable Marshaller marshaller, @Nullable IgniteConfiguration cfg) {
        File[] caches = dbDir.listFiles();
        if (caches == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(caches).filter(f -> f.isDirectory() && (f.getName().startsWith("cache-") || f.getName().startsWith("cacheGroup-")) && !f.getName().equals("cache-ignite-sys-cache")).filter(File::exists).flatMap(cacheDir -> Arrays.stream(FilePageStoreManager.cacheDataFiles(cacheDir))).collect(Collectors.toMap(f -> f, f -> {
            try {
                return GridLocalConfigManager.readCacheData(f, marshaller, cfg);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }));
    }

    public void writeCacheData(StoredCacheData cacheData, File conf) throws IgniteCheckedException {
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(conf.toPath(), new OpenOption[0]));){
            this.marshaller.marshal(cacheData, stream);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("An error occurred during cache configuration writing to file [file=" + conf.getAbsolutePath() + "]", e);
        }
    }

    public void saveCacheConfiguration(StoredCacheData cacheData, boolean overwrite) throws IgniteCheckedException {
        assert (cacheData != null);
        CacheConfiguration<?, ?> ccfg = cacheData.config();
        if (!CU.storeCacheConfig(this.cacheProcessor.context(), ccfg)) {
            return;
        }
        File cacheWorkDir = this.cacheWorkDir(ccfg);
        FilePageStoreManager.checkAndInitCacheWorkDir(cacheWorkDir, this.log);
        assert (cacheWorkDir.exists()) : "Work directory does not exist: " + cacheWorkDir;
        File file = this.cacheConfigurationFile(ccfg);
        Path filePath = file.toPath();
        this.chgLock.readLock().lock();
        try {
            if (overwrite || !Files.exists(filePath, new LinkOption[0]) || Files.size(filePath) == 0L) {
                File tmp = new File(file.getParent(), file.getName() + ".tmp");
                if (tmp.exists() && !tmp.delete()) {
                    this.log.warning("Failed to delete temporary cache config file(make sure Ignite process has enough rights):" + file.getName());
                }
                this.writeCacheData(cacheData, tmp);
                if (Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) > 0L) {
                    for (BiConsumer<String, File> lsnr : this.lsnrs) {
                        lsnr.accept(ccfg.getName(), file);
                    }
                }
                Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
            throw new IgniteCheckedException("Failed to persist cache configuration: " + ccfg.getName(), ex);
        }
        finally {
            this.chgLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheData(StoredCacheData cacheData) throws IgniteCheckedException {
        this.chgLock.readLock().lock();
        try {
            CacheConfiguration<?, ?> ccfg = cacheData.config();
            File file = this.cacheConfigurationFile(ccfg);
            if (file.exists()) {
                for (BiConsumer<String, File> lsnr : this.lsnrs) {
                    lsnr.accept(ccfg.getName(), file);
                }
                if (!file.delete()) {
                    throw new IgniteCheckedException("Failed to delete cache configuration: " + ccfg.getName());
                }
            }
        }
        finally {
            this.chgLock.readLock().unlock();
        }
    }

    public Collection<String> stopSequence() {
        return this.stopSeq;
    }

    public Set<String> localCachesOnStart() {
        return this.localCachesOnStart;
    }

    public CacheJoinNodeDiscoveryData restoreCacheConfigurations() throws IgniteCheckedException {
        HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> caches = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
        HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo> templates = new HashMap<String, CacheJoinNodeDiscoveryData.CacheInfo>();
        this.restoreCaches(caches, templates, this.ctx.config());
        CacheJoinNodeDiscoveryData discoData = new CacheJoinNodeDiscoveryData(IgniteUuid.randomUuid(), caches, templates, this.startAllCachesOnClientStart());
        this.localCachesOnStart = new HashSet<String>(discoData.caches().keySet());
        return discoData;
    }

    public void addConfigurationChangeListener(BiConsumer<String, File> lsnr) {
        if (this.chgLock.isWriteLockedByCurrentThread()) {
            this.lsnrs.add(lsnr);
        } else {
            this.chgLock.writeLock().lock();
            try {
                this.lsnrs.add(lsnr);
            }
            finally {
                this.chgLock.writeLock().unlock();
            }
        }
    }

    public void removeConfigurationChangeListener(BiConsumer<String, File> lsnr) {
        this.lsnrs.remove(lsnr);
    }

    public void removeCacheGroupConfigurationData(CacheGroupContext ctx) throws IgniteCheckedException {
        File cacheGrpDir = this.cacheWorkDir(ctx.sharedGroup(), ctx.cacheOrGroupName());
        if (cacheGrpDir != null && cacheGrpDir.exists()) {
            DirectoryStream.Filter<Path> cacheCfgFileFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) {
                    return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith("cache_data.dat");
                }
            };
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(cacheGrpDir.toPath(), (DirectoryStream.Filter<? super Path>)cacheCfgFileFilter);){
                for (Path path : dirStream) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to delete cache configurations of group: " + ctx.toString(), e);
            }
        }
    }

    private void readCacheGroupCaches(File grpDir, Map<String, StoredCacheData> ccfgs) throws IgniteCheckedException {
        File[] files = grpDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith("cache_data.dat") || file.length() <= 0L) continue;
            this.readAndAdd(ccfgs, file, cacheName -> "Cache with name=" + cacheName + " is already registered, skipping config file " + file.getName() + " in group directory " + grpDir.getName());
        }
    }

    public void readCacheConfigurations(File dir, Map<String, StoredCacheData> ccfgs) throws IgniteCheckedException {
        if (dir.getName().startsWith("cache-")) {
            File conf = new File(dir, "cache_data.dat");
            if (conf.exists() && conf.length() > 0L) {
                this.readAndAdd(ccfgs, conf, cache -> "Cache with name=" + cache + " is already registered, skipping config file " + dir.getName());
            }
        } else if (dir.getName().startsWith("cacheGroup-")) {
            this.readCacheGroupCaches(dir, ccfgs);
        }
    }

    private void readAndAdd(Map<String, StoredCacheData> ccfgs, File file, Function<String, String> msg) throws IgniteCheckedException {
        StoredCacheData cacheData = GridLocalConfigManager.readCacheData(file, this.marshaller, this.ctx.config());
        String cacheName = cacheData.config().getName();
        if (this.inMemoryCdcCache(cacheData.config())) {
            this.removeCacheData(cacheData);
            U.warn(this.log, "Stored data for in-memory CDC cache removed[name=" + cacheName + ", file=" + file.getName() + "]");
            return;
        }
        if (!ccfgs.containsKey(cacheName)) {
            ccfgs.put(cacheName, cacheData);
        } else {
            U.warn(this.log, msg.apply(cacheName));
        }
    }

    private boolean inMemoryCdcCache(CacheConfiguration<?, ?> cfg) {
        DataRegionConfiguration drCfg = CU.findDataRegion(this.ctx.config().getDataStorageConfiguration(), cfg.getDataRegionName());
        return drCfg != null && !drCfg.isPersistenceEnabled() && drCfg.isCdcEnabled();
    }

    public File cacheConfigurationFile(CacheConfiguration<?, ?> ccfg) {
        File cacheWorkDir = this.cacheWorkDir(ccfg);
        return new File(cacheWorkDir, GridLocalConfigManager.cacheDataFilename(ccfg));
    }

    public static String cacheDataFilename(CacheConfiguration<?, ?> ccfg) {
        return ccfg.getGroupName() == null ? "cache_data.dat" : ccfg.getName() + "cache_data.dat";
    }

    public File cacheWorkDir(CacheConfiguration<?, ?> ccfg) {
        return FilePageStoreManager.cacheWorkDir(this.storeWorkDir, FilePageStoreManager.cacheDirName(ccfg));
    }

    public File cacheWorkDir(boolean isSharedGroup, String cacheOrGroupName) {
        return FilePageStoreManager.cacheWorkDir(this.storeWorkDir, FilePageStoreManager.cacheDirName(isSharedGroup, cacheOrGroupName));
    }

    private boolean startAllCachesOnClientStart() {
        return this.startClientCaches && this.ctx.clientNode();
    }

    private void restoreCaches(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates, IgniteConfiguration igniteCfg) throws IgniteCheckedException {
        Map<String, StoredCacheData> storedCaches;
        CacheConfiguration[] cfgs = igniteCfg.getCacheConfiguration();
        for (int i = 0; i < cfgs.length; ++i) {
            CacheConfiguration cfg;
            cfgs[i] = cfg = new CacheConfiguration(cfgs[i]);
            this.addCacheFromConfiguration(cfg, false, caches, templates);
        }
        if ((CU.isPersistenceEnabled(igniteCfg) && this.ctx.cache().context().pageStore() != null || CU.isCdcEnabled(igniteCfg)) && !F.isEmpty(storedCaches = this.readCacheConfigurations())) {
            ArrayList<String> skippedConfigs = new ArrayList<String>();
            for (StoredCacheData storedCacheData : storedCaches.values()) {
                if (storedCacheData.hasOldCacheConfigurationFormat()) {
                    storedCacheData = new StoredCacheData(storedCacheData);
                    T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.cacheProcessor.splitter().split(storedCacheData.config());
                    storedCacheData.config((CacheConfiguration)((Object)splitCfg.get1()));
                    storedCacheData.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
                    this.saveCacheConfiguration(storedCacheData, true);
                }
                String cacheName = storedCacheData.config().getName();
                CacheType type = this.ctx.cache().cacheType(cacheName);
                if (!caches.containsKey(cacheName)) {
                    this.addStoredCache(caches, storedCacheData, cacheName, type, true, false);
                    continue;
                }
                CacheConfiguration<?, ?> cfg = caches.get(cacheName).cacheData().config();
                CacheConfiguration<?, ?> cfgFromStore = storedCacheData.config();
                this.validateCacheConfigurationOnRestore(cfg, cfgFromStore);
                this.addStoredCache(caches, storedCacheData, cacheName, type, true, this.cacheProcessor.keepStaticCacheConfiguration());
                if (this.cacheProcessor.keepStaticCacheConfiguration() || type != CacheType.USER) continue;
                skippedConfigs.add(cacheName);
            }
            if (!F.isEmpty(skippedConfigs)) {
                U.warn(this.log, "Static configuration for the following caches will be ignored because a persistent cache with the same name already exist (see https://apacheignite.readme.io/docs/cache-configuration for more information): " + skippedConfigs);
            }
        }
    }

    private void addStoredCache(Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, StoredCacheData cacheData, String cacheName, CacheType cacheType, boolean persistedBefore, boolean isStaticallyConfigured) {
        if (!caches.containsKey(cacheName)) {
            if (!cacheType.userCache()) {
                this.stopSeq.addLast(cacheName);
            } else {
                this.stopSeq.addFirst(cacheName);
            }
        }
        caches.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, cacheType, cacheData.sql(), persistedBefore ? 1L : 0L, isStaticallyConfigured));
    }

    private void addCacheFromConfiguration(CacheConfiguration<?, ?> cfg, boolean sql, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> caches, Map<String, CacheJoinNodeDiscoveryData.CacheInfo> templates) throws IgniteCheckedException {
        String cacheName = cfg.getName();
        CU.validateCacheName(cacheName);
        ArrayList ccfgs = new ArrayList(caches.size());
        for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : caches.values()) {
            ccfgs.add(cacheInfo.cacheData().config());
        }
        String err = GridLocalConfigManager.validateIncomingConfiguration(ccfgs, cfg);
        if (err != null) {
            throw new IgniteException(err);
        }
        this.cacheProcessor.cloneCheckSerializable(cfg);
        CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
        this.cacheProcessor.initialize(cfg, cacheObjCtx);
        StoredCacheData cacheData = new StoredCacheData(cfg);
        cacheData.sql(sql);
        T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.cacheProcessor.splitter().split(cfg);
        cacheData.config((CacheConfiguration)((Object)splitCfg.get1()));
        cacheData.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
        cfg = (CacheConfiguration)((Object)splitCfg.get1());
        if (GridCacheUtils.isCacheTemplateName(cacheName)) {
            templates.put(cacheName, new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, CacheType.USER, false, 0L, true));
        } else {
            if (caches.containsKey(cacheName)) {
                throw new IgniteCheckedException("Duplicate cache name found (check configuration and assign unique name to each cache): " + cacheName);
            }
            CacheType cacheType = this.ctx.cache().cacheType(cacheName);
            if (cacheType != CacheType.USER && cfg.getDataRegionName() == null) {
                cfg.setDataRegionName(this.cacheProcessor.context().database().systemDateRegionName());
            }
            this.addStoredCache(caches, cacheData, cacheName, cacheType, false, true);
        }
    }

    @Nullable
    public static String validateIncomingConfiguration(Collection<CacheConfiguration<?, ?>> cacheConfigs, CacheConfiguration<?, ?> cfg) {
        HashMap<String, String> idxNamesPerCache = new HashMap<String, String>();
        String schemaName = QueryUtils.normalizeSchemaName(cfg.getName(), cfg.getSqlSchema());
        for (CacheConfiguration<?, ?> conf0 : cacheConfigs) {
            Collection<QueryEntity> entrs = conf0.getQueryEntities();
            String cacheName = conf0.getName();
            String cacheSchemaName = QueryUtils.normalizeSchemaName(conf0.getName(), conf0.getSqlSchema());
            if (!Objects.equals(cacheSchemaName, schemaName) || CU.isSystemCache(cacheName) || Objects.equals(cacheSchemaName, schemaName) && Objects.equals(cfg.getName(), cacheName)) continue;
            for (QueryEntity ent : entrs) {
                Collection<QueryIndex> idxs = ent.getIndexes();
                for (QueryIndex idx : idxs) {
                    idxNamesPerCache.put(idx.getName(), cacheName);
                }
            }
        }
        if (idxNamesPerCache.isEmpty()) {
            return null;
        }
        Collection<QueryEntity> entrs = cfg.getQueryEntities();
        for (QueryEntity ent : entrs) {
            Collection<QueryIndex> idxs = ent.getIndexes();
            for (QueryIndex idx : idxs) {
                String normalizedIdxName = QueryUtils.normalizeObjectName(idx.getName(), false);
                String cacheName = (String)idxNamesPerCache.get(normalizedIdxName);
                if (cacheName == null) continue;
                return "Duplicate index name for [cache=" + cfg.getName() + ", idxName=" + idx.getName() + "], an equal index name is already configured for [cache=" + cacheName + "]";
            }
        }
        return null;
    }

    private void validateCacheConfigurationOnRestore(CacheConfiguration cfg, CacheConfiguration cfgFromStore) throws IgniteCheckedException {
        assert (cfg != null && cfgFromStore != null);
        boolean staticCfgVal = cfg.isEncryptionEnabled();
        boolean storedVal = cfgFromStore.isEncryptionEnabled();
        if (storedVal != staticCfgVal) {
            throw new IgniteCheckedException("Encrypted flag value differs. Static config value is '" + staticCfgVal + "' and value stored on the disk is '" + storedVal + "'");
        }
    }
}

