/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.criteria;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.table.criteria.CriteriaExceptionMapperUtil;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.AsyncCursor;
import org.apache.ignite3.sql.NoRowSetExpectedException;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

public class QueryCriteriaAsyncCursor<T, R>
implements AsyncCursor<T> {
    private final AsyncResultSet<R> ars;
    @Nullable
    private final Function<R, T> mapper;
    private final Runnable closeRun;

    public QueryCriteriaAsyncCursor(AsyncResultSet<R> ars, @Nullable Function<R, T> mapper, Runnable closeRun) {
        this.ars = ars;
        this.mapper = mapper;
        this.closeRun = closeRun;
    }

    @Override
    public Iterable<T> currentPage() {
        try {
            return CollectionUtils.mapIterable(this.ars.currentPage(), this.mapper, null);
        }
        catch (NoRowSetExpectedException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(CriteriaExceptionMapperUtil.mapToPublicCriteriaException(e));
        }
    }

    @Override
    public int currentPageSize() {
        try {
            return this.ars.currentPageSize();
        }
        catch (NoRowSetExpectedException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(CriteriaExceptionMapperUtil.mapToPublicCriteriaException(e));
        }
    }

    @Override
    public CompletableFuture<? extends AsyncCursor<T>> fetchNextPage() {
        return this.ars.fetchNextPage().thenApply(rs -> {
            if (!this.hasMorePages()) {
                this.closeAsync();
            }
            return this;
        });
    }

    @Override
    public boolean hasMorePages() {
        return this.ars.hasMorePages();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.ars.closeAsync().thenRun(this.closeRun);
    }
}

