/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.maplibre.style.Style;
import org.apache.baremaps.maplibre.tilejson.TileJSON;
import org.apache.baremaps.maplibre.tileset.Tileset;
import org.apache.baremaps.postgres.utils.PostgresUtils;
import org.apache.baremaps.server.SearchResource;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.server.TileJSONResource;
import org.apache.baremaps.server.VectorTileResource;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.tilestore.vector.VectorTileCache;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server with caching capabilities."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine specification of the cache. For instance, 'maximumWeight=1073741824,expireAfterAccess=1h' sets a 1GB cache whose entries expires after one hour."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tilesetPath;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--assets"}, paramLabel="ASSETS", description={"The assets directory."}, required=false)
    private Path assetsPath;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        ConfigReader configReader = new ConfigReader();
        CaffeineSpec caffeineSpec = CaffeineSpec.parse((String)this.cache);
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tilesetPath), Tileset.class);
        DataSource datasource = PostgresUtils.createDataSourceFromObject((Object)tileset.getDatabase());
        int postgresVersion = PostgresUtils.getPostgresVersion((DataSource)datasource);
        try (PostgresTileStore tileStore = new PostgresTileStore(datasource, tileset, postgresVersion);
             VectorTileCache tileCache = new VectorTileCache((TileStore)tileStore, caffeineSpec);){
            Supplier<TileStore> tileStoreSupplier = () -> tileCache;
            Style style = (Style)objectMapper.readValue(configReader.read(this.stylePath), Style.class);
            Supplier<Style> styleSupplier = () -> style;
            TileJSON tileJSON = (TileJSON)objectMapper.readValue(configReader.read(this.tilesetPath), TileJSON.class);
            Supplier<TileJSON> tileJSONSupplier = () -> tileJSON;
            ServerBuilder serverBuilder = Server.builder();
            serverBuilder.http(this.port);
            JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
            serverBuilder.annotatedService("/tiles", (Object)new VectorTileResource(tileStoreSupplier), new Object[]{jsonResponseConverter});
            serverBuilder.annotatedService((Object)new StyleResource(styleSupplier), new Object[]{jsonResponseConverter});
            serverBuilder.annotatedService((Object)new TileJSONResource(tileJSONSupplier), new Object[]{jsonResponseConverter});
            serverBuilder.annotatedService((Object)new SearchResource(datasource), new Object[]{jsonResponseConverter});
            HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static/server.html");
            serverBuilder.service("/", index.asService());
            serverBuilder.serviceUnder("/", (HttpService)FileService.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/static"));
            if (this.assetsPath != null) {
                serverBuilder.serviceUnder("/assets", (HttpService)FileService.of((Path)this.assetsPath));
            }
            serverBuilder.decorator(CorsService.builderForAnyOrigin().allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.HEAD}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.ORIGIN, HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.ACCEPT, HttpHeaderNames.AUTHORIZATION}).allowCredentials().exposeHeaders(new CharSequence[]{HttpHeaderNames.LOCATION}).newDecorator());
            serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
            serverBuilder.disableServerHeader();
            serverBuilder.disableDateHeader();
            Server server = serverBuilder.build();
            CompletableFuture startFuture = server.start();
            startFuture.join();
            CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
            shutdownFuture.join();
        }
        return 0;
    }
}

